/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp.writer;

import java.io.IOException;
import java.util.Iterator;
import javax.servlet.ServletException;
import nga.model.User;
import nga.model.UserAttribute;
import nga.servlet.WriterUtil;
import nga.servlet.config.TargetInfo;
import nga.servlet.config.TargetInfoList;
import nga.servlet.dsp.writer.TargetValueWriter;
import nga.servlet.spi.UserAuth;

public class IAssistantWriter
extends TargetValueWriter {
    public void write() throws IOException, ServletException {
        TargetInfo ti = this.targetValue.getTargetInfo();
        Object resultObject = this.targetValue.getResultObject();
        this.write(ti, resultObject);
    }

    protected void write(TargetInfo ti, Object resultObject) throws ServletException {
        Iterable list;
        String className = ti.getAttribute("class", resultObject, "iassistant");
        String historyId = ti.get("history-id");
        if (historyId != null) {
            User user = UserAuth.getUser(this.targetValue.getServiceInfo());
            if (user != null) {
                UserAttribute userAttr = user.getAttribute();
                list = (Iterable)userAttr.get(historyId);
            } else {
                list = null;
            }
        } else {
            list = (Iterable)this.targetValue.getValue();
        }
        this.print("<table").attr("id", ti.getId()).attr("class", className);
        if (ti.getAttribute("visible", resultObject, true) && list != null) {
            this.attr("style", "display:block");
        } else {
            this.attr("style", "display:none");
        }
        this.print(">");
        if (list != null) {
            this.writeRows(list, ti.getChildren(), ti.get("input-id", ""));
        }
        this.print("</table>");
    }

    private void writeRows(Iterable list, TargetInfoList colInfoList, String inputId) throws ServletException {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            this.print("<tr");
            this.attr("onmouseover", "IAssistant.focus(this)");
            this.attr("onmouseout", "IAssistant.blur(this)");
            this.attr("onmousedown", "IAssistant.selected(this,'" + inputId + "')");
            this.print(">");
            Object rowData = iter.next();
            if (colInfoList != null) {
                for (TargetInfo colInfo : colInfoList) {
                    String propertyName = colInfo.getName();
                    this.print("<td").attr("class", colInfo, rowData).print(">");
                    if (propertyName != null) {
                        String propertyValue = WriterUtil.property(propertyName, rowData, IAssistantWriter.getFormat(colInfo));
                        this.print(propertyValue);
                    }
                    this.print("</td>");
                }
            } else {
                this.print("<td>").print(rowData).print("</td>");
            }
            this.print("</tr>");
        }
    }
}

