/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp.writer;

import java.io.IOException;
import javax.servlet.ServletException;
import nga.servlet.ErrorInfo;
import nga.servlet.config.TargetInfo;
import nga.servlet.dsp.writer.TargetValueWriter;

public class TextInputWriter
extends TargetValueWriter {
    public void write() throws IOException, ServletException {
        int length;
        String type;
        TargetInfo ti = this.targetValue.getTargetInfo();
        Object resultObject = this.targetValue.getResultObject();
        StringBuilder style = new StringBuilder();
        StringBuilder onfocus = new StringBuilder();
        StringBuilder onblur = new StringBuilder();
        StringBuilder onkeyup = new StringBuilder();
        String inputType = ti.get("input-type", "text");
        if (inputType.equalsIgnoreCase("password")) {
            type = "password";
            inputType = "text";
        } else {
            type = "text";
        }
        this.print("<input").attr("type", type).attr("id", ti.getId());
        this.attr("class", ti, resultObject);
        if ("number".equals(inputType)) {
            onfocus.append("ITextInput.delComma(this);");
            length = ti.get("length", 0x7FFFFFFD);
            boolean positiveOnly = ti.get("positive-only", false);
            int scale = ti.get("scale", 0);
            this.attr("onkeypress", scale > 0 ? "ITextInput.chkDec(event)" : "ITextInput.chkInt(event)");
            int ilen = length;
            if (scale > 0) {
                ilen = length - scale;
                ++length;
            }
            if (!positiveOnly) {
                ++length;
            }
            this.attr("maxlength", length);
            this.attr("onchange", "ITextInput.chkNum(event,this," + ilen + "," + scale + "," + positiveOnly + ")");
        } else {
            onfocus.append("this.select();");
            length = ti.get("length", 0);
            if (length > 0) {
                this.attr("maxlength", length);
            }
            if ("alnum".equals(inputType)) {
                this.attr("onchange", "ITextInput.chkAlnum(event,this)");
            }
        }
        this.attr("name", ti.getName());
        String requestOnEnter = ti.get("request-onenter", null);
        if (requestOnEnter != null) {
            onkeyup.append("ITextInput.requestOnEnter(event, '").append(requestOnEnter).append("');");
        }
        String helpMessage = null;
        ErrorInfo.Item errorItem = this.getErrorItem();
        if (errorItem != null) {
            style.append("background-color:pink;");
            helpMessage = errorItem.getMessage();
            this.attr("value", errorItem.getValue());
        } else {
            helpMessage = ti.get("help-message", null);
            this.attr("value", this.targetValue.getValue(), TextInputWriter.getFormat(ti));
        }
        if (helpMessage != null) {
            onfocus.append("IHelpMessage.show(this, '").append(helpMessage).append("');");
            onblur.append("IHelpMessage.hide();");
            this.attr("onmouseover", "IHelpMessage.show(this, '" + helpMessage + "');");
            this.attr("onmouseout", "IHelpMessage.hide();");
        }
        if (!ti.getAttribute("visible", resultObject, true)) {
            style.append("display:none;");
        }
        if (ti.getAttribute("disabled", resultObject, false)) {
            this.attr("disabled", "disabled");
        }
        if (ti.getAttribute("read-only", resultObject, false)) {
            this.attr("readonly", "readonly");
        }
        String assistantId = ti.get("assistant-id");
        String requestOnassist = ti.get("request-onassist");
        if (assistantId != null) {
            onblur.append("IAssistant.hide(this);");
            onkeyup.append("IAssistant.show('").append(assistantId).append("',this");
            if (requestOnassist != null) {
                onkeyup.append(", '").append(requestOnassist).append("'");
            }
            onkeyup.append(");");
            if (ti.get("show-assistant-onfocus", false)) {
                if (requestOnassist != null) {
                    onfocus.append("IAssistant.show('").append(assistantId).append("',this, '").append(requestOnassist).append("');");
                } else {
                    onfocus.append("IAssistant.show('").append(assistantId).append("',this);");
                }
            }
        }
        if (ti.get("show-calendar-onfocus", false)) {
            onfocus.append("ICalendar.show(event);");
        }
        this.attr("onfocus", new String(onfocus));
        if (onblur.length() > 0) {
            this.attr("onblur", new String(onblur));
        }
        if (onkeyup.length() > 0) {
            this.attr("onkeyup", new String(onkeyup));
        }
        this.attr("style", new String(style));
        this.print("/>");
    }
}

