/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.spi;

import javax.servlet.ServletException;
import nga.model.User;
import nga.servlet.ServiceInfo;

public abstract class UserStorage {
    protected UserStorage() {
    }

    private static UserStorage getInstance(ServiceInfo serviceInfo) {
        return serviceInfo.getSingleInstance(UserStorage.class);
    }

    public static void load(ServiceInfo serviceInfo, User user) throws ServletException {
        if (user.isAuthorized()) {
            UserStorage.getInstance(serviceInfo).handleLoad(serviceInfo, user);
        }
    }

    public static void save(ServiceInfo serviceInfo, User user) throws ServletException {
        if (user.isAuthorized()) {
            UserStorage.getInstance(serviceInfo).handleSave(serviceInfo, user);
        }
    }

    protected abstract void handleLoad(ServiceInfo var1, User var2) throws ServletException;

    protected abstract void handleSave(ServiceInfo var1, User var2) throws ServletException;
}

