/*
 * Decompiled with CFR 0.152.
 */
package nga.sql;

import java.sql.Connection;
import nga.util.ClassDictionary;

public abstract class RDB {
    private static ThreadLocal<RDB> rdb = new ThreadLocal();
    private boolean enabledTransactionControl = true;

    protected RDB() {
    }

    public static RDB getInstance() {
        RDB instance = rdb.get();
        if (instance == null) {
            instance = ClassDictionary.getDefaultInstance().newInstance(RDB.class);
            RDB.setInstance(instance);
        }
        return instance;
    }

    public static void setInstance(RDB instance) {
        rdb.set(instance);
    }

    public static Connection getConnection() {
        return RDB.getInstance().handleGetConnection();
    }

    protected abstract Connection handleGetConnection();

    public static void close() {
        RDB.getInstance().handleClose();
    }

    protected abstract void handleClose();

    public static void destroy() {
        RDB.getInstance().handleDestroy();
    }

    protected abstract void handleDestroy();

    public static void begin() {
        if (RDB.isEnabledTransactionControl()) {
            RDB.getInstance().handleBegin();
        }
    }

    protected abstract void handleBegin();

    public static void rollback() {
        if (RDB.isEnabledTransactionControl()) {
            RDB.getInstance().handleRollback();
        }
    }

    protected abstract void handleRollback();

    public static void commit() {
        if (RDB.isEnabledTransactionControl()) {
            RDB.getInstance().handleCommit();
        }
    }

    protected abstract void handleCommit();

    public static boolean isEnabledTransactionControl() {
        return RDB.getInstance().enabledTransactionControl;
    }

    public static void setEnabledTransactionControl(boolean enabledTransactionControl) {
        RDB.getInstance().enabledTransactionControl = enabledTransactionControl;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.handleDestroy();
    }
}

