/*
 * Decompiled with CFR 0.152.
 */
package nga.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import nga.sql.Caller;
import nga.sql.DuplicatedException;
import nga.sql.RDB;
import nga.sql.Selecter;
import nga.sql.Updater;
import nga.sql.impl.CallerImpl;
import nga.sql.impl.SelecterImpl;
import nga.sql.impl.UpdaterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SQL {
    private static int queryTimeout = -1;
    private static int maxRows = Integer.MAX_VALUE;
    private static int batchSize = 100;

    private SQL() {
    }

    public static <R> Selecter<R> createSelecter(Connection connection, Class<? extends R> resultClass, String sql) {
        return new SelecterImpl<R>(connection, resultClass, sql);
    }

    public static <R> Selecter<R> createSelecter(Connection connection, Class<? extends R> resultClass, String sql, Object ... parameterObject) {
        SelecterImpl<R> selecter = new SelecterImpl<R>(connection, resultClass, sql, parameterObject);
        selecter.setMaxRows(SQL.getDefaultMaxRows());
        selecter.setQueryTimeout(SQL.getDefaultQueryTimeout());
        return selecter;
    }

    public static Updater createUpdater(Connection connection, String sql) {
        UpdaterImpl updater = new UpdaterImpl(connection, sql);
        updater.setBatchSize(SQL.getDefaultBatchSize());
        return updater;
    }

    public static Caller createCaller(Connection connection, String sql) {
        return new CallerImpl(connection, sql);
    }

    public static <R> Selecter<R> createSelecter(Class<? extends R> resultClass, String sql) {
        return SQL.createSelecter(RDB.getConnection(), resultClass, sql);
    }

    public static <R> Selecter<R> createSelecter(Class<? extends R> resultClass, String sql, Object ... parameterObject) {
        return SQL.createSelecter(RDB.getConnection(), resultClass, sql, parameterObject);
    }

    public static Updater createUpdater(String sql) {
        return SQL.createUpdater(RDB.getConnection(), sql);
    }

    public static Caller createCaller(String sql) {
        return SQL.createCaller(RDB.getConnection(), sql);
    }

    public static <R> List<R> find(Class<? extends R> resultClass, String sql) throws SQLException {
        return SQL.createSelecter(resultClass, sql).find();
    }

    public static <R> List<R> find(Class<? extends R> resultClass, String sql, Object parameterObject) throws SQLException {
        return SQL.createSelecter(resultClass, sql, parameterObject).find();
    }

    public static <R> List<R> find(Class<? extends R> resultClass, String sql, List<R> list) throws SQLException {
        return SQL.createSelecter(resultClass, sql).find(list);
    }

    public static <R> List<R> find(Class<? extends R> resultClass, String sql, Object parameterObject, List<R> list) throws SQLException {
        return SQL.createSelecter(resultClass, sql, parameterObject).find(list);
    }

    public static <R> R find(Class<? extends R> resultClass, String sql, Object parameterObject, R object) throws SQLException {
        return SQL.createSelecter(resultClass, sql, parameterObject).find(object);
    }

    public static int execute(String sql) throws DuplicatedException, SQLException {
        return SQL.createUpdater(sql).execute();
    }

    public static int execute(String sql, Object parameterObject) throws DuplicatedException, SQLException {
        return SQL.createUpdater(sql).execute(parameterObject);
    }

    public static int[] execute(String sql, List parameterObjectList) throws DuplicatedException, SQLException {
        return SQL.createUpdater(sql).execute(parameterObjectList);
    }

    public static int call(String sql) throws DuplicatedException, SQLException {
        return SQL.createCaller(sql).call();
    }

    public static int call(String sql, Object parameterObject) throws DuplicatedException, SQLException {
        return SQL.createCaller(sql).call(parameterObject);
    }

    public static int getDefaultQueryTimeout() {
        return queryTimeout;
    }

    public static void setDefaultQueryTimeout(int queryTimeout) {
        SQL.queryTimeout = queryTimeout;
    }

    public static int getDefaultMaxRows() {
        return maxRows;
    }

    public static void setDefaultMaxRows(int maxRows) {
        SQL.maxRows = maxRows;
    }

    public static int getDefaultBatchSize() {
        return batchSize;
    }

    public static void setDefaultBatchSize(int size) {
        batchSize = size;
    }
}

