/*
 * Decompiled with CFR 0.152.
 */
package nga.sql;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nga.sql.Caller;
import nga.sql.DuplicatedException;
import nga.sql.RDB;
import nga.sql.SQL;
import nga.sql.Selecter;
import nga.sql.Updater;
import nga.util.ConfigurationException;
import nga.util.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSQL {
    private static XSQL instance = new XSQL();
    private DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
    private Map<String, SQLDefinition> sqlMap = new HashMap<String, SQLDefinition>();
    private int queryTimeout = -1;
    private int maxRows = Integer.MAX_VALUE;
    private int batchSize = 100;
    private static final int TEXT = 0;
    private static final int ADD = 1;
    private static final int AND = 2;
    private static final int OR = 3;
    private static final int INCLUDE = 4;

    private XSQL() {
    }

    private static XSQL getInstance() {
        return instance;
    }

    public static <R> Selecter<R> createSelecter(Connection connection, String sqlId) {
        return XSQL.createSelecter(connection, sqlId, null);
    }

    public static <R> Selecter<R> createSelecter(Connection connection, String sqlId, Object parameterObject) {
        try {
            SQLDefinition def = XSQL.getInstance().getSQLDefinition(sqlId, null);
            Selecter selecter = SQL.createSelecter(connection, def.getResultClass(), def.getSQL(), parameterObject);
            selecter.setMaxRows(XSQL.getDefaultMaxRows());
            selecter.setQueryTimeout(XSQL.getDefaultQueryTimeout());
            def.updateSelecter(selecter);
            return selecter;
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public static Updater createUpdater(Connection connection, String sqlId) {
        try {
            SQLDefinition def = XSQL.getInstance().getSQLDefinition(sqlId, null);
            Updater updater = SQL.createUpdater(connection, def.getSQL());
            updater.setBatchSize(XSQL.getDefaultBatchSize());
            return updater;
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public static Caller createCaller(Connection connection, String sqlId) {
        try {
            SQLDefinition def = XSQL.getInstance().getSQLDefinition(sqlId, null);
            Caller caller = SQL.createCaller(connection, def.getSQL());
            return caller;
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public static <R> Selecter<R> createSelecter(String sqlId) {
        return XSQL.createSelecter(RDB.getConnection(), sqlId);
    }

    public static <R> Selecter<R> createSelecter(String sqlId, Object parameterObject) {
        return XSQL.createSelecter(RDB.getConnection(), sqlId, parameterObject);
    }

    public static Updater createUpdater(String sqlId) {
        return XSQL.createUpdater(RDB.getConnection(), sqlId);
    }

    public static Caller createCaller(String sqlId) {
        return XSQL.createCaller(RDB.getConnection(), sqlId);
    }

    public static <R> List<R> find(String sqlId) throws SQLException {
        return XSQL.createSelecter(sqlId).find();
    }

    public static <R> List<R> find(String sqlId, Object parameterObject) throws SQLException {
        return XSQL.createSelecter(sqlId, parameterObject).find();
    }

    public static <R> List<R> find(String sqlId, List<R> list) throws SQLException {
        return XSQL.createSelecter(sqlId).find(list);
    }

    public static <R> List<R> find(String sqlId, Object parameterObject, List<R> list) throws SQLException {
        return XSQL.createSelecter(sqlId, parameterObject).find(list);
    }

    public static <R> R find(String sqlId, Object parameterObject, R object) throws SQLException {
        return XSQL.createSelecter(sqlId, parameterObject).find(object);
    }

    public static int execute(String sqlId) throws DuplicatedException, SQLException {
        return XSQL.createUpdater(sqlId).execute();
    }

    public static int execute(String sqlId, Object parameterObject) throws DuplicatedException, SQLException {
        return XSQL.createUpdater(sqlId).execute(parameterObject);
    }

    public static int[] execute(String sqlId, List parameterObjectList) throws DuplicatedException, SQLException {
        return XSQL.createUpdater(sqlId).execute(parameterObjectList);
    }

    public static int call(String sqlId) throws DuplicatedException, SQLException {
        return XSQL.createCaller(sqlId).call();
    }

    public static int call(String sqlId, Object parameterObject) throws DuplicatedException, SQLException {
        return XSQL.createCaller(sqlId).call(parameterObject);
    }

    public static int getDefaultQueryTimeout() {
        return XSQL.getInstance().queryTimeout;
    }

    public static void setDefaultQueryTimeout(int queryTimeout) {
        XSQL.getInstance().queryTimeout = queryTimeout;
    }

    public static int getDefaultMaxRows() {
        return XSQL.getInstance().maxRows;
    }

    public static void setDefaultMaxRows(int maxRows) {
        XSQL.getInstance().maxRows = maxRows;
    }

    public static int getDefaultBatchSize() {
        return XSQL.getInstance().batchSize;
    }

    public static void setDefaultBatchSize(int size) {
        XSQL.getInstance().batchSize = size;
    }

    private SQLDefinition getSQLDefinition(String id, String path) throws SAXException, IOException, ParserConfigurationException {
        SQLDefinition sql = this.sqlMap.get(id);
        if (sql == null) {
            int index = id.indexOf(35);
            if (index <= 0) {
                if (path == null) {
                    throw new ConfigurationException(this.message("invalid_id", new Object[0]));
                }
                sql = this.sqlMap.get(path + "#" + id);
                if (sql != null) {
                    return sql;
                }
            } else {
                path = id.substring(0, index);
            }
            this.load(path);
            sql = this.sqlMap.get(id);
            if (sql == null) {
                throw new ConfigurationException(this.message("no_such_sqldef", id));
            }
        }
        return sql;
    }

    private void load(String path) throws SAXException, IOException, ParserConfigurationException {
        Document doc = this.builderFactory.newDocumentBuilder().parse(new BufferedInputStream(this.getClassLoader().getResourceAsStream(path)));
        NodeList list = doc.getElementsByTagName("sql");
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            NamedNodeMap attr = node.getAttributes();
            Node idNode = attr.getNamedItem("id");
            if (idNode == null) {
                throw new ConfigurationException(this.message("invalid_sql_tag", new Object[0]));
            }
            this.sqlMap.put(path + "#" + idNode.getNodeValue(), new SQLDefinition(node, attr, path));
        }
    }

    private ClassLoader getClassLoader() {
        return XSQL.class.getClassLoader();
    }

    private String message(String key, Object ... args) {
        return Resource.getMessage(this.getClass().getPackage().getName() + ".Message", key, args);
    }

    private class SQLFragment {
        private int type;
        private String text;
        private String ifEmpty;
        private String connector;
        private String includeId;

        SQLFragment(Node node) {
            if (node.getNodeType() == 3) {
                this.text = node.getNodeValue();
                this.type = 0;
            } else {
                NamedNodeMap attr = node.getAttributes();
                String name = node.getNodeName();
                if ("add".equalsIgnoreCase(name)) {
                    this.type = 1;
                } else if ("and".equalsIgnoreCase(name)) {
                    this.type = 2;
                } else if ("or".equalsIgnoreCase(name)) {
                    this.type = 3;
                } else if ("include".equalsIgnoreCase(name)) {
                    this.type = 4;
                    this.includeId = this.getAttr(attr, "id");
                    if (this.includeId == null) {
                        throw new ConfigurationException(XSQL.this.message("invalid_include_tag", new Object[0]));
                    }
                    return;
                }
                this.ifEmpty = this.getAttr(attr, "if-empty");
                this.connector = this.getAttr(attr, "connector");
                NodeList child = node.getChildNodes();
                if (child != null && child.getLength() > 0) {
                    this.text = child.item(0).getNodeValue();
                }
                if (this.text == null) {
                    throw new ConfigurationException(XSQL.this.message("invalid_sql_tag_child", new Object[]{node.getNodeName()}));
                }
            }
        }

        public String toString() {
            return this.type + ":" + this.text + ";" + this.ifEmpty + ":" + this.connector + ":" + this.includeId;
        }

        private String getAttr(NamedNodeMap attr, String name) {
            Node node = attr.getNamedItem(name);
            if (node != null) {
                return node.getNodeValue();
            }
            return null;
        }
    }

    private class SQLDefinition {
        private String className;
        private Class cls;
        private List<SQLFragment> fragments = new ArrayList<SQLFragment>();
        private String sql;
        private int index;
        private String path;

        SQLDefinition(Node node, NamedNodeMap attr, String path) {
            this.path = path;
            Node classNode = attr.getNamedItem("class");
            if (classNode != null) {
                this.className = classNode.getNodeValue();
            }
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                SQLFragment sqlFragment = new SQLFragment(nodeList.item(i));
                if (i == 0 && sqlFragment.type != 0 && sqlFragment.type != 4) {
                    throw new ConfigurationException(XSQL.this.message("invalid_sqldef", new Object[]{nodeList.item(i).getNodeName()}));
                }
                this.fragments.add(sqlFragment);
            }
        }

        Class getResultClass() throws ClassNotFoundException {
            if (this.className == null) {
                return null;
            }
            if (this.cls == null) {
                this.cls = Class.forName(this.className);
            }
            return this.cls;
        }

        String getSQL() throws SAXException, IOException, ParserConfigurationException {
            if (this.sql == null) {
                int i;
                StringBuilder sb = new StringBuilder();
                for (i = 0; i < this.fragments.size(); ++i) {
                    SQLFragment fragment = this.fragments.get(i);
                    if (fragment.type == 0) {
                        sb.append(fragment.text).append(' ');
                        continue;
                    }
                    if (fragment.type != 4) break;
                    SQLDefinition def = XSQL.this.getSQLDefinition(fragment.includeId, this.path);
                    sb.append(def.getSQL()).append(' ');
                }
                this.index = i;
                this.sql = new String(sb);
            }
            return this.sql;
        }

        void updateSelecter(Selecter selecter) throws SAXException, IOException, ParserConfigurationException {
            for (int i = this.index; i < this.fragments.size(); ++i) {
                SQLFragment fragment = this.fragments.get(i);
                if (fragment.type == 0) {
                    selecter.add(fragment.text);
                    continue;
                }
                if (fragment.type == 4) {
                    SQLDefinition def = XSQL.this.getSQLDefinition(fragment.includeId, this.path);
                    selecter.add(def.getSQL());
                    continue;
                }
                if (fragment.type == 1) {
                    selecter.add(fragment.text, fragment.connector, fragment.ifEmpty);
                    continue;
                }
                if (fragment.type == 2) {
                    selecter.and(fragment.text, fragment.ifEmpty);
                    continue;
                }
                if (fragment.type != 3) continue;
                selecter.or(fragment.text, fragment.ifEmpty);
            }
        }
    }
}

