/*
 * Decompiled with CFR 0.152.
 */
package nga.sql.impl;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import nga.sql.impl.SQLTypes;
import nga.util.ConfigurationException;
import nga.util.Log;
import nga.util.MethodOperator;
import nga.util.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SQLImplBase {
    private static final String FIELD_SEPARATOR = "@";
    private static final char OUT = '!';
    private static final char INOUT = '#';
    private int fromIndex = -1;
    private int whereIndex = -1;
    private String parsedSQL;
    private Class template;
    private List<Parameter> parameterList;
    private StringBuilder sql;
    protected Connection connection;
    private Log log;
    private PreparedStatement statement;

    public SQLImplBase(Connection con, String sql) {
        if (con == null) {
            throw new IllegalArgumentException(this.message("m_connection_is_null", new Object[0]));
        }
        this.sql = new StringBuilder();
        this.append(sql);
        this.connection = con;
        this.setLog(Log.getInstance());
    }

    public void setLog(Log log) {
        this.log = log;
    }

    protected Log getLog() {
        if (this.log == null) {
            this.log = Log.getInstance();
        }
        return this.log;
    }

    protected String message(String key, Object ... args) {
        return Resource.getMessage(this.getClass().getPackage().getName() + ".SQLImplMessage", key, args);
    }

    private List<Parameter> createParameterList(Class template) {
        if (template == null) {
            return Collections.emptyList();
        }
        Map<String, Method> setterMethods = null;
        Map<String, Method> getterMethods = null;
        if (!template.isArray()) {
            getterMethods = MethodOperator.getGetterMethods(template);
        }
        ArrayList<Parameter> list = new ArrayList<Parameter>(getterMethods != null ? getterMethods.size() : 10);
        StringTokenizer st = new StringTokenizer(new String(this.sql).toUpperCase(), FIELD_SEPARATOR);
        while (st.hasMoreTokens()) {
            st.nextToken();
            if (!st.hasMoreTokens()) break;
            Parameter p = new Parameter();
            String fieldName = st.nextToken();
            if (fieldName.length() == 0) {
                throw new ConfigurationException(this.message("m_invalid_parameter_1", new Object[0]));
            }
            char c = fieldName.charAt(0);
            if (c == '%' || c == '!' || c == '#') {
                if (fieldName.length() == 1) {
                    throw new ConfigurationException(this.message("m_invalid_parameter_2", Character.toString(c)));
                }
                fieldName = fieldName.substring(1);
                if (c == '%') {
                    p.prefix = true;
                } else if (setterMethods == null) {
                    setterMethods = MethodOperator.getSetterMethods(template);
                }
            }
            if (fieldName.charAt(fieldName.length() - 1) == '%') {
                p.suffix = true;
                fieldName = fieldName.substring(0, fieldName.length() - 1);
            }
            if ((c == '!' || c == '#') && setterMethods != null) {
                p.setterMethod = setterMethods.get(fieldName);
            }
            if (c != '!') {
                if (getterMethods != null) {
                    p.getterMethod = getterMethods.get(fieldName);
                }
                this.parseFieldName(p, fieldName);
            }
            list.add(p);
        }
        return list;
    }

    private void parseFieldName(Parameter p, String fieldName) {
        if (p.getterMethod != null) {
            return;
        }
        try {
            p.index = Integer.parseInt(fieldName);
        }
        catch (NumberFormatException e) {
            String tname = this.template.getName();
            throw new ConfigurationException(this.message("m_no_getter_method", tname, fieldName));
        }
    }

    private void setParameter(PreparedStatement stmt, int index, Class type, Object value) throws SQLException {
        if (value == null) {
            if (type != null) {
                stmt.setNull(index, SQLTypes.getSQLType(type));
            } else {
                stmt.setNull(index, SQLTypes.getSQLType(String.class));
            }
        } else if (type.equals(String.class)) {
            stmt.setString(index, (String)value);
        } else if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            stmt.setInt(index, (Integer)value);
        } else if (type.equals(BigDecimal.class)) {
            stmt.setBigDecimal(index, (BigDecimal)value);
        } else if (type.equals(Timestamp.class)) {
            stmt.setTimestamp(index, (Timestamp)value);
        } else if (type.equals(Date.class)) {
            stmt.setDate(index, (Date)value);
        } else if (type.equals(Time.class)) {
            stmt.setTime(index, (Time)value);
        } else if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            stmt.setBoolean(index, (Boolean)value);
        } else if (type.equals(Character.TYPE) || type.equals(Character.class)) {
            stmt.setString(index, String.valueOf(((Character)value).charValue()));
        } else if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            stmt.setLong(index, (Long)value);
        } else if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            stmt.setShort(index, (Short)value);
        } else if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            stmt.setFloat(index, ((Float)value).floatValue());
        } else if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            stmt.setDouble(index, (Double)value);
        } else if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            stmt.setByte(index, (Byte)value);
        } else {
            stmt.setObject(index, value);
        }
    }

    private char getLastChar(StringBuilder sql) {
        for (int i = sql.length() - 1; i >= 0; --i) {
            char c = sql.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return c;
        }
        return '\u0000';
    }

    private void append(String str) {
        int wi;
        String s = str.toUpperCase();
        int fi = s.lastIndexOf("FROM");
        if (fi != -1) {
            this.fromIndex = this.sql.length() + fi;
        }
        if ((wi = s.lastIndexOf("WHERE", fi != -1 ? fi : 0)) != -1) {
            this.whereIndex = this.sql.length() + wi;
        }
        this.sql.append(str);
    }

    protected boolean addWhere(String s) {
        if (this.whereIndex == -1 || this.whereIndex < this.fromIndex) {
            String t = s.trim();
            if (t.length() < 5 || !t.substring(0, 5).equalsIgnoreCase("WHERE")) {
                this.handleAdd0("WHERE", null);
            }
            this.handleAdd0(s, null);
            return true;
        }
        return false;
    }

    protected StringBuilder getUserSQL() {
        return this.sql;
    }

    protected void initParameterList(Class template) {
        if (this.template == null || !this.template.equals(template)) {
            this.template = template;
            this.parameterList = this.createParameterList(template);
        }
    }

    protected boolean isInitialiizedParameterList() {
        return this.template != null;
    }

    protected void close() {
        this.template = null;
        this.parameterList = null;
        try {
            if (this.statement != null) {
                this.statement.close();
                this.statement = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getParsedSQL() {
        if (this.parsedSQL == null) {
            String sqlText = new String(this.sql);
            StringBuilder sb = new StringBuilder(sqlText.length());
            StringTokenizer st = new StringTokenizer(sqlText, FIELD_SEPARATOR);
            while (st.hasMoreTokens()) {
                sb.append(st.nextToken());
                if (!st.hasMoreTokens()) continue;
                sb.append('?');
                st.nextToken();
            }
            this.parsedSQL = new String(sb);
        }
        return this.parsedSQL;
    }

    protected void debug(String message) {
        if (this.isDebugMode()) {
            this.getLog().debug((Object)message, new Object[0]);
        }
    }

    protected PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.statement != null) {
            this.statement.clearParameters();
            return this.statement;
        }
        this.statement = this.prepareStatement(this.connection, sql);
        return this.statement;
    }

    protected PreparedStatement prepareStatement(Connection con, String sql) throws SQLException {
        return con.prepareStatement(sql);
    }

    protected long start() {
        if (this.isDebugMode()) {
            this.debug("**** START SQL EXEC: ");
        }
        return System.currentTimeMillis();
    }

    protected void end(long startTime) {
        if (this.isDebugMode()) {
            this.debug("**** ENDED SQL EXEC: " + (System.currentTimeMillis() - startTime) + "(ms)");
        }
    }

    protected void setParameter(PreparedStatement ps, Object parameters) throws IllegalAccessException, InvocationTargetException, SQLException {
        for (int i = 0; i < this.parameterList.size(); ++i) {
            Parameter p = this.parameterList.get(i);
            if (p.setterMethod != null) {
                Class<?> type = p.setterMethod.getParameterTypes()[0];
                this.registerOutParameter((CallableStatement)ps, i + 1, type);
            }
            if (!p.isGettable()) continue;
            Object o = this.getObject(p, parameters);
            Class<Object> type = null;
            if (p.getterMethod != null) {
                type = p.getterMethod.getReturnType();
            } else {
                Class clazz = type = o != null ? o.getClass() : Object.class;
            }
            if (p.prefix && p.suffix) {
                o = "%" + o + "%";
            } else if (p.prefix) {
                o = "%" + o;
            } else if (p.suffix) {
                o = o + "%";
            }
            this.setParameter(ps, i + 1, type, o);
        }
    }

    protected void getResult(CallableStatement ps, Object obj) throws IllegalAccessException, InvocationTargetException, SQLException {
        for (int i = 0; i < this.parameterList.size(); ++i) {
            Parameter p = this.parameterList.get(i);
            if (p.setterMethod == null) continue;
            Object o = this.getResult(ps, p.setterMethod.getParameterTypes()[0], i + 1);
            MethodOperator.set(p.setterMethod, obj, o);
        }
    }

    private Object getResult(CallableStatement rs, Class type, int index) throws SQLException {
        if (type.equals(String.class)) {
            return rs.getString(index);
        }
        if (type.equals(Integer.TYPE)) {
            return new Integer(rs.getInt(index));
        }
        if (type.equals(BigDecimal.class)) {
            return rs.getBigDecimal(index);
        }
        if (type.equals(Timestamp.class)) {
            return rs.getTimestamp(index);
        }
        if (type.equals(Date.class)) {
            return rs.getDate(index);
        }
        if (type.equals(Time.class)) {
            return rs.getTime(index);
        }
        if (type.equals(Boolean.TYPE)) {
            return new Boolean(rs.getBoolean(index));
        }
        if (type.equals(Character.TYPE)) {
            String s = rs.getString(index);
            if (rs.wasNull()) {
                return new Character('\u0000');
            }
            if (s != null && s.length() > 0) {
                return new Character(s.charAt(0));
            }
            return new Character('\u0000');
        }
        if (type.equals(Long.TYPE)) {
            return new Long(rs.getLong(index));
        }
        if (type.equals(Short.TYPE)) {
            return new Short(rs.getShort(index));
        }
        if (type.equals(Float.TYPE)) {
            return new Float(rs.getFloat(index));
        }
        if (type.equals(Double.TYPE)) {
            return new Double(rs.getDouble(index));
        }
        if (type.equals(Byte.TYPE)) {
            return new Byte(rs.getByte(index));
        }
        if (type.equals(Integer.class)) {
            int i = rs.getInt(index);
            if (rs.wasNull()) {
                return null;
            }
            return new Integer(i);
        }
        if (type.equals(Boolean.class)) {
            boolean b = rs.getBoolean(index);
            if (rs.wasNull()) {
                return null;
            }
            return new Boolean(b);
        }
        if (type.equals(Long.class)) {
            long l = rs.getLong(index);
            if (rs.wasNull()) {
                return null;
            }
            return new Long(l);
        }
        if (type.equals(Short.class)) {
            short s = rs.getShort(index);
            if (rs.wasNull()) {
                return null;
            }
            return new Short(s);
        }
        if (type.equals(Float.class)) {
            float f = rs.getFloat(index);
            if (rs.wasNull()) {
                return null;
            }
            return new Float(f);
        }
        if (type.equals(Double.class)) {
            double d = rs.getDouble(index);
            if (rs.wasNull()) {
                return null;
            }
            return new Double(d);
        }
        if (type.equals(Byte.class)) {
            byte b = rs.getByte(index);
            if (rs.wasNull()) {
                return null;
            }
            return new Byte(b);
        }
        if (type.equals(Character.class)) {
            String s = rs.getString(index);
            if (rs.wasNull()) {
                return null;
            }
            if (s.length() > 0) {
                return new Character(s.charAt(0));
            }
            return null;
        }
        return rs.getObject(index);
    }

    private void registerOutParameter(CallableStatement ps, int i, Class type) throws SQLException {
        ps.registerOutParameter(i, SQLTypes.getSQLType(type));
    }

    private Object getObject(Parameter p, Object parameters) throws IllegalAccessException, InvocationTargetException {
        if (p.index > -1) {
            return Array.get(parameters, p.index);
        }
        if (parameters != null && parameters.getClass().isArray()) {
            parameters = Array.get(parameters, 0);
        }
        return MethodOperator.get(p.getterMethod, parameters);
    }

    protected void printSQL(String sql, Object params) {
        if (!this.isDebugMode()) {
            return;
        }
        try {
            StringBuilder sb = new StringBuilder(sql.length() + 100);
            if (params == null) {
                sb.append(sql);
            } else {
                StringTokenizer st = new StringTokenizer(sql, "?");
                int i = 0;
                while (st.hasMoreTokens()) {
                    sb.append(st.nextToken());
                    if (this.parameterList != null && i < this.parameterList.size()) {
                        Parameter p = this.parameterList.get(i);
                        if (!p.isGettable()) {
                            sb.append("?");
                        } else {
                            sb.append('\'');
                            if (p.prefix) {
                                sb.append("%");
                            }
                            sb.append(this.getObject(p, params));
                            if (p.suffix) {
                                sb.append("%");
                            }
                            sb.append('\'');
                        }
                    }
                    ++i;
                }
            }
            sb.append(';');
            this.debug(new String(sb));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean isEmpty() {
        return this.sql.length() == 0;
    }

    protected void handleAnd(String s, String ifEmpty) {
        if ((s = this.getAddString(s, true, ifEmpty)) == null) {
            return;
        }
        if (this.addWhere(s)) {
            return;
        }
        this.handleAdd0(s, "AND");
    }

    protected void handleOr(String s, String ifEmpty) {
        if ((s = this.getAddString(s, true, ifEmpty)) == null) {
            return;
        }
        if (this.addWhere(s)) {
            return;
        }
        this.handleAdd0(s, "OR");
    }

    protected void handleAdd(String s, String delimiter, String ifEmpty) {
        if ((s = this.getAddString(s, delimiter != null, ifEmpty)) == null) {
            return;
        }
        this.handleAdd0(s, delimiter);
    }

    private String getAddString(String s, boolean delimiter, String ifEmpty) {
        if (delimiter && !this.checkAdd(s)) {
            if (ifEmpty == null) {
                return null;
            }
            return ifEmpty;
        }
        return s;
    }

    private void handleAdd0(String s, String delimiter) {
        this.parsedSQL = null;
        this.sql.append(' ');
        if (delimiter != null && delimiter.length() > 0 && this.getLastChar(this.sql) != '(') {
            this.sql.append(delimiter);
            this.sql.append(' ');
        }
        this.append(s);
    }

    protected boolean checkAdd(String s) {
        return true;
    }

    protected boolean isDebugMode() {
        return this.getLog().isDebugEnabled();
    }

    public String toString() {
        return new String(this.sql);
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    protected Class getTemplate(Object[] o) {
        if (o == null) {
            return null;
        }
        if (o.length == 1) {
            return Array.get(o, 0).getClass();
        }
        return o.getClass();
    }

    public PreparedStatement getPreparedStatement() throws SQLException {
        if (this.statement == null) {
            this.prepareStatement(this.getParsedSQL());
        }
        return this.statement;
    }

    private class Parameter {
        private boolean prefix;
        private boolean suffix;
        private int index = -1;
        private Method getterMethod;
        private Method setterMethod;

        private Parameter() {
        }

        private boolean isGettable() {
            return this.getterMethod != null || this.index > -1;
        }
    }
}

