/*
 * Decompiled with CFR 0.152.
 */
package nga.sql.impl;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

class SQLTypes {
    static int CharType = 12;
    static int BinType = -3;

    SQLTypes() {
    }

    public static int getSQLType(Class javatype) {
        if (javatype.equals(String.class)) {
            return CharType;
        }
        if (javatype.equals(Integer.TYPE) || javatype.equals(Integer.class)) {
            return 4;
        }
        if (javatype.equals(Long.TYPE) || javatype.equals(Long.class)) {
            return -5;
        }
        if (javatype.equals(Float.TYPE) || javatype.equals(Float.class)) {
            return 7;
        }
        if (javatype.equals(Double.TYPE) || javatype.equals(Double.class)) {
            return 8;
        }
        if (javatype.equals(Short.TYPE) || javatype.equals(Short.class)) {
            return 5;
        }
        if (javatype.equals(Byte.TYPE) || javatype.equals(Byte.class)) {
            return -6;
        }
        if (javatype.equals(Boolean.TYPE) || javatype.equals(Boolean.class)) {
            return -7;
        }
        if (javatype.equals(BigDecimal.class)) {
            return 2;
        }
        if (javatype.equals(java.sql.Date.class)) {
            return 91;
        }
        if (javatype.equals(Time.class)) {
            return 92;
        }
        if (javatype.equals(Timestamp.class) || Date.class.isAssignableFrom(javatype)) {
            return 93;
        }
        return 1111;
    }

    public static Class getJavaType(int sqltype, boolean nullable) {
        switch (sqltype) {
            case -5: {
                return nullable ? Long.class : Long.TYPE;
            }
            case -7: {
                return nullable ? Boolean.class : Boolean.TYPE;
            }
            case 1: {
                return String.class;
            }
            case 91: {
                return java.sql.Date.class;
            }
            case 3: {
                return BigDecimal.class;
            }
            case 8: {
                return nullable ? Double.class : Double.TYPE;
            }
            case 6: {
                return nullable ? Double.class : Double.TYPE;
            }
            case 4: {
                return nullable ? Integer.class : Integer.TYPE;
            }
            case -1: {
                return String.class;
            }
            case 2: {
                return BigDecimal.class;
            }
            case 7: {
                return nullable ? Float.class : Float.TYPE;
            }
            case 5: {
                return nullable ? Short.class : Short.TYPE;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case -6: {
                return nullable ? Byte.class : Byte.TYPE;
            }
            case 12: {
                return String.class;
            }
        }
        return Object.class;
    }
}

