/*
 * Decompiled with CFR 0.152.
 */
package nga.sql.impl;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import nga.sql.DuplicatedException;
import nga.sql.Updater;
import nga.sql.impl.SQLImplBase;
import nga.util.ConfigurationException;

public class UpdaterImpl
extends SQLImplBase
implements Updater {
    private int batchSize;
    private int counter;
    private List<int[]> rcList;

    public UpdaterImpl(Connection con, String sql) {
        super(con, sql);
    }

    public void setBatchSize(int size) {
        this.batchSize = size;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int[] execute(List params) throws DuplicatedException, SQLException {
        if (this.connection.getMetaData().supportsBatchUpdates() && this.batchSize > 1) {
            return this.executeBatch1(params);
        }
        return this.executeBatch2(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] executeBatch1(List params) throws DuplicatedException, SQLException {
        long startTime = this.start();
        PreparedStatement ps = this.getPreparedStatement();
        try {
            for (int i = 0; i < params.size(); ++i) {
                this.addBatch0(ps, params.get(i));
            }
            int[] nArray = this.executeBatch0();
            return nArray;
        }
        finally {
            this.end(startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] executeBatch2(List params) throws DuplicatedException, SQLException {
        PreparedStatement ps = this.getPreparedStatement();
        long startTime = this.start();
        Class<?> c = null;
        if (params.size() > 0) {
            c = params.get(0).getClass();
        }
        this.initParameterList(c);
        try {
            int[] rc = new int[params.size()];
            for (int i = 0; i < rc.length; ++i) {
                rc[i] = this.execute0(params.get(i), ps);
            }
            int[] nArray = rc;
            return nArray;
        }
        finally {
            this.close();
            this.end(startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch(Object parameterObject) throws DuplicatedException, SQLException {
        long startTime = this.start();
        try {
            this.addBatch0(this.getPreparedStatement(), parameterObject);
        }
        finally {
            this.end(startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws DuplicatedException, SQLException {
        long startTime = this.start();
        try {
            int[] nArray = this.executeBatch0();
            return nArray;
        }
        finally {
            this.end(startTime);
        }
    }

    private int[] executeBatch0() throws DuplicatedException, SQLException {
        try {
            int rest = (this.counter - 1) % this.batchSize;
            if (rest > 0) {
                if (this.rcList == null) {
                    this.rcList = new ArrayList<int[]>();
                }
                this.rcList.add(this.getPreparedStatement().executeBatch());
            }
            int length = 0;
            for (int i = 0; i < this.rcList.size(); ++i) {
                length += this.rcList.get(i).length;
            }
            int[] rc = new int[length];
            int pos = 0;
            for (int i = 0; i < this.rcList.size(); ++i) {
                int[] tmp = this.rcList.get(i);
                System.arraycopy(tmp, 0, rc, pos, tmp.length);
                pos += tmp.length;
            }
            int[] nArray = rc;
            return nArray;
        }
        catch (SQLException e) {
            if ("23000".equals(e.getSQLState())) {
                throw new DuplicatedException(e);
            }
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        finally {
            this.close();
        }
    }

    private void addBatch0(PreparedStatement ps, Object parameterObject) throws DuplicatedException, SQLException {
        if (parameterObject != null && !this.isInitialiizedParameterList()) {
            this.initParameterList(parameterObject.getClass());
        }
        try {
            if (parameterObject != null) {
                this.setParameter(ps, parameterObject);
            }
            this.printSQL(this.getParsedSQL(), parameterObject);
            ps.addBatch();
            if (this.counter != 0 && this.counter % this.batchSize == 0) {
                if (this.rcList == null) {
                    this.rcList = new ArrayList<int[]>();
                }
                this.rcList.add(ps.executeBatch());
            }
            ++this.counter;
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException(e.getCause().getMessage(), e.getCause());
        }
        catch (SQLException e) {
            if ("23000".equals(e.getSQLState())) {
                throw new DuplicatedException(e);
            }
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    public int execute() throws DuplicatedException, SQLException {
        return this.execute((Object)null);
    }

    public int execute(Object params) throws DuplicatedException, SQLException {
        return this.execute(this.getPreparedStatement(), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execute(PreparedStatement ps, Object params) throws DuplicatedException, SQLException {
        long startTime = this.start();
        Class<?> c = null;
        if (params != null) {
            c = params.getClass();
        }
        this.initParameterList(c);
        try {
            int n = this.execute0(params, ps);
            return n;
        }
        finally {
            this.end(startTime);
            this.close();
        }
    }

    private int execute0(Object params, PreparedStatement ps) throws DuplicatedException, SQLException {
        try {
            if (params != null) {
                this.setParameter(ps, params);
            }
            this.printSQL(this.getParsedSQL(), params);
            return this.executeUpdate(ps, params);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException(e.getCause().getMessage(), e.getCause());
        }
        catch (SQLException e) {
            if ("23000".equals(e.getSQLState())) {
                throw new DuplicatedException(e);
            }
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    protected int executeUpdate(PreparedStatement ps, Object params) throws SQLException, IllegalAccessException, InvocationTargetException {
        return ps.executeUpdate();
    }

    protected void close() {
        this.counter = 0;
        super.close();
    }
}

