/*
 * Decompiled with CFR 0.152.
 */
package nga.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import nga.util.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDictionary {
    private static ClassDictionary defaultInstance;
    private Map<Class, Class> dictionary = new HashMap<Class, Class>();
    private Map<Class, Object> singleInstance = new HashMap<Class, Object>();

    public ClassDictionary() {
    }

    public ClassDictionary(Properties props) throws ClassNotFoundException {
        this.init();
        this.init(props);
    }

    public ClassDictionary(String path) throws ClassNotFoundException, IOException {
        this.init();
        this.init(new FileInputStream(path));
    }

    private void init() {
        ClassDictionary di = ClassDictionary.getDefaultInstance();
        this.dictionary.putAll(di.dictionary);
        this.singleInstance.putAll(di.singleInstance);
    }

    private void init(InputStream is) throws ClassNotFoundException, IOException {
        Properties props = new Properties();
        props.load(is);
        this.init(props);
    }

    private void init(Properties props) throws ClassNotFoundException {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            Class<?> c1 = Class.forName((String)entry.getKey());
            Class<?> c2 = Class.forName((String)entry.getValue());
            this.setClassImplements(c1, c2);
        }
    }

    public static ClassDictionary getDefaultInstance() {
        if (defaultInstance == null) {
            ClassDictionary cd = new ClassDictionary();
            try {
                Properties props = new Properties();
                ResourceBundle bundle = ResourceBundle.getBundle("nga.util.resource.ClassDictionary");
                Enumeration<String> en = bundle.getKeys();
                while (en.hasMoreElements()) {
                    String key = en.nextElement();
                    props.put(key, bundle.getString(key));
                }
                cd.init(props);
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
            defaultInstance = cd;
        }
        return defaultInstance;
    }

    public <T> T newInstance(Class<T> cls) {
        if (cls == null) {
            throw new ConfigurationException("cls argument is null");
        }
        Class<T> c = this.getClassImplements(cls);
        if (c == null) {
            c = cls;
        }
        try {
            return c.newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException(c.getName(), e);
        }
    }

    public <T> T getSingleInstance(Class<T> cls) {
        Object instance = this.singleInstance.get(cls);
        if (instance == null) {
            instance = this.newInstance(cls);
            this.singleInstance.put(cls, instance);
        }
        return (T)instance;
    }

    public <T> void setClassImplements(Class<T> a, Class<? extends T> b) {
        this.dictionary.put(a, b);
    }

    public <T> Class<? extends T> getClassImplements(Class<T> c) {
        return this.dictionary.get(c);
    }
}

