/*
 * Decompiled with CFR 0.152.
 */
package nga.util;

public class TextWalker {
    private String text;
    private int offset;
    private int count;
    private int index;
    private boolean spaceSkip = true;
    private boolean commentSkip = true;
    private char commentChar = (char)35;
    private char escapeChar;
    private char[] wordSeparators = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '`', '{', '|', '}', '~'};
    private TextWalker child;
    private int marked;

    public TextWalker(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        this.text = str;
        this.count = this.text.length();
    }

    private TextWalker() {
    }

    private TextWalker getTextWalker(int start, int end) {
        if (this.child == null) {
            this.child = new TextWalker();
            this.child.text = this.text;
            this.child.spaceSkip = this.spaceSkip;
            this.child.commentSkip = this.commentSkip;
            this.child.commentChar = this.commentChar;
            this.child.escapeChar = this.escapeChar;
            this.child.wordSeparators = this.wordSeparators;
        }
        this.child.offset = start;
        this.child.index = start;
        this.child.count = this.getEnd(start, end);
        return this.child;
    }

    private int getEnd(int start, int end) {
        if (this.spaceSkip) {
            while (start < end && this.isSpace(this.text.charAt(end - 1))) {
                --end;
            }
        }
        return end;
    }

    public void setEscapeChar(char c) {
        this.escapeChar = c;
        if (this.child != null) {
            this.child.setEscapeChar(c);
        }
    }

    public final char getEscapeChar() {
        return this.escapeChar;
    }

    public void setSpaceSkip(boolean b) {
        this.spaceSkip = b;
        if (this.child != null) {
            this.child.setSpaceSkip(b);
        }
    }

    public final boolean isSpaceSkip() {
        return this.spaceSkip;
    }

    public void setCommentSkip(boolean b) {
        this.commentSkip = b;
        if (this.child != null) {
            this.child.setCommentSkip(b);
        }
    }

    public final boolean isCommentSkip() {
        return this.commentSkip;
    }

    public void setCommentChar(char c) {
        this.commentChar = c;
        if (this.child != null) {
            this.child.setCommentChar(c);
        }
    }

    public final char getCommentChar() {
        return this.commentChar;
    }

    public void setWordSeparators(char[] separators) {
        this.wordSeparators = separators;
        if (this.child != null) {
            this.child.setWordSeparators(separators);
        }
    }

    public char[] getWordSeparators() {
        return this.wordSeparators;
    }

    public final boolean isWalking() {
        return this.index < this.count;
    }

    public final int getCurrentIndex() {
        return this.index - this.offset;
    }

    public final void moveCurrentIndex(int count) {
        int newIndex = this.index + count;
        if (newIndex > this.count || newIndex < this.offset) {
            return;
        }
        this.index = newIndex;
    }

    public final char getCurrentChar() {
        return this.index < this.count ? this.text.charAt(this.index) : (char)'\uffff';
    }

    public final char getChar(int i) {
        return (i += this.index) < 0 || i >= this.text.length() ? (char)'\uffff' : this.text.charAt(i);
    }

    public boolean startsWith(String s) {
        return this.text.startsWith(s, this.index);
    }

    public boolean startsWith(char c) {
        return this.text.charAt(this.index) == c;
    }

    public void trimHead(String s) {
        if (this.startsWith(s)) {
            this.index += s.length();
            this.skip();
        }
    }

    public void trimHead(char c) {
        if (this.startsWith(c)) {
            ++this.index;
            this.skip();
        }
    }

    public boolean endsWith(String s) {
        return this.text.startsWith(s, this.count - s.length());
    }

    public boolean endsWith(char c) {
        return this.text.charAt(this.count - 1) == c;
    }

    public void trimTail(String s) {
        if (this.endsWith(s)) {
            this.count = this.getEnd(this.index, this.count - s.length());
        }
    }

    public void trimTail(char c) {
        if (this.endsWith(c)) {
            this.count = this.getEnd(this.index, this.count - 1);
        }
    }

    public final String getText() {
        return this.text.substring(this.offset, this.count);
    }

    public final int length() {
        return this.count > this.offset ? this.count - this.offset : 0;
    }

    private int indexOf(int ch, int i, int max) {
        String text = this.text;
        while (i < max) {
            char c = text.charAt(i);
            if (c == this.escapeChar) {
                i = this.processEscape(i, max);
            } else if (c == ch) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int indexOf(char[] ch, int i, int max) {
        String text = this.text;
        while (i < max) {
            char c = text.charAt(i);
            if (c == this.escapeChar) {
                i = this.processEscape(i, max);
            } else {
                for (int j = 0; j < ch.length; ++j) {
                    if (c != ch[j]) continue;
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    private int indexOf(int c1, int c2, int i, int max) {
        String text = this.text;
        int cnt = 0;
        while (i < max) {
            char c = text.charAt(i);
            if (c == this.escapeChar) {
                i = this.processEscape(i, max);
            } else if (c == c1) {
                ++cnt;
            } else if (c == c2) {
                if (cnt == 0) {
                    return i;
                }
                --cnt;
            }
            ++i;
        }
        return -1;
    }

    private int indexOfEndOfLine(int i, int max) {
        String text = this.text;
        while (i < max) {
            char c = text.charAt(i);
            if (c == this.escapeChar) {
                i = this.processEscape(i, max);
            } else if (c == '\r' || c == '\n') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int indexOf(String s1, String s2, int i, int ed) {
        String text = this.text;
        if (i >= ed) {
            return -1;
        }
        int cnt = 0;
        int len1 = s1.length();
        int len = s2.length();
        if (len == 0) {
            return 0;
        }
        int max = ed - len;
        char first1 = s1.charAt(0);
        char first2 = s2.charAt(0);
        block0: while (true) {
            block10: {
                block12: {
                    char c;
                    block11: {
                        if (i > max) break block10;
                        c = text.charAt(i);
                        if (c != this.escapeChar) break block11;
                        i = this.processEscape(i, max);
                        break block12;
                    }
                    if (c == first1 && text.regionMatches(i, s1, 0, len1)) {
                        ++cnt;
                        i += len1;
                        continue;
                    }
                    if (c == first2) break block10;
                }
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + len - 1;
            int k = 1;
            while (j < end) {
                if (text.charAt(j++) == s2.charAt(k++)) continue;
                ++i;
                continue block0;
            }
            if (cnt == 0) {
                return i;
            }
            --cnt;
            ++i;
        }
    }

    private int indexOf(String s2, int i, int ed) {
        String text = this.text;
        if (i >= ed) {
            return -1;
        }
        int len = s2.length();
        if (len == 0) {
            return 0;
        }
        int max = ed - len;
        char first = s2.charAt(0);
        block0: while (true) {
            block8: {
                block10: {
                    char c;
                    block9: {
                        if (i > max) break block8;
                        c = text.charAt(i);
                        if (c != this.escapeChar) break block9;
                        i = this.processEscape(i, max);
                        break block10;
                    }
                    if (c == first) break block8;
                }
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + len - 1;
            int k = 1;
            while (j < end) {
                if (text.charAt(j++) == s2.charAt(k++)) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public TextWalker between(char c1, char c2) {
        int max = this.count;
        int start = this.indexOf(c1, this.index, max) + 1;
        if (start == 0) {
            return null;
        }
        start = this.skip(start, max);
        int end = c1 != c2 ? this.indexOf(c1, c2, start, max) : this.indexOf(c2, start, max);
        if (end == -1) {
            return null;
        }
        this.index = this.skip(end + 1, max);
        return this.getTextWalker(start, end);
    }

    public TextWalker between(String s1, String s2) {
        int max = this.count;
        int start = this.indexOf(s1, this.index, max);
        if (start == -1) {
            return null;
        }
        start += s1.length();
        start = this.skip(start, max);
        int end = !s1.equals(s2) ? this.indexOf(s1, s2, start, max) : this.indexOf(s2, start, max);
        if (end == -1) {
            return null;
        }
        this.index = this.skip(end + s2.length(), max);
        return this.getTextWalker(start, end);
    }

    public TextWalker search(char c) {
        return this.search(c, true);
    }

    public TextWalker search(char c, boolean next) {
        return this.move(c, false, next);
    }

    public TextWalker search(String s) {
        return this.search(s, true);
    }

    public TextWalker search(String s, boolean next) {
        return this.move(s, false, next);
    }

    public TextWalker get() {
        int start = this.skip(this.index, this.count);
        this.index = this.count;
        return this.getTextWalker(start, this.count);
    }

    public TextWalker get(char c) {
        return this.get(c, true);
    }

    public TextWalker get(char c, boolean next) {
        return this.move(c, true, next);
    }

    public TextWalker get(String s) {
        return this.get(s, true);
    }

    public TextWalker get(String s, boolean next) {
        return this.move(s, true, next);
    }

    public TextWalker getLine() {
        String text = this.text;
        int max = this.count;
        int start = this.skip(this.index, max);
        int end = this.indexOfEndOfLine(start, max);
        if (end == -1) {
            this.index = max;
            return this.getTextWalker(start, max);
        }
        this.index = end + 1 < max && text.charAt(end) == '\r' && text.charAt(end + 1) == '\n' ? this.skip(end + 2, max) : this.skip(end + 1, max);
        return this.getTextWalker(start, end);
    }

    private TextWalker move(char c, boolean all, boolean next) {
        int max = this.count;
        int start = this.skip(this.index, max);
        int end = this.indexOf(c, start, max);
        if (end == -1) {
            if (all) {
                this.index = max;
                return this.getTextWalker(start, max);
            }
            return null;
        }
        this.index = next ? this.skip(end + 1, max) : end;
        return this.getTextWalker(start, end);
    }

    private TextWalker move(String s, boolean all, boolean next) {
        int max = this.count;
        int start = this.skip(this.index, max);
        int end = this.indexOf(s, start, max);
        if (end == -1) {
            if (all) {
                this.index = max;
                return this.getTextWalker(start, max);
            }
            return null;
        }
        this.index = next ? this.skip(end + s.length(), max) : end;
        return this.getTextWalker(start, end);
    }

    public char which(char[] c) {
        int max = this.count;
        int start = this.skip(this.index, max);
        int end = this.indexOf(c, start, max);
        if (end == -1) {
            return '\uffff';
        }
        this.index = this.skip(end, max);
        return this.getCurrentChar();
    }

    public String betweenString(char c1, char c2) {
        int start = this.indexOf(c1, this.index, this.count) + 1;
        if (start == 0) {
            return null;
        }
        if (c1 != c2) {
            return this.nextString(start, c1, c2, false);
        }
        return this.move(start, c2, false, true);
    }

    private boolean isSpace(char c) {
        return c <= ' ';
    }

    private String nextString(int i, char c1, char c2, boolean all) {
        String text = this.text;
        int max = this.count;
        StringBuffer sb = new StringBuffer(max > (i = this.skip(i, max)) ? max - i : 2);
        int cnt = 0;
        while (i < max) {
            char c = text.charAt(i);
            if (c == this.escapeChar) {
                if (++i < max) {
                    sb.append(text.charAt(i));
                }
                if (text.charAt(i) == '\r' && i + 1 < max && text.charAt(i + 1) == '\n') {
                    sb.append(text.charAt(++i));
                }
            } else if (this.commentSkip && c == this.commentChar) {
                boolean r = true;
                if (i > 0 && (text.charAt(i - 1) == '\r' || text.charAt(i - 1) == '\n')) {
                    r = false;
                }
                while (++i < max && text.charAt(i) != '\n' && text.charAt(i) != '\r') {
                }
                if (r && i < max) {
                    sb.append(text.charAt(i));
                }
                if (i + 1 < max && text.charAt(i) == '\r' && text.charAt(i + 1) == '\n') {
                    ++i;
                    if (r) {
                        sb.append(text.charAt(i));
                    }
                }
            } else if (c == c1) {
                ++cnt;
                sb.append(c1);
            } else if (c == c2) {
                if (cnt == 0) break;
                --cnt;
                sb.append(c2);
            } else {
                sb.append(c);
            }
            ++i;
        }
        if (i < max) {
            this.index = this.skip(i + 1, this.count);
        } else if (all) {
            this.index = max;
        } else {
            return null;
        }
        return this.newString(sb);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String move(int i, char c2, boolean all, boolean next) {
        String text = this.text;
        int max = this.count;
        if (!this.commentSkip && this.escapeChar == '\u0000') {
            int end = this.indexOf(c2, i, max);
            if (end == -1) {
                if (!all) return null;
                this.index = end = max;
            } else {
                this.index = next ? this.skip(end + 1, max) : end;
            }
            if (!this.spaceSkip) return text.substring(i, end);
            return text.substring(i, end).trim();
        }
        StringBuffer sb = new StringBuffer(max > (i = this.skip(i, max)) ? max - i : 2);
        while (i < max) {
            char c = text.charAt(i);
            if (c == this.escapeChar) {
                if (++i < max) {
                    sb.append(text.charAt(i));
                }
                if (text.charAt(i) == '\r' && i + 1 < max && text.charAt(i + 1) == '\n') {
                    sb.append(text.charAt(++i));
                }
            } else if (this.commentSkip && c == this.commentChar) {
                boolean r = true;
                if (i > 0 && (text.charAt(i - 1) == '\r' || text.charAt(i - 1) == '\n')) {
                    r = false;
                }
                while (++i < max && text.charAt(i) != '\n' && text.charAt(i) != '\r') {
                }
                if (r && i < max) {
                    sb.append(text.charAt(i));
                }
                if (i + 1 < max && text.charAt(i) == '\r' && text.charAt(i + 1) == '\n') {
                    ++i;
                    if (r) {
                        sb.append(text.charAt(i));
                    }
                }
            } else {
                if (c == c2) break;
                sb.append(c);
            }
            ++i;
        }
        if (i < max) {
            this.index = next ? this.skip(i + 1, max) : i;
            return this.newString(sb);
        } else {
            if (!all) return null;
            this.index = max;
        }
        return this.newString(sb);
    }

    public String betweenString(String s1, String s2) {
        TextWalker tw = this.between(s1, s2);
        if (tw == null) {
            return null;
        }
        return tw.getString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String move(int i, String s2, boolean all, boolean next) {
        int end;
        String text = this.text;
        if (!this.commentSkip && this.escapeChar == '\u0000') {
            int end2 = this.indexOf(s2, i, this.count);
            if (end2 == -1) {
                if (!all) return null;
                this.index = end2 = this.count;
            } else {
                this.index = next ? this.skip(end2 + s2.length(), this.count) : end2;
            }
            if (!this.spaceSkip) return text.substring(i, end2);
            return text.substring(i, end2).trim();
        }
        int len = s2.length();
        if (len == 0) {
            return s2;
        }
        int max = this.count - len;
        i = this.skip(i, max);
        char first = s2.charAt(0);
        StringBuffer sb = new StringBuffer(max > i ? max - i : 2);
        block0: while (true) {
            block18: {
                block20: {
                    char c;
                    block21: {
                        block19: {
                            if (i > max) break block18;
                            c = text.charAt(i);
                            if (c != this.escapeChar) break block19;
                            if (++i < max) {
                                sb.append(text.charAt(i));
                            }
                            if (text.charAt(i) == '\r' && i + 1 < max && text.charAt(i + 1) == '\n') {
                                sb.append(text.charAt(++i));
                            }
                            break block20;
                        }
                        if (!this.commentSkip || c != this.commentChar) break block21;
                        boolean r = true;
                        if (i > 0 && (text.charAt(i - 1) == '\r' || text.charAt(i - 1) == '\n')) {
                            r = false;
                        }
                        while (++i < max && text.charAt(i) != '\n' && text.charAt(i) != '\r') {
                        }
                        if (r && i < max) {
                            sb.append(text.charAt(i));
                        }
                        if (i + 1 < max && text.charAt(i) == '\r' && text.charAt(i + 1) == '\n') {
                            ++i;
                            if (r) {
                                sb.append(text.charAt(i));
                            }
                        }
                        break block20;
                    }
                    if (c == first) break block18;
                    sb.append(c);
                }
                ++i;
                continue;
            }
            if (i > max) {
                if (!all) return null;
                this.index = this.count;
                sb.append(text.substring(i, this.index));
                return this.newString(sb);
            }
            int j = i + 1;
            end = j + len - 1;
            int k = 1;
            while (j < end) {
                if (text.charAt(j++) == s2.charAt(k++)) continue;
                ++i;
                sb.append(s2.substring(0, k - 1));
                continue block0;
            }
            break;
        }
        this.index = next ? this.skip(end, this.count) : end - len;
        return this.newString(sb);
    }

    public String searchString(char c) {
        return this.searchString(c, true);
    }

    public String searchString(char c, boolean next) {
        return this.move(this.index, c, false, next);
    }

    public String searchString(String s) {
        return this.searchString(s, true);
    }

    public String searchString(String s, boolean next) {
        return this.move(this.index, s, false, next);
    }

    public String getString() {
        return this.move(this.index, '\uffff', true, true);
    }

    public String getString(char c) {
        return this.getString(c, true);
    }

    public String getString(char c, boolean next) {
        return this.move(this.index, c, true, next);
    }

    public String getString(String s) {
        return this.getString(s, true);
    }

    public String getString(String s, boolean next) {
        return this.move(this.index, s, true, next);
    }

    public String getWord() {
        String text = this.text;
        int max = this.count;
        int i = this.index;
        StringBuffer sb = new StringBuffer();
        if (i < max) {
            if (!this.isSeparatorChar(text.charAt(i))) {
                for (i = this.skip(i, max); i < max && !this.isSpace(text.charAt(i)) && !this.isSeparatorChar(text.charAt(i)); ++i) {
                    sb.append(text.charAt(i));
                }
            } else {
                sb.append(text.charAt(i++));
            }
        }
        this.index = this.skip(i, max);
        return new String(sb);
    }

    private boolean isSeparatorChar(char ch) {
        char[] sc = this.wordSeparators;
        for (int i = 0; i < sc.length; ++i) {
            if (sc[i] != ch) continue;
            return true;
        }
        return false;
    }

    public String getLineString() {
        return this.getLine().getString();
    }

    private String newString(StringBuffer sb) {
        if (this.spaceSkip) {
            int end;
            for (end = sb.length(); 0 < end && this.isSpace(sb.charAt(end - 1)); --end) {
            }
            sb.setLength(end);
        }
        return new String(sb);
    }

    public boolean contains(String s) {
        return this.indexOf(s, this.index, this.count) != -1;
    }

    public boolean contains(char c) {
        return this.indexOf(c, this.index, this.count) != -1;
    }

    public boolean skip(String s) {
        int i = this.indexOf(s, this.index, this.count);
        if (i == -1) {
            return false;
        }
        this.index = this.skip(i + s.length(), this.count);
        return true;
    }

    public boolean skip(char c) {
        int i = this.indexOf(c, this.index, this.count);
        if (i == -1) {
            return false;
        }
        this.index = this.skip(i + 1, this.count);
        return true;
    }

    public void skip() {
        this.index = this.skip(this.index, this.count);
    }

    public void mark() {
        this.marked = this.index;
    }

    public void reset() {
        this.index = this.marked;
    }

    public String toString() {
        return " [text]    :" + this.getText() + " / " + " [spaceS]  :" + this.spaceSkip + " / " + " [commentS]:" + this.commentSkip + " / " + " [commentC]:" + this.commentChar + " / " + " [escapeC] :" + this.escapeChar;
    }

    private int skip(int i, int max) {
        String text = this.text;
        if (i >= 0) {
            while (i < max) {
                char c = text.charAt(i);
                if (!this.spaceSkip || !this.isSpace(c)) {
                    if (!this.commentSkip || c != this.commentChar) break;
                    i = this.skipComment(i, max);
                }
                ++i;
            }
        }
        return i;
    }

    private int skipComment(int i, int max) {
        String text = this.text;
        while (++i < max && text.charAt(i) != '\n' && text.charAt(i) != '\r') {
        }
        if (i + 1 < max && text.charAt(i) == '\r' && text.charAt(i + 1) == '\n') {
            ++i;
        }
        return i;
    }

    private int processEscape(int i, int max) {
        String text = this.text;
        if (text.charAt(++i) == '\r' && i + 1 < max && text.charAt(i + 1) == '\n') {
            ++i;
        }
        return i;
    }
}

