/*
 * desktop.js
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * このソースコードと，このソースコードから生成されたドキュメントおよび
 * このソースコードをコンパイルして作成されたバイナリファイルを使用する
 * 際には以下の使用許諾に従う必要があります。
 *
 *
 * [使用許諾]
 *
 *   以下では，「ソースコード」，「ソースコードから生成されたドキュメン
 * ト」，「ソースコードをコンパイルして作成されたバイナリファイル」の三
 * 者を「ライブラリ」と呼びます。たとえ，ソースコードが単体で実行可能な
 * ものである場合でも，ここでは「ライブラリ」と呼びます。
 *   この使用許諾の対象となる「使用」とは，「ライブラリ」の複製・配布・
 * 変更，「ライブラリ」を使ったアプリケーションの開発，「ライブラリ」の
 * 実行等，「ライブラリ」に関する一切の活動のことを表します。
 *   この使用許諾によって許諾を受ける者を「使用者」呼びます。
 *
 * (1)
 *   「ライブラリ」には一切の保証がありません。使用者もしくは使用者から
 *   「ライブラリ」を配布された第三者による「ライブラリ」の使用，または
 *   「ライブラリ」を使用して作成されたアプリケーション，システム等の使
 *   用により発生したいかなる損害に対しても著作権者は一切責任を負いませ
 *   ん。これらの損害に対してはすべて使用者が責任を負うものとします。
 *
 * (2)
 *   他の使用者と著作権者が「ライブラリ」を使用することを，使用者が妨げ
 *   てはなりません。
 *
 * (3)
 *   使用者は「ライブラリ」の複製・変更・配布を自由に行うことができます。
 *                                                                 以上
 */

// ------ Util TODO 後で移動 ------

/**
 * val を k桁の整数フォーマットで返す。不足分は左側に0を埋める
 * @param val フォーマットする値。
 * @param k 表示桁数
 */
function formatInt(val, k) {
	var result = val.toString();
	while(result.length < k) {
		result = '0' + result;
	}
	return result;
}

// ------- アイコン ------------

/**
 * アイコンクラス
 * @param width アイコン幅。
 * @param height アイコン高さ。
 * @param x 横位置。
 * @param y 縦位置。
 * @param content 表示ラベル。
 * @param img アイコン画像URL。
 * @param tooltip ツールチップ文字列。
 */
function Icon(width, height, x, y, content, img, tooltip) {
//	alert(parent);
	IDiv.call(this, width, height);
//	IDiv.call(parent, width, height); としたいが動かない
	this.constructor = Icon;
	this.setSize(width, height);
	this.setPosition(x, y);
	this.htmlElement.title = tooltip;
	this.htmlElement.className = "icon";
	this.htmlElement.style.backgroundImage = "url(" + img + ")";
	this.imageSrc = img;
	this.setContent("<p>" + content + "</p>");
	this.win = null;
	
//	this.setWindow = function(win) {
//		this.win = win;
//		this.ondblclick = function(event) {
//			win.show(IWidget.editEvent(event));
//		}
//	}
	
	this.getIWindow = function() {
		return this.win;
	}
	this.getImage = function() {
		return this.htmlElement.style.backgroundImage;
	}
	this.getImageSrc = function() {
		return this.imageSrc;
	}
}

/**
 * アナログ時計アイコンクラス コンストラクタ
 * @param width アイコン幅。
 * @param height アイコン高さ。
 * @param x 横位置。
 * @param y 縦位置。
 * @param content 表示ラベル。
 * @param img アイコン画像URL。
 * @param tooltip ツールチップ文字列。
 */
function AClockIcon(width, height, x, y, content, img, tooltip) {
	if (!img) {
		img = "./img/aclock_bg.gif";
	}
	Icon.call(this, width, height, x, y, content, img, tooltip, null);
	this.constructor = AClockIcon;

	// グローバル時計管理に追加	
	_clocks_addClock(this);
	
	// 画像パス
	this.CENTER_IMG = "./img/aclock_center.gif";
	this.LONG_IMG = "./img/aclock_long.gif";
	this.SHORT_IMG = "./img/aclock_short.gif";
	
	// 相対中心座標
	this.cx = width / 2;
	this.cy = height / 2;
	
	// 各パーツ画像数
	this.longHd = 7;
	this.shortHd = 5;
	this.secHd = 5;

	// 時計のパーツのdivを作成しておく
	var cont = "";
	cont += addDivIdHtml('_aclock_L', this.longHd); // 長針
	cont += addDivIdHtml('_aclock_S', this.shortHd); // 短針
//	cont += addDivIdHtml('_aclock_Sec', this.secHd); // 長針
	
	// 画像配置用Divタグを構成
	function addDivIdHtml(id, num) {
		if (num) {
			var html = "";
			for(i = 0; i < num; i++) {
				html += "<div id='" + id + i + "' STYLE='position:absolute;'></div>";
			}
			return html;
		} else {
			return "<div id='" + id + "' STYLE='position:absolute;'></div>";
		}
	}
	this.setContent(cont);
	
	// 各パーツdiv作成
	
	// 2. 長針
	this.longDivs = new Array();
	for(i = 0; i < this.longHd; i++) {
		this.longDivs.push(document.getElementById('_aclock_L' + i));
		// 初期位置はappendChild直前に設定
	}
	
	// 3. 短針
	this.shortDivs = new Array();
	for(i = 0; i < this.shortHd; i++) {
		this.shortDivs.push(document.getElementById('_aclock_S' + i));
	}
	// サイズ判定用に画像オブジェクトを保持
	this.longImg = document.createElement('img');
	this.longImg.setAttribute('src', this.LONG_IMG);
	this.longImg.setAttribute('width', 5); // IEではこれを指定しないと画像が崩れる
	this.longImg.setAttribute('height', 5);
	this.shortImg = document.createElement('img');
	this.shortImg.setAttribute('src', this.SHORT_IMG);
	this.shortImg.setAttribute('width', 5); // IEではこれを指定しないと画像が崩れる
	this.shortImg.setAttribute('height', 5);
	
	// 時間再描画	
	this.redraw = function() {
		// 1. 現在時刻取得
		var now = new Date();
		var min = formatInt(now.getMinutes(),2);
		var dmin = (min * 360 / 60　- 90) * Math.PI / 180;
		var hour = formatInt(now.getHours(),2);
		var dhour = ((hour * 360 / 12　+ min * 360 / 60　/ 12) - 90) * Math.PI / 180;
		var sec = formatInt(now.getSeconds(),2);
		
		// 時計アイコン幅
		var w = parseInt(this.htmlElement.style.width) / 2.4;
		
		// 2. 長針配置
		putDivs(this.cx, this.cy, w / this.longHd, this.longDivs, this.longImg, dmin);
		// 3. 短針配置
		putDivs(this.cx, this.cy, w / this.longHd/* not miss */, this.shortDivs, this.shortImg, dhour);
	}
	
	// 各針をdeg度で配置
	function putDivs(cx, cy, w, divs, img, deg) {
		var n = divs.length;
		for(i = 0; i < n; i++) {
			var sp = (i + 1) * w;
			divs[i].style.left = 
				cx - img.width / 2 + Math.cos(deg) * sp;
			divs[i].style.top = 
				cy - img.height / 2 + Math.sin(deg) * sp;
		}
	}

	// div を初期配置
	this.redraw();
	
	// 画像を表示
	// 長針
	appendImgsToDivs(this.LONG_IMG, this.longDivs);
	// 短針
	appendImgsToDivs(this.SHORT_IMG, this.shortDivs);

	// divにimgpathのimgオブジェクトを追加
	function appendImgsToDivs(imgpath, divs) {
		n = divs.length;
		for(i = 0; i < n; i++) {
			var img = document.createElement('img');
			img.setAttribute('src', imgpath);
			img.setAttribute('width', 5); // IEではこれを指定しないと画像が崩れる
			img.setAttribute('height', 5);
			divs[i].appendChild(img);
		}
	}
}

/**
 * デジタル時計アイコンクラス コンストラクタ
 * @param width アイコン幅。
 * @param height アイコン高さ。
 * @param x 横位置。
 * @param y 縦位置。
 * @param content 表示ラベル。
 * @param img アイコン画像URL。
 * @param tooltip ツールチップ文字列。
 * @param secflg 秒表示フラグ
 */
function DClockIcon(width, height, x, y, content, img, tooltip, win, secflg) {
	Icon.call(this, width, height, x, y, content, img, tooltip, win);
	this.constructor = DClockIcon;
	this.secflg = secflg;
	
	// 時計タイマーに追加
	_clocks_addClock(this);

	// 時間再描画	
	this.redraw = function() {
		var now = new Date();
		var txt = formatInt(now.getHours(),2) + ":" +
		          formatInt(now.getMinutes(),2);
		if (this.secflg) {
			txt += " " + 
		          formatInt(now.getSeconds(),2);
		}
		this.setContent("<p>" + txt + "</p>");
	}
}

// ------- 時計共通処理 -----------
// グローバル時計リスト
// TODO グローバル変数でなくしたい
var _clocks_array = new Array();

/**
 * グローバル時計リストに時計オブジェクトを追加
 * @param clock 時計オブジェクト。redraw関数を実装していること。
 */
function _clocks_addClock(clock) {
	if (_clocks_array.length == 0) {
		// タイマー起動
		var timid = setInterval("_clocks_redraw()", 1000); // とりあえず1000ms
	}
	_clocks_array.push(clock);
}
/**
 * 全時計を再描画
 */
function _clocks_redraw(){
	var num = _clocks_array.length;
	for(i = 0; i < num; i++) {
		_clocks_array[i].redraw();
	}
}

//------- GoogleMap -----------
// TODO 後でファイルを独立
/**
 * GoogleMapクラス
 * @param 親IWindow (TODO 後で廃止?)
 * @param index 現在のdocument内でのGoogleMapインデックス。複数ウィンドウで
 *               GoogleMapを表示する場合はこのパラメータに 0, 1, .. とインデックスを指定する.
 * @param lat 初期表示緯度。
 * @param lng 初期表示経度。
 * @param zoom ズームレベル。GoogleMapのレベル。
 */
function IGoogleMap(win, index, lat, lng, zoom) {
	this.win = win;
	if (!index) {
		index = 0;
	}

	// TODO 現在はウィンドウ内に<div id とidを指定してdiv要素を作成しているが、
	// Celcelのようにhtmlでdiv要素idを定義してもらい、引数にidを渡した方がいい？
	win.setContent('<div id="_google_map' + index + '" style="width: 600px; height: 500px"></div>');
	this.div = document.getElementById("_google_map" + index);
	this.htmlElement = this.div;	
	
//	this.div.style.width = win.width;
//	this.div.style.height = win.height;
	
	this.gmap = new GMap(this.div);
	var map = gmap;

	map.addControl(new GLargeMapControl());
	map.addControl(new GMapTypeControl());

	if (!lng) {
		lng = 140.04547119140625;
	}
	if (!lat) {
		lat = 35.69968630125204;
	}
	zoom = !zoom ? 10 : zoom;
//	IDebug.print(lat + "," + lng);
    map.centerAndZoom(new GPoint(lng, lat),zoom);
}
//------ Global def -----
var isCSS = (document.body && document.body.style) ? true : false;
var isW3C = (isCSS && document.getElementById) ? true : false;
var isIE4 = (isCSS && document.all) ? true : false;
var isNN4 = (document.layers) ? true : false;
var isIE6CSS = (document.compatMode && document.compatMode.indexOf("CSS1") >= 0) ? true : false;

//------ Util ------
function getWindowWidth() {
	if (window.innerWidth) {
		return window.innerWidth;
	} else if (isIE6CSS) {
		return document.body.parentElement.clientWidth;
	} else if (document.body && document.body.clientWidth) {
		return document.body.clientWidth;
	}
	return 0;
}

function getWindowHeight() {
	if (window.innerHeight) {
		return window.innerHeight;
	} else if (isIE6CSS) {
		return document.body.parentElement.clientHeight;
	} else if (document.body && document.body.clientHeight) {
		return document.body.clientHeight;
	}
	return 0;
}

/**
 * text の先頭から指定したバイトサイズ分だけ分割し返す。
 * bytelenを超えた場合は末尾に".."を付加する。
 * 
 * @param text 対象文字列
 * @param bytelen 取得するバイトサイズ
 * @return 取得文字列
 */
function substrByte(text, bytelen) {
	var size = 0;
	var subtext = "";
	for (var i = 0; i < text.length && size < bytelen; ++i) {
		var c = text.charCodeAt(i);
		//  半角カタカナは不許可
		size += (c < 256 || (c >= 0xff61 && c <= 0xff9f)) ? 1 : 2;
		if (size > bytelen) {
			break;
		}
		subtext += text.charAt(i);
	}
	if (subtext.length < text.length) {
		subtext += "..";
	}
	return subtext;	
}

//--------- タスクバー ----------

/**
 * 画面上で唯一のタスクバークラス
 * @param obj document上のタスクバーelement
 */
// やっぱりグローバルITaskBarオブジェクトを利用する
function ITaskBar(obj) {
	this.defscale = 50;
	IDiv.call(this, getWindowWidth(), this.defscale);
	this.constructor = ITaskBar;
	this.htmlElement.className = "taskbar";

	// 管理対象IWindowリスト
	this.win_array = new Array();
	// 管理対象Iconリスト
	this.icon_array = new Array();
	
	// float mode (どのウィンドウ枠に張り付いているか、そうでないか)
	// 0:なし 1:上辺 2:下辺 3:左辺 4:右辺
	this.float_mode = 2;
	this.lfloat_mode = 2;

	// タスクバードラッグ中の前回のウィンドウ枠との最短距離
	this.lmin = 0;
	
	// 初期状態は右辺固定
	this.setPosition(0,getWindowHeight() - parseInt(this.getHeight()));
	
	/**
	 * タスクバーを再描画
	 */
	this.redraw = function() {
//		IDebug.print("taskbar redraw, float_mode=" + this.float_mode + "  lfloat_mode=" + this.lfloat_mode);
		var cont;
		
		var draw_mode = this.float_mode;
		// フロート中の場合は前回のモードを利用
		if (this.float_mode == 0) {
			draw_mode = this.lfloat_mode;
		}
		if (draw_mode <= 2) {
			// 横長描画
//			IDebug.print(draw_mode + "横長");
			cont = "<table><tr>";
			for(i = 0; i < this.win_array.length; i++) {
				win = this.win_array[i];
				icon = this.icon_array[i];
				if (!win.isMinimize()) { // isVisible() は常に false が返る
					continue;
				}
				td_id = 'taskbar_icon' + i;
				cont += "<td><A href='javascript:ITaskBar.showWindow(" + i + ")' class='taskbar_button'><IMG id='" + td_id + "' src='" + icon.getImageSrc() + "' width=16 border=0>";
				cont += "<BR>" + substrByte(win.getTitle(),6);
				cont += "</A></td>";
			}
			cont += "</tr></table>";
		} else {
			// 縦長描画
//			IDebug.print(draw_mode + "縦長");
			cont = "<table>";
			for(i = 0; i < this.win_array.length; i++) {
				win = this.win_array[i];
				icon = this.icon_array[i];
				if (!win.isMinimize()) { // isVisible() は常に false が返る
					continue;
				}
				td_id = 'taskbar_icon' + i;
				cont += "<tr><td><A href='javascript:ITaskBar.showWindow(" + i + ")' class='taskbar_button'><IMG id='" + td_id + "' src='" + icon.getImageSrc() + "' width=16 border=0>";
				cont += "<BR>" + substrByte(win.getTitle(),6);
				cont += "</A></td></tr>";
			}
			cont += "</table>";
		}
		
		// 現在のfloat modeから表示位置を指定
//		IDebug.print("getWindowHeight=" + getWindowHeight() + " getWindowWidth=" + getWindowWidth());
		switch(this.float_mode) {
		case 1: // 上辺
		case 3: // 左辺
			this.setPosition(0,0);
			break;
		case 2: // 下辺
			this.setPosition(0,getWindowHeight() - parseInt(this.getHeight()));
			break;
		case 4: // 右辺
			this.setPosition(getWindowWidth() - parseInt(
					this.getWidth()), 0);
			break;
		}
//		IDebug.print("getHeight=" + this.getHeight());
		this.setContent(cont);
	}
	
	/**
	 * IWindowを追加
	 */
	this.addIWindow = function(win, icon) {
		this.win_array.push(win);
		this.icon_array.push(icon);
		win.onhide = function() {
			ITaskBar.redraw(this);
			return true;
		}
	}
	/**
	 * 指定したindexのWindowを表示
	 */
	this.showWindow = function(winIndex) {
		this.win_array[winIndex].setVisible(true);
	}
	/**
	 * ドラッグイベントハンドラ
	 * フロート中にウィンドウの枠に近づいたら枠に張り付ける
	 */
	this.onmove = function(x,y) {
		var wwidth = getWindowWidth();
		var wheight = getWindowHeight();
		var rx = wwidth - (x + parseInt(this.getWidth()));
		var ry = wheight - (y +  parseInt(this.getHeight()));
		
		// float_mode によって分岐
		if (this.float_mode == 0) {
			// ウィンドウ枠との最短地点を探して
			// 近づいている && 10px以下 ならドッキング
			var min = Math.min(Math.min(x,y),Math.min(rx,ry));
			if (min < this.lmin && min < 10) {
				// 近いのでドッキング
				// 0:なし 1:上辺 2:下辺 3:左辺 4:右辺
				this.lfloat_mode = this.float_mode;
				this.float_mode = min == y ? 1:
					min == x ? 3:
				    min == rx ? 4: 2;

				if (this.float_mode <= 2) {
					this.setSize(getWindowWidth(), this.defscale);
				} else {
					this.setSize(this.defscale, getWindowHeight());
				}
				
				this.redraw();
				document.onmouseup();
			}
			this.lmin = min;
		} else {
			// 固定状態からドラッグされた場合.
			// もしタスクバーの幅or高さがウィンドウ幅と一緒なら2/3程度に縮小する
			// そうしないと移動してすぐウィンドウ枠とくっついてしまう
//			IDebug.print("else " + wwidth + "," + wheight + "  " + this.getWidth() + "," + this.getHeight());
			if (wwidth <= parseInt(this.getWidth())) {
//				IDebug.print("width");
				this.setSize(wwidth *2/3, this.getHeight());
			}
			if (wheight <= parseInt(this.getHeight())) {
//				IDebug.print("height");
				this.setSize(this.getWidth(), wheight *2/3);
			}
			
			// 固定モードから張り付きなしへ
			this.lfloat_mode = this.float_mode;
			this.float_mode = 0;
			this.lmin = 0;
			this.redraw();
		}
	}
	
}
var ITaskBar;

/**
 * DesktopItem
 */
function IDesktopItem(createWinFunc, icon) {
	this.createWinFunc = createWinFunc;
	this.icon = icon;
	this.win = null;
}

/**
 *  DesktopItem配列
 */
var _desktop_item_array = new Array();

/**
 * IDesktop
 */
function IDesktop() {
	/**
	 * 初期化
	 */
	IDesktop.init = function() {
		//	 唯一のタスクバーインスタンス作成
		ITaskBar = new ITaskBar(document.getElementById("taskbar"));

		// 背景画像の登録
		// TODO サーバー or cookieから取得する?
		document.body.style.backgroundImage = "url(http://amsoft.minidns.net/picture/pic1/IMG_0006.JPG)";
	}
	
	/**
	 * IWindow作成関数を登録
	 * @param createWinFunc IWindow作成関数
	 * @param icon アイコン
	 */
	IDesktop.regist = function(createWinFunc, icon) {
		var item = new IDesktopItem(createWinFunc, icon);
		_desktop_item_array.push(item);
		IDesktop.createWindow(item);
		
		icon.ondblclick = function() {
//			IDebug.printObject(item.win);
			if(!item.win) {
				IDesktop.createWindow(item);
			} else 	if(item.win.isClosed()) {
				IDesktop.createWindow(item);
				item.win.show();
			} else {
				item.win.show();
			}
		}
	}
	
	/**
	 * IWindow作成関数を呼び出して実際に作成する関数(インターフェース的に利用)
	 * @param item IDesktopItem
	 */
	IDesktop.createWindow = function(item) {
		var win = item.createWinFunc();
		win.onclosing = function() {ITaskBar.redraw(); return true;}
		ITaskBar.addIWindow(win, item.icon);
		item.win = win;
	}
}
new IDesktop();

//------ 背景画像 ------
