-- Order
create table t_order(
	ord_no varchar(10) primary key,
	cust_cd varchar(10),
	deliv_req date
);
insert into t_order values('001', '1000', '2007-10-01');
insert into t_order values('002', '1000', '2007-11-15');
insert into t_order values('003', '2000', '2007-10-10');
insert into t_order values('004', '3000', '2007-10-12');


-- Order Detail
create table t_order_detail(
	ord_no varchar(10),
	detail_no integer,
	item_cd varchar(10),
	req_qty integer,
	primary key(ord_no, detail_no)
);
insert into t_order_detail values('001', 1, 'YML111', 10);
insert into t_order_detail values('001', 2, 'YML112', 3);
insert into t_order_detail values('001', 3, 'MZC301', 2);
insert into t_order_detail values('002', 1, 'YML111', 12);
insert into t_order_detail values('003', 1, 'MZC301', 4);
insert into t_order_detail values('004', 1, 'YML111', 3);
insert into t_order_detail values('004', 2, 'MZC301', 2);


-- Item Master
create table m_item(
	item_cd varchar(10) primary key,
	item_name varchar(50)
);
insert into m_item values('YML111', 'Orange');
insert into m_item values('YML112', 'Apple');
insert into m_item values('MZC301', 'Tomato');


-- Customer Master
create table m_customer(
	cust_cd varchar(10) primary key,
	cust_name varchar(50)
);
insert into m_customer values('1000', 'Nagarjuna');
insert into m_customer values('2000', 'Vasvandu');
insert into m_customer values('3000', 'Dignaga');


-- Stockpoint Master
create table m_stockpoint(
	sp_cd varchar(10) primary key,
	sp_name varchar(50)
);
insert into m_stockpoint values('P01', 'Chiba');
insert into m_stockpoint values('P02', 'Saitama');
insert into m_stockpoint values('P03', 'Tochigi');


-- Stock
create table t_stock(
	sp_cd varchar(10),
	item_cd varchar(10),
	qty integer,
	primary key(sp_cd, item_cd)
);
insert into t_stock values('P01', 'YML111', 10);
insert into t_stock values('P01', 'YML112', 10);
insert into t_stock values('P02', 'MZC301', 10);
insert into t_stock values('P03', 'YML111', 10);



