/**
 * IAssistant。
 */
function IAssistant() {

	//// public メソッド定義

	/**
	 * 入力補助用選択リストの表示を行なう。
	 * @param selector 選択リスト。
	 * @param input 選択結果を表示する入力項目。
	 * @param requestId 選択リストの作成を行なうためのリクエストID。
	 */
	IAssistant.show = function(selector, input, requestId) {
		selector = IWidget.getHtmlElement(selector);
		input = IWidget.getHtmlElement(input);

		if(!selector && !requestId) {
			return;
		}

		if(requestId) {
			send(requestId, input, 
					function(){
						showSelector(IWidget.getHtmlElement(selector.id), input);
					}
				);
		}
		else {
			showSelector(selector, input);
		}
	}

	/**
	 * 入力補助用選択リストに表示されている内容の絞込みを行なう。
	 * @param selector 選択リスト。
	 * @param input 選択結果を表示する入力項目。
	 * @param requestId 選択リストの絞込みを行なうためのリクエストID。
	 */
	IAssistant.narrowDown = function(selector, input, requestId) {
		selector = IWidget.getHtmlElement(selector);
		input = IWidget.getHtmlElement(input);

		if(!selector && !requestId) {
			return;
		}

		if(requestId) {
			send(requestId, input, 
					function(){
						showSelector(IWidget.getHtmlElement(selector.id), input);
					}
				);
		}
		else {
			narrowDownItem();
		}

		function narrowDownItem() {
			var value = getValue(input);
			var length = selector.rows.length;
			for(var i=0; i<length; i++) {
				var item = selector.rows[i].cells[0];
				if(check(value, item.innerHTML)) {
					selector.rows[i].style.display = 'block';
				}
				else {
					selector.rows[i].style.display = 'none';
				}
			}
			selector.style.display='block';

			function check(text1, text2) {
				if(!text1) {
					return true;
				}
				var length = text1.length;
				if(length > text2.length) {
					return false;
				}

				for(var i=0; i<length; i++) {
					if(text1.charAt(i)!=text2.charAt(i)) {
						return false;
					}
				}
				return true;
			}
		}
	}

	/**
	 * 入力補助用選択リストを非表示にする。
	 * @param input 選択結果を表示する入力項目。
	 */
	IAssistant.hide = function(input) {
		input = IWidget.getHtmlElement(input);
		var selector = input.iassistSelector;
		if(!selector) {
			return;
		}
		selector.style.display='none';
	}

	/**
	 * 入力補助用選択リストの非表示を予約する。
	 * @param input 選択結果を表示する入力項目。
	 */
	IAssistant.hideLator = function(input) {
		input = IWidget.getHtmlElement(input);
		var selector = input.iassistSelector;
		if(!selector) {
			return;
		}
		selector._hideLator = setTimeout(
			function() {
				if(selector._hideLator) {
					selector.style.display='none';
				}
			},
			1000
		);
	}


	/**
	 * 特定の項目をフォーカスするときに呼び出す。
	 * @param item フォーカスする項目。
	 */
	IAssistant.focus = function(item) {
		item = IWidget.getHtmlElement(item);
		item.style.backgroundColor='blue';
		item.style.color='white';
		var selector = getTable(item);
		if(selector._hideLator) {
			clearTimeout(selector._hideLator);
			selector._hideLator = null;
		}
	}

	/**
	 * フォーカスされている項目のフォーカスを外すときに呼び出す。
	 * @param item フォーカスを外す項目。
	 */
	IAssistant.blur = function(item) {
		item = IWidget.getHtmlElement(item);
		item.style.backgroundColor='white';
		item.style.color='black';
		IAssistant.hideLator(getTable(item).id);
	}

	/**
	 * 特定の項目が選択されたときに呼び出し，
	 * 選択された項目の値を inputId で指定された入力項目の値としてセットする。
	 */
	IAssistant.selected = function(item, input) {
		item = IWidget.getHtmlElement(item);
		input = IWidget.getHtmlElement(input);

		if(input.value!=undefined) {
			input.value = getSelectedValue();
		}
		else if(input.innerHTML!=undefined) {
			input.innerHTML = getSelectedValue();
		}

		getTable(item).style.display='none';

		function getSelectedValue() {
			if(item.tagName=="TR") {
				return item.cells[0].innerHTML
			}
			else {
				return item.innerHTML;
			}
		}
	}

	function showSelector(selector, input) {
		IWidget.hideInputHelper("IAssistant", selector);
		IWidget.setInputHelperPosition(input, selector);
		selector.style.display='block';
		input.iassistSelector = selector;
	}

	function send(requestId, input, func) {
		var request = new CongaRequest();
		request.async = true;
		request.send(requestId, getName(input) + "=" + getValue(input), func);
	}

	function getValue(input) {
		if(input.value!=undefined) {
			return input.value;
		}
		else if(input.innerHTML!=undefined) {
			return input.innerHTML;
		}
		else {
			return null;
		}
	}

	function getName(input) {
		if(input.name!=undefined) {
			return input.name;
		}
		else if(input.id!=undefined) {
			return input.id;
		}
		else {
			return null;
		}
	}

	function getTable(item) {
		var obj = item;
		while(obj) {
			if(obj.tagName=="TABLE") {
				break;
			}
			obj = obj.parentNode;
		}
		return obj;
	}

}
new IAssistant();


