/**
 * IDebug。
 */
function IDebug() {

	//// public メソッド定義

	/**
	 * デバッグ出力を行なう。
	 * @param obj 出力内容。
	 */
	IDebug.print = function(obj) {
		var dbg = document.getElementById("_iwidgets_dbg");
		if(!dbg) {
			var debugWindow = new IWindow("debug");
			debugWindow.setContent(
				"<div id='_iwidgets_dbg'></div>"+
				"<input type='button' value='clear' onclick='IDebug.clear()'/>"
			);
			debugWindow.setBounds(600,20,200,200);
			debugWindow.onclosing = function(){return false;};
			dbg = document.getElementById("_iwidgets_dbg");
			dbg.window = debugWindow;
			dbg.innerHTML = obj;
		}
		else {
			if(dbg.window.isClosed()) {
				return;
			}
			else if(!dbg.window.isVisible()) {
				dbg.window.show();
			}
			dbg.innerHTML = dbg.innerHTML + "<br>" + obj;
			dbg.parentNode.scrollTop = dbg.parentNode.scrollHeight;
		}
	}

	/**
	 * デバッグ出力のクリアを行なう。
	 */
	IDebug.clear = function () {
		var dbg = document.getElementById("_iwidgets_dbg");
		if(dbg) {
			dbg.innerHTML="";
		}
	}
	
	/**
	 * オブジェクトをデバッグ出力する
	 */
	IDebug.printObject = function(obj) {
		IDebug.print(IDebug.object2String(obj));
	}

	/**
	 * オブジェクトを文字列表現に変換する。
	 */
	IDebug.object2String = function(obj) {
	    var val, output = "";
	    if (obj) {    
	        output += "{";
	        for (var i in obj) {
	            val = obj[i];
	            switch (typeof val) {
	                case ("object"):
	                    if (val[0]) {
	                        output += i + ":" + array2String(val) + ",";
	                    } else {
	                        output += i + ":" + object2String(val) + ",";
	                    }
	                    break;
	                case ("string"):
	                    output += i + ":'" + escape(val) + "',";
	                    break;
	                default:
	                    output += i + ":" + val + ",";
	            }
	        }
	        output = output.substring(0, output.length-1) + "}";
	    }
	    return output;
	}

	/**
	 * 配列を文字列表現に変換する。
	 */
	IDebug.array2String = function(array) {
	    var output = "";
	    if (array) {
	        output += "[";
	        for (var i in array) {
	            val = array[i];
	            switch (typeof val) {
	                case ("object"):
	                    if (val[0]) {
	                        output += array2String(val) + ",";
	                    } else {
	                        output += object2String(val) + ",";
	                    }
	                    break;
	                case ("string"):
	                    output += "'" + escape(val) + "',";
	                    break;
	                default:
	                    output += val + ",";
	            }
	        }
	        output = output.substring(0, output.length-1) + "]";
	    }
	    return output;
	}


	/**
	 * 文字列表現をオブジェクトに変換する。
	 */
	IDebug.string2Object = function(string) {
	    eval("var result = " + string);
	    return result;
	}

	/**
	 * 文字列表現の配列を配列オブジェクトに変換する。
	 */
	IDebug.string2Array = function(string) {
	    eval("var result = " + string);
	    return result;
	}
}
new IDebug();


