/**
 * IBorder を作成する。
 * @param container IBorder のコンテナ。
 * @param type 線タイプ。"v" は縦線。"h" は横線。
 * @param length 線の長さ。
 * @param width 線の幅。[デフォルト=2]
 */
function IBorder(container, type, length, width) {

	//// 変数定義
	var handler = this;
	var htmlElement = document.createElement("div");


	//// プロパティ定義

	/**
	 * HTML実体要素オブジェクト。
	 */
	this.htmlElement = htmlElement;


	//// public メソッド定義

	/**
	 * 表示位置を設定する。
	 * @param left 横位置。
	 * @param top 縦位置。
	 */
	this.setPosition = function(left, top) {
		htmlElement.style.left = left;
		htmlElement.style.top = top;
		return handler;
	}

	/**
	 * 線の長さを設定する。
	 * @param len 線の長さ。
	 */
	this.setLength = function(len) {
		if(type.charAt(0)=="v" || type.charAt(0)=="V" ) {
			htmlElement.style.height = len;
		}
		else {
			htmlElement.style.width = len;
		}
		return handler;
	}

	/**
	 * 背景色を設定する。
	 * @param color 背景色。
	 */
	this.setColor = function(color) {
		htmlElement.style.backgroundColor = color;
		return handler;
	}


	//// イベント定義

	/**
	 * このオブジェクトがドラッグ操作で移動されたときに呼び出される。
	 * @param left オブジェクト横位置。
	 * @param top オブジェクト縦位置。
	 * @param event マウスイベント。
	 */
	this.onmove = null;


	//// ローカルメソッド定義

	/**
	 * IBorder を初期化する。
	 * @param container IBorder のコンテナ。
	 * @param type 線タイプ。"v" は縦線。"h" は横線。
	 * @param length 線の長さ。
	 * @param width 線の幅。[デフォルト=2]
	 */
	function init(container, type, length, width) {
		if(!width) {
			width = 2;
		}

		IWidget.initHtmlElement(handler, htmlElement, true);

		htmlElement.handler = handler;
		htmlElement.style.backgroundColor = "";
		htmlElement.style.position = "absolute";
		htmlElement.style.fontSize = "1pt";
		htmlElement.style.lineHeight= "100%";

		container.style.position = "relative";
		container.appendChild(htmlElement);

		if(type.charAt(0)=="v" || type.charAt(0)=="V" ) {
			htmlElement.type = "x";
			htmlElement.style.width = width;
			htmlElement.style.height = length;
			htmlElement.style.cursor = "e-resize";
		}
		else {
			htmlElement.type = "y";
			htmlElement.style.width = length;
			htmlElement.style.height = width;
			htmlElement.style.cursor = "n-resize";
		}

		// for debug
		//htmlElement.style.backgroundColor = "red";
		//htmlElement.style.filter = "alpha(opacity=50)";
	}

	//// インスタンスの初期化
	init(container, type, length, width);
}


