/**
 * ICalendar カレンダー。
 */
function ICalendar() {
	//// 変数定義
	var week;
	var content;
	var window;
	var firstDay;

	/**
	 * 本日として表示する日。
	 */
	var today;

	/**
	 * 書式。
	 */
	var format;

	/**
	 * 設定対象項目。
	 */
	var target;

	var initialized = false;


	//// public メソッド定義

	ICalendar.show = function(event, item) {
		show(event, item);
	}

	/**
	 * カレンダを表示する。
	 */
	function show(event, item) {

		event = IWidget.editEvent(event);

		if(!item) {
			item = event.target;
		}

		item = IWidget.getHtmlElement(item);

		initVariables();

		ICalendar.__update(0);

		IWidget.hideInputHelper("ICalendar", item);

		window.pack();
		window.show(event);

		function initVariables() {
			if(!initialized) {
				//// 変数定義
				week = new Array(
						IResource.get("ICalendar.sun", "Sun"),
						IResource.get("ICalendar.mon", "Mon"),
						IResource.get("ICalendar.tue", "Tue"),
						IResource.get("ICalendar.wed", "Wed"),
						IResource.get("ICalendar.thu", "Thu"),
						IResource.get("ICalendar.fri", "Fri"),
						IResource.get("ICalendar.sat", "Sat")
					);

				content = createContent();
				window = createWindow(content);
				format = IResource.get("ICalendar.format", "y/m/d");
				initialized = true;
			}

			firstDay = new Date();
			today = firstDay;
			target = item;
		}
	}

	/**
	 * カレンダを非表示にする。
	 */
	ICalendar.hide = function() {
		if(window) {
			window.hide();
		}
	}


	/**
	 * カレンダ表示内容を更新する。
	 */
	ICalendar.__update = function(ma) {
		nowdate  = firstDay.getDate();
		nowmonth = firstDay.getMonth();
		nowyear  = firstDay.getYear();

		// 月の変更
		if(nowmonth==11 && ma > 0) {
			nowmonth = ma - 1;
			nowyear++;
		}
		else if(nowmonth==0 && ma < 0) {
			nowmonth = ma + 12;
			nowyear--;
		}
		else {
			nowmonth += ma;
		}

		if(nowyear<1900) {
			nowyear=1900+nowyear;
		}

		// ヘッダ部の設定
		var tables = content.getElementsByTagName("table");
		var headerRow = tables.item(0).rows[0];
		headerRow.cells[0].onclick = function(){ICalendar.__update(-1);};
		headerRow.cells[2].onclick = function(){ICalendar.__update(1);};

		var m2 = (nowmonth + 1);
		headerRow.cells[1].innerHTML = nowyear+' . '+ ((m2<10)?('&nbsp;'+m2):m2);

		// ボディ部の設定
		firstDay = new Date(nowyear,nowmonth,1);
		var sunday = new Date(firstDay - ( firstDay.getDay() * 1000*60*60*24 ));
		var yearMonth = nowyear*100+nowmonth;

		var body = tables.item(1);

		for(var i=0; i<6; i++) {
			var row = body.rows[i + 1];

			for(var j=0; j<7; j++) {
				var cell = row.cells[j];

				var nextday = new Date(sunday.getTime() + (j * 1000*60*60*24));
				var tmpdate = nextday.getDate();
				var tmpmonth= nextday.getMonth();
				var tmpyear = nextday.getYear();

				if(tmpyear < 1900) {
					tmpyear=1900 + tmpyear;
				}

				cell.date = tmpdate;
				cell.month = tmpmonth;
				cell.year = tmpyear;
				cell.onclick = function(){ICalendar.__setDate(this);};
				cell.innerHTML = tmpdate;
				cell.title = "";

				var tmpYearMonth = tmpyear * 100 + tmpmonth;
				if(tmpYearMonth != yearMonth) {
					cell.className = "disabled";
				}
				else {
					if(tmpdate == today.getDate() && 
								tmpmonth == today.getMonth() && 
								nextday.getYear() == today.getYear()) {
						cell.className = "today";
					}
					else {
						var holiday = IResource.get("ICalendar." + createText(tmpyear, tmpmonth, tmpdate, "ymd"), "_");
						if(holiday!="_") {
							cell.className = "holiday";
							cell.title = holiday;
						}
						else {
							if(j==0) {
								cell.className = "sun";
							}
							else if(j==6) {
								cell.className = "sat";
							}
							else {
								cell.className = "oth";
							}
						}
					}
				}
			}

			sunday = nextday;
			sunday = sunday.getTime() + (1000*60*60*24);
			sunday = new Date(sunday);
		}

		// フッタ部の設定
		tables.item(2).rows[0].cells[0].onclick = function(){window.hide()};
	}

	/**
	 * 対象項目に日付をセットする。
	 */
	ICalendar.__setDate = function(cell) {
		var str = createText(cell.year, cell.month, cell.date, format);

		if(target.value!=undefined) {
			target.value = str;
		}
		else if(target.innerHTML!=undefined) {
			target.innerHTML = str;
		}
		window.hide();
	}

	function createText(tmpyear, tmpmonth, tmpdate, fmt) {
		m2 = tmpmonth+1;

		tmpmonth = ((m2<10)?'0'+m2:''+m2);
		tmpdate = ((tmpdate<10)?'0'+tmpdate:''+tmpdate);

		if(!fmt) {
			return tmpyear + "" + tmpmonth + "" + tmpdate;
		}
		else {
			var arr = new Array();
			var index = 0;
			for(var i=0; i<fmt.length; i++) {
				var c = fmt.charAt(i);
				if(c=='y' && tmpyear) {
					arr[index++] = tmpyear;
					tmpyear = null;
				}
				else if(c=='m' && tmpmonth) {
					arr[index++] = tmpmonth;
					tmpmonth = null;
				}
				else if(c=='d' && tmpdate) {
					arr[index++] = tmpdate;
					tmpdate = null;
				}
				else {
					arr[index++] = c;
				}
			}
			return arr.join("");
		}
	}


	function createContent() {
		var arr = new Array();
		var index = 0;
		arr[index++] =
			'<table style="margin-top:4px;" border="0" cellspacing="0" cellpadding="3" align="center">' +
			'  <tr align="center">' +
			'    <th class="button">&nbsp;&lt;</th>' +
			'    <th align="center"></th>' +
			'    <th class="button">&gt;&nbsp;</th>' +
			'  </tr>' +
			'</table>' +
			' <table align="center" border="0" cellspacing="1" cellpadding="1" class="calendar" width="96%"' +
			' style="margin:4px;border:1px solid black;background:#aaaaaa;">' +
			'  <tr>' +
			'    <th class="sun">' + week[0] + '</th>' +
			'    <th class="oth">' + week[1] + '</th>' +
			'    <th class="oth">' + week[2] + '</th>' +
			'    <th class="oth">' + week[3] + '</th>' +
			'    <th class="oth">' + week[4] + '</th>' +
			'    <th class="oth">' + week[5] + '</th>' +
			'    <th class="sat">' + week[6] + '</th>' +
			'  </tr>';

		for(var i = 0; i < 6; i++) {
			arr[index++] =
				' <tr>' +
				'   <td></td>' +
				'   <td></td>' +
				'   <td></td>' +
				'   <td></td>' +
				'   <td></td>' +
				'   <td></td>' +
				'   <td></td>' +
				' </tr>';
		}
		arr[index++] = '</table>';
		arr[index++] = '<table style="margin-top:4px;margin-bottom:4px;" border ="0" align="center">'+
						'<tr><td class="button">' + 
							IResource.get("close", "Close") + 
						'</td></tr>'+
						'</table>';

		var content = document.createElement("div");
		content.style.textAlign = "center";
		content.style.width = "220px";
		content.style.height = "210px";
		content.innerHTML = arr.join("");
		return content;
	}

	function createWindow(content) {
		var win = new IWindow("Calendar", content, true);
		win.setEnableMinimizeButton(false);
		win.onclosing = function(){win.hide(); return false};
		return win;
	}

}
new ICalendar();
