/**
 * IHelpMessage。
 */
function IHelpMessage() {

	var messageWindow;

	var initialized = false;

	var hideLator = null;


	//// public メソッド定義

	/**
	 * ヘルプメッセージの表示を行なう。
	 * @param target ヘルプを表示するオブジェクト。
	 * @param message 表示するメッセージ。
	 */
	IHelpMessage.show = function(target, message) {
		initVariables();

		if(hideLator) {
			clearTimeout(hideLator);
			hideLator = null;
		}

		target = IWidget.getHtmlElement(target);

		messageWindow.setContent(message);
		var htmlElement = messageWindow.htmlElement;
		htmlElement.className = "helpmessage";
		IWidget.setInputHelperPosition(target, htmlElement, 4);
		messageWindow.htmlElement.style.display = "block";


		hideLator = setTimeout(
			function() {
				if(hideLator) {
					hideLator = null;
					IHelpMessage.hide();
				}
			},
			6000
		);

		function initVariables() {
			if(!initialized) {
				messageWindow = new IDiv();
				var htmlElement = messageWindow.htmlElement;
				htmlElement.style.fontSize = "";
				htmlElement.className = "helpmessage";
				initialized = true;
			}
		}
	}

	/**
	 * ヘルプメッセージの消去を行なう。
	 */
	IHelpMessage.hide = function() {
		if(messageWindow) {
			messageWindow.htmlElement.style.display = "none";
		}
	}

}
new IHelpMessage();


