/**
 * ISplitPane を作成する。
 * @param htmlElement オブジェクト。
 * @param orientation 分割方向。"v" は縦分割。"h" は横分割。
 */
function ISplitPane(htmlElement, orientation) {

	//// 継承 : IContainer
	IContainer.call(this, htmlElement);
	this.constructor = ISplitPane;

	//// ローカル変数定義

	var handler = this;

	if(!ISplitPane.prototype.BORDER_WIDTH) {
		ISplitPane.prototype.BORDER_WIDTH = 10;
		ISplitPane.prototype.VISIBLE_BORDER_WIDTH = 2;
	}
	var bw = ISplitPane.prototype.BORDER_WIDTH;
	var vbw = ISplitPane.prototype.VISIBLE_BORDER_WIDTH;
	var hbw = bw/2;
	var divider;
	var a = null;
	var b = null;
	var vertical = orientation.charAt(0)=="v" || orientation.charAt(0)=="V" ;


	//// public メソッド定義


	/**
	 * コンテナ内コンポーネントの幅を設定する。
	 * @param width 幅。
	 * @return 指定された幅が設定できた場合は true。できなかった場合は false。
	 */
	this.setClientWidth = function(width) {
		if(vertical) {
			if(width <= a.offsetWidth) {
				return false;
			}
			if(!IWidget.setWidth(b, width - a.offsetWidth - vbw)) {
				return false;
			}

			b.style.left = a.offsetWidth;
			divider.setPosition(a.offsetWidth-hbw, 0);
		}
		else {
			if(!IWidget.setWidth(a, width-1)) {
				return false;
			}
			if(!IWidget.setWidth(b, width-1)) {
				return false;
			}
			divider.setLength(width);
		}
		return true;
	}

	/**
	 * コンテナ内コンポーネントの高さを設定する。
	 * @param htmlElement 設定するHTML要素。
	 * @param height 高さ。
	 * @return 指定された高さが設定できた場合は true。できなかった場合は false。
	 */
	this.setClientHeight = function(height) {
		if(!vertical) {
			if(height <= a.offsetHeight) {
				return false;
			}
			if(!IWidget.setHeight(b, height - a.offsetHeight - vbw)) {
				return false;
			}

			b.style.top = a.offsetHeight;
			divider.setPosition(0, a.offsetHeight-hbw);
		}
		else {
			if(!IWidget.setHeight(a, height-1)) {
				return false;
			}
			if(!IWidget.setHeight(b, height-1)) {
				return false;
			}
			divider.setLength(height);
		}
		return true;
	}

	/**
	 * ディバイダの位置を設定する。
	 * @param location ディバイダの位置。
	 */
	this.setDividerLocation = function(location) {
		if(vertical) {
			divider.onmove(location, 0);
			divider.setPosition(location, 0);
		}
		else {
			divider.onmove(0, location);
			divider.setPosition(0, location);
		}
	}

	/**
	 * 子要素が更新されたときに呼び出される。
	 * @param elem 子要素。
	 */
	this.updateChild = function(elem) {
		if(elem.id==a.id) {
			a = elem;
		}
		else if(elem.id==b.id) {
			b = elem;
		}
		initChildren();
	}


	/**
	 * ISplitPane を初期化する。
	 */
	function init() {
		htmlElement.handler = handler;
		htmlElement.style.position = "relative";
		htmlElement.style.padding = "0px";
		htmlElement.style.margin = "0px";

		var children = htmlElement.childNodes;
		for(var i=0; i<children.length; i++) {
			var child = children.item(i);
			if(child.tagName!="DIV") {
				continue;
			}
			child.style.position = "absolute";

			if(a==null) {
				a = child;
			}
			else if(b==null) {
				b = child;
				break;
			}
		}
		initChildren();
	}

	function initChildren() {
		if(vertical) {
			b.style.left = a.offsetWidth;
			b.style.borderLeft = "ridge 2px gray";
			divider = new IBorder(htmlElement, orientation, "100%", bw);
			divider.setPosition(a.offsetWidth-hbw, 0);
		}
		else {
			b.style.top = a.offsetHeight;
			b.style.borderTop = "ridge 2px gray";
			divider = new IBorder(htmlElement, orientation, "100%", bw);
			divider.setPosition(0, a.offsetHeight-hbw);
		}

		divider.onmove = function(left, top) {
			if(vertical) {
				var aWidth = a.offsetWidth;
				var bWidth = b.offsetWidth;

				if(left <= bw || left >= htmlElement.offsetWidth-bw) {
					divider.setPosition(aWidth-hbw, 0);
					return;
				}

				var diff = left - aWidth + hbw;
				if(!IWidget.setWidth(a, aWidth + diff)) {
					divider.setPosition(aWidth-hbw, 0);
					return;
				}
				if(!IWidget.setWidth(b, bWidth - diff)) {
					a.style.width = aWidth;
					divider.setPosition(aWidth-hbw, 0);
					return;
				}

				b.style.left = aWidth + diff;
			}
			else {
				var aHeight = a.offsetHeight;
				var bHeight = b.offsetHeight;

				if(top <= bw || top >= htmlElement.offsetHeight-bw) {
					divider.setPosition(0, aHeight-hbw);
					return;
				}

				var diff = top - aHeight + hbw;
				if(!IWidget.setHeight(a, aHeight + diff)) {
					divider.setPosition(0, aHeight-hbw);
					return;
				}
				if(!IWidget.setHeight(b, bHeight - diff)) {
					a.style.height = aHeight;
					divider.setPosition(0, aHeight-hbw);
					return;
				}
				b.style.top = aHeight + diff;
			}
		}
	}

	//// インスタンスの初期化
	init();
}


