package nga.model;

import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

/**
 * B<br>
 * F݂̎dlł́C^u؂蕶ŕۑ邽߁C
 * ^u܂񂾕𗚗Ƃēo^邱Ƃ͂łȂB
 */
public class History implements Iterable<String>, UpdatableByText {
	
	private static final String DELIM = "\t";

	private LinkedList<String> list = new LinkedList<String>();
	private int maxSize = 10;
	
	/**
	 * History 쐬B
	 */
	public History() {
	}

	/**
	 * History 쐬B
	 * @param maxSize i[B
	 */
	public History(int maxSize) {
		setMaxSize(maxSize);
	}

	/**
	 * i[ZbgB
	 * @param maxSize i[B
	 */
	public void setMaxSize(int maxSize) {
		this.maxSize = maxSize;
		list.clear();
	}

	/**
	 * i[擾B
	 * @return i[B
	 */
	public int getMaxSize() {
		return maxSize;
	}

	/**
	 * 𗚗ɒǉB
	 * ǉʁCi[𒴂ꍇCԌÂ񂪍폜B
	 */
	public void add(String o) {
		if(!list.remove(o)) {
			if(list.size()==getMaxSize()) {
				list.removeLast();
			}
		}
		
		int t = o.indexOf(DELIM);
		if(t >-1 ) {
			o = o.replaceAll(DELIM, "");
		}

		list.addFirst(o);
	}

	/**
	 *  Iterator ƂĎ擾B
	 * @see java.lang.Iterable#iterator()
	 */
	public Iterator<String> iterator() {
		return list.iterator();
	}

	/* (non-Javadoc)
	 * @see nga.model.UpdatableByText#update(java.lang.String)
	 */
	public void update(String value) throws ParseException {
		if(value==null || value.length()==0) {
			return;
		}

		StringTokenizer st = new StringTokenizer(value, DELIM);
		setMaxSize(Integer.parseInt(st.nextToken()));
		while(st.hasMoreTokens()) {
			add(st.nextToken());
		}
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append(getMaxSize()).append(DELIM);
		for (String s : this) {
			sb.append(s).append(DELIM);
		}
		return new String(sb);
	}
}