/*
 *CongaServlet.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

import nga.model.User;
import nga.model.UserAttribute;
import nga.servlet.config.ModuleInfo;
import nga.servlet.config.ParameterInfo;
import nga.servlet.config.RequestInfo;
import nga.servlet.config.ResultInfo;
import nga.servlet.dsp.DefaultCongaServletFactory;
import nga.servlet.dsp.adapter.ExceptionLogger;
import nga.servlet.spi.CongaServletAdapter;
import nga.servlet.spi.CongaServletFactory;
import nga.servlet.spi.ParameterParser;
import nga.servlet.spi.ResultWriter;
import nga.servlet.spi.UserAuth;
import nga.util.ClassDictionary;
import nga.util.ConfigurationException;
import nga.util.Resource;
import nga.util.UserLocale;

/**
 * Conga T[ubgB
 */
public class CongaServlet extends HttpServlet {
	
	private static final long serialVersionUID = 1L;

	/**
	 * EChEIDNGXgp^B{@value}
	 */
	public static final String WINDOW_ID = "_nga.window.id";
	
	/**
	 * 񓯊NGXgǂNGXgp^B{@value}
	 */
	public static final String ASYNC = "_nga.async";

	/**
	 * web.xml p^wFVXeGR[fBO`B{@value}<br>
	 * web.xml ̏p^w {@value} gp邱ƂɂC
	 * {@link ServiceInfo#getSystemEncoding()} Ŏ擾łlwłB
	 */
	public static final String SYSTEM_ENCODING = "nga.servlet.system.encoding";

	/**
	 * web.xml p^wFLN^Zbg`B{@value}<br>
	 * web.xml ̏p^w {@value} gp邱ƂɂC
	 * p҃P[Ƃ̃LN^Zbgw肪łB<br>
	 * l "en=8859_1, ja=Shift_JIS" Ƃ悤Ɏw肷B
	 */
	public static final String CHARSET = "nga.servlet.charset";
	
	/**
	 * web.xml p^wFNGXgݒt@C̊i[fBNg`B{@value}<br>
	 * web.xml ̏p^w {@value} gp邱ƂɂC
	 * NGXg`t@Ci[fBNgwłB
	 * w肪Ȃꍇ́C"conf" ƂȂB
	 */
	public static final String CONFIG_DIR = "nga.servlet.request-config-dir";

	/**
	 * web.xml p^wFNGXgݒt@C`B{@value}<br>
	 * web.xml ̏p^w {@value} gp邱ƂɂC
	 * NGXg`t@CwłB"*" Lŕt@Cw肷邱ƂoB
	 * w肪Ȃꍇ́C"*request-config.xml"ƂȂB
	 */
	public static final String CONFIG_FILE = "nga.servlet.request-config-file";

	/**
	 * web.xml p^wFt@Ng`B{@value}<br>
	 * web.xml ̏p^w {@value} gp邱ƂɂC
	 * {@link CongaServletFactory CongaServletFactory} ̎NXw肪łB
	 */
	public static final String FACTORY = "nga.servlet.factory";
	

	/**
	 * web.xml p^wFA_v^`B{@value}<br>
	 * web.xml ̏p^w {@value} gp邱ƂɂC
	 * {@link CongaServletAdapter CongaServletAdapter} ̃NXw肪łB
	 * NX́C"," Lŋ؂ĕw肷邱ƂłB
	 */
	public static final String ADAPTER = "nga.servlet.adapter";
	
	/**
	 * web.xml p^wF\[X^OB{@value}<br>
	 * web.xml ̏p^w蒆 {@value} Ŏw肵
	 * \[X`^OƂȂB<br>
	 * 񂪎w肳ĂꍇCŏ̂P݂̗̂pB<br>
	 * ̃p^w肳ĂȂꍇ @ gpB
	 * @see #getResourceTag()
	 */
	public static final String RESOURCE_TAG = "nga.servlet.resource-tag";
	
	/**
	 * web.xml p^wFClassDictionary `t@CpXB{@value}<br>
	 * web.xml ̏p^w {@value} gp邱ƂɂC
	 * ClassDictionary `t@C̃pXwłB
	 * w肪Ȃꍇ́C"conf/ClassDictionary.properties"ƂȂB
	 */
	public static final String CLASS_DICTIONARY_PATH = "nga.servlet.class-dictionary-path";

	/**
	 * ݎs service Ɋւ B{@value}
	 */
	private static final String SERVICE_INFO = "nga.service.info";

	/**
	 * SessionBindingListenerB
	 */
	private static final String SESSION_BINDING_LISTENER = "nga.session.binding.listener";

	/**
	 * t@NgB
	 */
	private CongaServletFactory factory;
	
	/**
	 * A_v^NXB
	 */
	private List<Class<? extends CongaServletAdapter>> adapterClassList;

	/**
	 * W[Ƃ̃NGXg}bvB
	 */
	private Map<String, ModuleInfo> moduleInfoMap = new HashMap<String, ModuleInfo>();
	
	/**
	 * charset ̃}bvB
	 */
	private Map<String, String> charsetMap = new HashMap<String, String>();

	/**
	 * \[XB
	 */
	private Resource resource = new Resource(getClass().getPackage().getName() + ".Message");
	
	/**
	 * \[X`^OB
	 */
	private char resourceTag = '@';

	/**
	 * CongaServletAdapterB
	 */
	private ThreadLocal<CongaServletAdapter> adapter = new ThreadLocal<CongaServletAdapter>() {
		protected synchronized CongaServletAdapter initialValue() {
			return new CongaServletAdapterMultiCaster(adapterClassList);
		}
	};
	
	/**
	 * ParameterParser ̃CX^X}bvB
	 */
	private static ThreadLocal<Map<String, ParameterParser>> parserMap = new ThreadLocal<Map<String, ParameterParser>>() {
		protected synchronized Map<String, ParameterParser> initialValue() {
			return new HashMap<String, ParameterParser>();
		}
	};
	
	/**
	 * ResultWriter ̃CX^X}bvB
	 */
	private static ThreadLocal<Map<String, ResultWriter>> writerMap = new ThreadLocal<Map<String, ResultWriter>>() {
		protected synchronized Map<String, ResultWriter> initialValue() {
			return new HashMap<String, ResultWriter>();
		}
	};

	/**
	 * T[oVXep̃GR[fBOB
	 */
	private String systemEncoding;
	
	/**
	 * 
	 */
	private ClassDictionary classDictionary;

	/**
	 * CongaServlet 쐬B
	 */
	public CongaServlet() {
	}
	
	/**
	 * T[ubg̏ɌĂяoB
	 * web.xml Ŏw肳ꂽp^̐ݒ菈sC
	 * {@link CongaServletAdapter#init(CongaServlet)} ĂяoB
	 */
	public void init() throws ServletException {
		// \[X^O̐ݒ擾sȂB
		initResourceTag();
		
		// ClassDictionary ̐ݒsȂB
		initClassDictionary();

		// CongaServletFactory ̐ݒsȂB
		initFactory();
		
		// CongaServletAdapter ̐ݒsȂB
		initAdapter();
		
		// encoding ̐ݒsȂB
		initEncoding();
		
		// A_v^̏sȂB
		adapter.get().init(this);
	}
	
	/**
	 * \[X^O̐ݒ擾sȂB
	 */
	private void initResourceTag() {
		String tag = getServletConfig().getInitParameter(RESOURCE_TAG);
		if(tag!=null && tag.length() > 0) {
			resourceTag = tag.charAt(0);
		}
	}

	/**
	 * ClassDictionary ̏sȂB
	 */
	@SuppressWarnings("unchecked")
	private void initClassDictionary() {
		String path = getServletConfig().getInitParameter(CLASS_DICTIONARY_PATH);
		if(path==null) {
			path = "conf/ClassDictionary.properties";
		}
		try {
			classDictionary = new ClassDictionary(getServletContext().getRealPath(path));
		}
		catch (Exception e) {
			throw new ConfigurationException(e);
		}
	}
	
	/**
	 * A_v^NX̐ݒsȂB
	 */
	private void initAdapter() throws ServletException {
		adapterClassList = new ArrayList<Class<? extends CongaServletAdapter>>();
		String adapterList = getServletConfig().getInitParameter(ADAPTER);
		if(adapterList==null) {
			adapterClassList.add(ExceptionLogger.class);
		}
		else {
			try {
				StringTokenizer st = new StringTokenizer(adapterList, " ,\n\r;:");
				while(st.hasMoreTokens()) {
					adapterClassList.add(Class.forName(st.nextToken()).asSubclass(CongaServletAdapter.class));
				}
			}
			catch (Exception e) {
				throw new ServletException(e);
			}
		}
	}

	/**
	 * web.xml ̏p^i{@link #CHARSET}, {@link #SYSTEM_ENCODING}j߂C
	 * GR[fBOB
	 */
	private void initEncoding() {
		// VXepݒB
		systemEncoding = getServletConfig().getInitParameter(SYSTEM_ENCODING);
		if(systemEncoding==null) {
			// web.xml Ɏw肳ĂȂꍇ́CVM WGR[fBOgpB
			systemEncoding = System.getProperty("file.encoding");
		}
		
		// [UP[ charset `B
		String cs = getServletConfig().getInitParameter(CHARSET);
		if(cs==null) {
			charsetMap.put(null, systemEncoding);
		}
		else {
			StringTokenizer st = new StringTokenizer(cs, " ;,:\t\n\r");
			while(st.hasMoreTokens()) {
				String line = st.nextToken();
				int index = line.indexOf('=');
				
				String locale = null;
				String charset = systemEncoding;
				if(index > 0 && index < line.length()-1) {
					locale = line.substring(0, index).trim();
					charset = line.substring(index+1).trim();
				}
				charsetMap.put(locale, charset);
			}
		}
	}

	/**
	 * CongaServletFactory ̐ݒsȂB
	 * @param config ݒB
	 */
	private void initFactory() throws ServletException {
		String factoryClassName = getServletConfig().getInitParameter(FACTORY);
		if(factoryClassName!=null) {
			try {
				factory = newInstance(Class.forName(factoryClassName).asSubclass(CongaServletFactory.class));
			}
			catch (Exception e) {
				throw new ServletException(e);
			}
		}
		else {
			factory = new DefaultCongaServletFactory();
		}
	}
	
	/**
	 * 又B<br>
	 * {@link ParameterParser}, Controller, {@link ResultWriter} ̌ĂяosȂB
	 * ܂CL̏̑OƂāC{@link CongaServletAdapter#begin CongaServletAdapter.begin},
	 * ĂяoC㏈Ƃ {@link CongaServletAdapter#end CongaServletAdapter.end} ĂяoB
	 * Oɂ́C{@link CongaServletAdapter#abort CongaServletAdapter.abort} ĂяoB
	 * @see javax.servlet.http.HttpServlet#service(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	@Override
	protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		// T[rX쐬B
		ServiceInfo serviceInfo = new ServiceInfo(this, request, response, systemEncoding);
		request.setAttribute(SERVICE_INFO, serviceInfo);
		String requestId = request.getServletPath();
		serviceInfo.setRequestId(requestId);

		// ZV쐬`FbNsȂB
		checkSession(serviceInfo);

		// UserLocale ̐ݒ
		initLocale(serviceInfo);
		
		// charset ̐ݒ
		initCharset(request);

		try {
			// y[WX^bN쐬B
			PageStack pageStack = getPageStack(request);
			Page page = pageStack.getPage();
			serviceInfo.setPageStack(pageStack);

			adapter.get().begin(serviceInfo);

			// NGXg擾B
			RequestInfo requestInfo = getRequestInfo(requestId);
			if(requestInfo==null) {
				throw new ConfigurationException(resource.message("m_request_not_found", requestId));
			}
			
			// G[쐬B
			serviceInfo.setErrorInfo(new ErrorInfo(requestInfo.getResultInfo().getModuleInfo()));

			// bNl
			if(lock(request, page)) {
				try {
					// 又iParameterParser - Controller - ResultWriter Ăяoj
					mainProc(serviceInfo, requestInfo, pageStack);
				}
				finally {
					// bN
					page.unlock();
				}
			}
			else {
				// bN擾łȂꍇ́Cf[^o͂ďIB
				response.setContentType("text/xml; charset=UTF-8");
				PrintWriter writer = response.getWriter();
				writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
				writer.println("<c></c>");
			}
		}
		catch(Throwable e) {
			adapter.get().abort(serviceInfo, e);
		}
		finally {
			adapter.get().end(serviceInfo, requestId);
		}

	}
	
	/**
	 * p҂̃P[ݒ肷B
	 * @param serviceInfo T[rXB
	 */
	private void initLocale(ServiceInfo serviceInfo) {
		User user = UserAuth.getUser(serviceInfo);
		if(user!=null && user.isAuthorized()) {
			UserAttribute attr = user.getAttribute();
			if(attr!=null) {
				UserLocale.setLocale(attr.getLocale());
				return;
			}
		}

		UserLocale.setLocale(serviceInfo.getRequest().getLocale());
	}

	/**
	 * @param session
	 * @throws ServletException 
	 */
	private void checkSession(ServiceInfo serviceInfo) 
			throws ServletException {
		HttpSession session = serviceInfo.getSession();
		if(session.getAttribute(SESSION_BINDING_LISTENER)==null) {
			session.setAttribute(
					SESSION_BINDING_LISTENER, 
					new HttpSessionBindingListener(){
						public void valueBound(HttpSessionBindingEvent event) {
						}
						public void valueUnbound(HttpSessionBindingEvent event) {
							adapter.get().sessionDestroyed(CongaServlet.this, event.getSession());
						}
						
					}
			);
			adapter.get().sessionCreated(serviceInfo);
		}
	}

	/**
	 * bN̎擾sȂB
	 * @return bN擾łꍇ trueBoȂꍇ falseB
	 */
	private boolean lock(HttpServletRequest request, Page page) {
		String param = request.getParameter(ASYNC);
		
		// ASYNC p^w肪Ȃꍇ́CbN܂ wait B
		if(param==null) {
			while(true) {
				if(!page.isLocked()) {
					page.lock();
					return true;
				}
				try{Thread.sleep(20);}
				catch(Exception e){}
			}
		}

		// ASYNC p^ true ̏ꍇ́CbN҂sȂȂB
		if(Boolean.parseBoolean(param)) {
			return true;
		}
		else {
			if(!page.isLocked()) {
				page.lock();
				return true;
			}
			else {
				return false;
			}
		}
	}

	private void mainProc(ServiceInfo serviceInfo, RequestInfo requestInfo, PageStack pageStack) throws Throwable {
		HttpServletRequest request = serviceInfo.getRequest();
		Page page = pageStack.getPage();

		// y[WIuWFNg擾B
		Object pageObject = getPageObject(request, requestInfo, page);
		serviceInfo.setPageObject(pageObject);
		serviceInfo.setRequestInfo(requestInfo);

		Object resultObject = null;

		// ParameterParser ĂяoB
		boolean parsed = true;
		ParameterInfo parameterInfo = requestInfo.getParameterInfo();
		if(parameterInfo!=null && pageObject!=null && parameterInfo.isDefined()) {
			parsed = getParameterParser(parameterInfo).parse(serviceInfo);
		}

		// Controller ĂяoB
		if(parsed) {
			// controller ĂяoB
			resultObject = execController(serviceInfo, requestInfo, pageObject, page);
		}

		if(resultObject==null) {
			resultObject = pageObject;
		}

		// ʏ serviceInfo ɃZbgB
		serviceInfo.setResultObject(resultObject);
		
		// y[WX^bN̏ԂXVB
		if(!serviceInfo.hasError()) {
			serviceInfo.updatePageStack();
		}

		// NGXgIDύXɂȂĂꍇ́Cforward B
		if(serviceInfo.isForwarding()) {
			if(serviceInfo.getResultInfo()!=null) {
				getResultWriter(serviceInfo.getResultInfo()).write(serviceInfo);
			}

			String nextRequestId = serviceInfo.getNextRequestId();
			adapter.get().forwarding(serviceInfo, serviceInfo.getRequestId(), nextRequestId);
			page.unlock();
			request.getRequestDispatcher(nextRequestId).forward(request, serviceInfo.getResponse());
			return;
		}

		// ResultWriter ̌ĂяosȂB
		getResultWriter(serviceInfo.getResultInfo()).write(serviceInfo);
	}

	/**
	 * {@link ServletRequest#setCharacterEncoding ServletRequest.setCharacterEncoding}
	 * \bhĂяoCLN^GR[fBOݒ肷B
	 * LN^GR[fBO͈ȉ̎葱ɂ茈肳B<br>
	 * <ol>
	 * <li> NGXg ContentType wb_ charset= ŖĂꍇ́CgpB</li>
	 * <li> ContentType wb_ł̎w肪Ȃꍇ́Cweb.xml ̏p^i{@value #CHARSET}j
	 * @@Ŏw肳ꂽl̒C݂̃[UP[ɍv̂gpB</li>
	 * <li> K؂Ȃ̂Ȃꍇ́Cweb.xml ̏p^({@value #SYSTEM_ENCODING})
	 *     Ŏw肳ꂽlgpB</li>
	 * <li> {@value #SYSTEM_ENCODING} w肳ĂȂꍇ́CVM ̃ftHgGR[fBO
	 *     gpB</li>
	 * </ol>
	 * @param request NGXgB
	 */
	private void initCharset(HttpServletRequest request) throws UnsupportedEncodingException {
		String charset = null;
		// contenttype wb_ charset w肪ꍇ́CgpB
		String contentType = request.getContentType();
		int index = (contentType!=null)?contentType.lastIndexOf("charset="):-1;
		if(index>-1) {
			charset = contentType.substring(index+8);
		}
		else {
			// wb_w肪Ȃꍇ́Cweb.xml Őݒ肳ꂽP[ʃLN^ZbggpB
			Locale locale = UserLocale.getLocale();
			if(locale!=null) {
				charset = charsetMap.get(locale.toString());
			}
			if(charset==null) {
				charset = charsetMap.get(null);
				if(charset==null) {
					// w肳ĂȂꍇ́CVXeGR[fBOgpB
					charset = systemEncoding;
				}
			}
		}
		request.setCharacterEncoding(charset);
	}

	/**
	 * NGXg擾B
	 * @param path NGXgpXB
	 * @return NGXgB
	 */
	private RequestInfo getRequestInfo(String path) throws ServletException {
		int index = path.lastIndexOf('/');
		String moduleName = path.substring(0, index);
		String requestId = path.substring(index+1);

		ModuleInfo moduleInfo;
		synchronized(moduleInfoMap) {
			moduleInfo = moduleInfoMap.get(moduleName);
			if(moduleInfo==null) {
				// W[ moduleInfoMap ɂȂꍇ̓t@C̓ǂݍ݂sȂB
				moduleInfo = new RequestConfigInitializer().
									getModuleInfo(moduleName, getServletConfig(), getServletContext(), resourceTag);
			}
		}
		
		return moduleInfo.getRequestInfo(requestId);
	}

	/**
	 * ݎs service Ɋւ擾B
	 * @param request NGXgB
	 * @return ݎs service ɊւB
	 */
	public static ServiceInfo getServiceInfo(HttpServletRequest request) {
		return (ServiceInfo)request.getAttribute(SERVICE_INFO);
	}

	/**
	 * y[W擾B
	 */
	private PageStack getPageStack(HttpServletRequest request) {
		String pageStackKey = request.getParameter(WINDOW_ID) + "@pageStack";
		HttpSession session = request.getSession();
		PageStack pageStack = (PageStack)session.getAttribute(pageStackKey);
		if(pageStack==null) {
			pageStack = new PageStack();
			session.setAttribute(pageStackKey, pageStack);
		}
		return pageStack;
	}
	
	/**
	 * EChEIDƂėp\ȕ擾B
	 * @return EChEIDƂėp\ȕB
	 */
	public static String getWindowId() {
		return "w" + System.currentTimeMillis();
	}

	/**
	 * y[WIuWFNg擾B
	 * @return y[WIuWFNgB
	 */
	@SuppressWarnings("all")
	private Object getPageObject(HttpServletRequest request, RequestInfo requestInfo, Page page) 
			throws InstantiationException, IllegalAccessException {
		String pageId = requestInfo.getPageId();
		String moduleId = requestInfo.getModuleInfo().getId();
		Class pageClass = null;
		try {
			pageClass = requestInfo.getPageClass();
			if(pageClass==null) {
				return null;
			}
		}
		catch (ClassNotFoundException e) {
			throw new ConfigurationException(resource.message("m_class_not_found", requestInfo.getPage()), e);
		}

		Object pageObject;
		if(pageId!=null) {
			if(moduleId.equals(page.getModuleId()) && pageId.equals(page.getPageId())) {
				pageObject = page.getPageObject();
			}
			else {
				pageObject = newInstance(pageClass);
			}
		}
		else {
			pageObject = newInstance(pageClass);
		}

		page.setModuleId(moduleId);
		page.setPageId(pageId);
		page.setPageObject(pageObject);
		return pageObject;
	}

	/**
	 * w肳ꂽ ParameterInfo ŗpł ParameterParser 擾B
	 * @param parameterInfo p^B
	 * @return ParaterParserB
	 */
	private ParameterParser getParameterParser(ParameterInfo parameterInfo) {
		Class<ParameterParser> parserClass = parameterInfo.getParser();
		String parserClassName = "";
		if(parserClass!=null) {
			parserClassName = parserClass.getName();
		}
		ParameterParser parser = parserMap.get().get(parserClassName);

		if(parser==null) {
			if("".equals(parserClassName)) {
				parser = factory.createParameterParser();
			}
			else {
				parser = newInstance(parserClass);
			}
			parserMap.get().put(parserClassName, parser);
		}
		return parser;
	}

	/**
	 * Rg[̃\bhsB
	 * @param serviceInfo sReLXgB
	 * @param requestInfo request ^ȌB
	 * @param valueObject ΏۃIuWFNgB
	 * @return ʃIuWFNgB
	 */
	@SuppressWarnings("unchecked")
	private Object execController(ServiceInfo serviceInfo, RequestInfo requestInfo, Object valueObject, Page page) throws Throwable {
		
		Object controller = null;
		Method method = null;
		Object[] param = null;
		if(requestInfo.hasController()) {
			Class c = requestInfo.getControllerClass();
			if(c!=null) {
				controller = page.getController(c);
				if(controller==null) {
					controller = newInstance(c);
					page.putController(c, controller);
				}
				method = requestInfo.getControllerMethod();
			}
			else { // NGXgɃRg[NXw肳ĂȂꍇ valueObject Rg[ƂB
				controller = valueObject;
				method = requestInfo.getControllerMethod(controller.getClass());
			}
	
			Class[] paramClass = method.getParameterTypes();
			param = new Object[paramClass.length];
	
			for(int i=0; i<param.length; i++) {
				if(paramClass[i].isAssignableFrom(ServiceInfo.class)) {
					param[i] = serviceInfo;
				}
				else if(paramClass[i].isAssignableFrom(HttpServletRequest.class)) {
					param[i] = serviceInfo.getRequest();
				}
				else if(paramClass[i].isAssignableFrom(HttpServletResponse.class)) {
					param[i] = serviceInfo.getResponse();
				}
				else if(valueObject!=null && paramClass[i].isAssignableFrom(valueObject.getClass())) {
					param[i] = valueObject;
				}
			}
		}

		Object resultObject = null;

		if(adapter.get().checkParameter(serviceInfo, controller, method, param)) {
			try {
				if(controller!=null && method!=null) {
					resultObject = method.invoke(controller, param);
				}
			}
			catch (InvocationTargetException e) {
				throw e.getCause();
			}
			adapter.get().editResult(serviceInfo, controller, method, resultObject);
		}

		return resultObject;
	}

	/**
	 * ResultWriter 擾B
	 */
	private ResultWriter getResultWriter(ResultInfo resultInfo) {
		Class<ResultWriter> writerClass = resultInfo.getWriter();
		String writerClassName = "";
		if(writerClass!=null) {
			writerClassName = writerClass.getName();
		}
		ResultWriter writer = writerMap.get().get(writerClassName);

		if(writer==null) {
			if("".equals(writerClassName)) {
				writer = factory.createResultWriter();
			}
			else {
				writer = newInstance(writerClass);
			}
			writerMap.get().put(writerClassName, writer);
		}
		return writer;
	}

	/**
	 * T[ubgIB
	 */
	public void destroy() {
		try {
			adapter.get().destroy(this);
		}
		finally {
			super.destroy();
		}
	}
	
	/**
	 * \[X`^O擾B
	 * @see #RESOURCE_TAG
	 */
	public char getResourceTag() {
		return resourceTag;
	}
	
	/**
	 * w肳ꂽNX̃CX^X擾B
	 * @param cls CX^X쐬NXB
	 * @return 쐬CX^XB
	 */
	public <T> T newInstance(Class<T> cls) {
		return classDictionary.newInstance(cls);
	}

	/**
	 * w肵NX̃CX^X擾B
	 * ̃\bhō쐬ꂽCX^Xɂꍇ́C
	 * 쐬ς݂̃CX^XԂB
	 * @param cls CX^X擾NXB
	 * @return 擾CX^XB
	 */
	public <T> T getSingleInstance(Class<T> cls) {
		return classDictionary.getSingleInstance(cls);
	}
}
