/*
 *ServiceInfo.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import nga.servlet.config.ParameterInfo;
import nga.servlet.config.PropertyInfoMap;
import nga.servlet.config.RequestInfo;
import nga.servlet.config.ResultInfo;
import nga.servlet.config.TargetInfoList;
import nga.servlet.spi.CongaServletLog;
import nga.servlet.spi.CongaServletRDB;
import nga.sql.RDB;
import nga.util.ConfigurationException;
import nga.util.Log;
import nga.util.Resource;

/**
 * {@link CongaServlet#service(HttpServletRequest, HttpServletResponse) service} 
 * \bh̎sB<br>
 * ĂяoRg[̃\bhɂ̃NẌ΁C
 * CongaServlet Rg[Ăяoɂ̃NX̃CX^XnB<br>
 * ĂяoRg[̃\bhɂ̃NẌȂꍇ́CnȂB
 */
public class ServiceInfo {

	// y[WX^bNF폜
	private static final int REMOVE_PAGE = 1;

	// y[WX^bNFۑ
	private static final int SAVE_PAGE = 2;

	/**
	 * CongaServlet
	 */
	private CongaServlet servlet;

	/**
	 * T[ubgNGXgB
	 */
	private HttpServletRequest request;
	
	/**
	 * T[ubgX|XB
	 */
	private HttpServletResponse response;
	
	/**
	 * ZbVB
	 */
	private HttpSession session;
	
	/**
	 * VXeGR[fBOB
	 */
	private String systemEncoding;

	/**
	 * G[B
	 */
	private ErrorInfo errorInfo;
	
	/**
	 * NGXg^OB
	 */
	private RequestInfo requestInfo;

	/**
	 * NGXgIDB
	 */
	private String requestId;
	
	/**
	 * Ɏs郊NGXgIDB
	 */
	private String nextRequestId;
	
	/**
	 * y[WIuWFNgB
	 */
	private Object pageObject;
	
	/**
	 * ʃIuWFNgB
	 */
	private Object resultObject;
	
	/**
	 * y[WX^bNB
	 */
	private PageStack pageStack;
	
	/**
	 * ݂̃y[WB
	 */
	private Page page;

	/**
	 * X^bNB
	 */
	private int pageStackOperation;
	
	/**
	 * OB
	 */
	private Log log;

	/**
	 * ServiceInfo 쐬B
	 * @param servlet CongaServlet
	 * @param request NGXgB
	 * @param response X|XB
	 * @param systemEncoding VXeGR[fBOB
	 */
	ServiceInfo(CongaServlet servlet, HttpServletRequest request, HttpServletResponse response, String systemEncoding) {
		this.servlet = servlet;
		this.request = request;
		this.response = response;
		this.session = request.getSession();
		this.systemEncoding = systemEncoding;
		this.log = createLog();
		createRDB();
	}
	
	private Log createLog() {
		CongaServletLog log = newInstance(CongaServletLog.class);
		log.init(this);
		Log.setInstance(log);
		return log;
	}
	
	private RDB createRDB() {
		CongaServletRDB rdb = newInstance(CongaServletRDB.class);
		rdb.init(this);
		RDB.setInstance(rdb);
		return rdb;
	}
	
	/**
	 * CongaServlet 擾B
	 */
	public CongaServlet getServlet() {
		return servlet;
	}

	/**
	 * T[ubgNGXg擾B
	 * @return T[ubgNGXgB
	 */
	public HttpServletRequest getRequest() {
		return request;
	}

	/**
	 * T[ubgX|X擾B
	 * @return T[ubgX|XB
	 */
	public HttpServletResponse getResponse() {
		return response;
	}

	/**
	 * ZbV擾B
	 * @return ZbVB
	 */
	public HttpSession getSession() {
		return session;
	}

	/**
	 * VXeGR[fBO擾B
	 * web.xml ̏p^ {@link CongaServlet#SYSTEM_ENCODING} Ŏw肳ꂽԂB
	 * @return VXeGR[fBOB
	 */
	public String getSystemEncoding() {
		return systemEncoding;
	}

	/**
	 * G[擾B
	 * @return G[B
	 */
	public ErrorInfo getErrorInfo() {
		return errorInfo;
	}

	/**
	 * G[ZbgB
	 * @param errorInfo G[B
	 */
	void setErrorInfo(ErrorInfo errorInfo) {
		this.errorInfo = errorInfo;
	}
	
	/**
	 * G[bZ[WZbgB
	 * @param message bZ[WB
	 * @param args bZ[WB
	 */
	public ErrorInfo setErrorMessage(String message, Object... args) {
		return getErrorInfo().setMessage(message, args);
	}

	/**
	 * OZbgB
	 * @param exception OB
	 */
	public void setException(Throwable exception) {
		getErrorInfo().setException(exception);
	}
	
	
	/**
	 * ݂̃NGXgG[ԂƂċL^B
	 */
	public void setError() {
		errorInfo.setError();
	}

	/**
	 * request ^O擾B
	 * @return request ^OB
	 */
	public RequestInfo getRequestInfo() {
		return requestInfo;
	}

	/**
	 * request ^OZbgB
	 * @param requestInfo request ^OB
	 */
	void setRequestInfo(RequestInfo requestInfo) {
		this.requestInfo = requestInfo;
		ResultInfo resultInfo = requestInfo.getResultInfo();
		setNextRequestId(resultInfo);
	}
	
	private void setNextRequestId(ResultInfo resultInfo) {
		String nextRequestId = null;
		
		nextRequestId = resultInfo.getForward();
		if(nextRequestId!=null) {
			forward(nextRequestId);
			return;
		}
		
		nextRequestId = resultInfo.getCall();
		if(nextRequestId!=null) {
			String callBackRequestId = resultInfo.getCallBack();
			if(callBackRequestId==null) {
				throw new ConfigurationException(
					Resource.getMessage(getClass().getPackage().getName() + ".Message", "m_null_call_back")
				);
			}
			call(nextRequestId, callBackRequestId);
			return;
		}
		
		TargetInfoList targetInfoList = resultInfo.getTargetInfoList();
		if(targetInfoList==null || targetInfoList.isEmpty()) {
			returnToCaller();
			return;
		}
	}

	/**
	 * NGXgID擾B
	 * @return NGXgIDB
	 */
	public String getRequestId() {
		return requestId;
	}

	/**
	 * NGXgIDZbgB
	 * @param requestId NGXgIDB
	 */
	void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	/**
	 * Ɏs郊NGXgID擾B
	 * @return Ɏs郊NGXgIDB
	 */
	public String getNextRequestId() {
		return nextRequestId;
	}

	/**
	 * Ɏs郊NGXgIDZbgB
	 * @param requestId Ɏs郊NGXgIDB
	 */
	void setNextRequestId(String requestId) {
		this.nextRequestId = requestId;
	}

	/**
	 * result ^O擾B<br>
	 * @return result ^OB
	 */
	public ResultInfo getResultInfo() {
		if(hasError()) {
			if(requestInfo.hasOnErrorInfo()) {
				return requestInfo.getOnErrorInfo();
			}
			else {
				return requestInfo.getResultInfo();
			}
		}
		else if(isForwarding()){
			return requestInfo.getOnForwardingInfo();
		}
		else {
			return requestInfo.getResultInfo();
		}
	}

	/**
	 * result ^O target ^O񃊃Xg擾B<br>
	 * getRequestInfo().getResultInfo().getTargetInfoList() ̃V[gJbgB
	 * @return target ^ÕXgB
	 */
	public TargetInfoList getTargetInfoList() {
		return getResultInfo().getTargetInfoList();
	}

	/**
	 * parameter ^O擾B<br>
	 * getRequestInfo().getParameterInfo() ̃V[gJbgB
	 * @return parameter ^OB
	 */
	public ParameterInfo getParameterInfo() {
		return requestInfo.getParameterInfo();
	}

	/**
	 * property ^Õ}bv擾B<br>
	 * getRequestInfo().getParameterInfo().getPropertyInfoMap() ̃V[gJbgB
	 * @return property ^Õ}bvB
	 */
	public PropertyInfoMap getPropertyInfoMap() {
		return requestInfo.getParameterInfo().getPropertyInfoMap();
	}
	
	/**
	 * y[WIuWFNg擾B
	 * @return y[WIuWFNgB
	 */
	public Object getPageObject() {
		return pageObject;
	}

	/**
	 * y[WIuWFNgZbgB
	 * @param pageObject y[WIuWFNgB
	 */
	void setPageObject(Object pageObject) {
		this.pageObject = pageObject;
	}

	/**
	 * ʃIuWFNg擾B<br>
	 * Rg[sɎ擾ł悤ɂȂB<br>
	 * ʃIuWFNǵĈǂ炩ƂȂB
	 * <ol>
	 * <li>Rg[ null ȊO̖߂lԂꍇ́C̃IuWFNgB</li>
	 * <li>Rg[ null ȊO̖߂lԂȂꍇ́C
	 * {@link #getPageObject() getPageObject}Ŏ擾ły[WIuWFNgƓ̃IuWFNgB</li>
	 * </ol>
	 * @return ʃIuWFNgBRg[sO nullB
	 */
	public Object getResultObject() {
		return resultObject;
	}

	/**
	 * ʃIuWFNgZbgB
	 * @param resultObject ʃIuWFNgB
	 */
	void setResultObject(Object resultObject) {
		this.resultObject = resultObject;
	}

	/**
	 * w肳ꂽNX̃CX^X擾B
	 * @param cls CX^X쐬NXB
	 * @return 쐬CX^XB
	 */
	public <T> T newInstance(Class<T> cls) {
		return servlet.newInstance(cls);
	}

	/**
	 * w肵NX̃CX^X擾B
	 * ̃\bhō쐬ꂽCX^Xɂꍇ́C
	 * 쐬ς݂̃CX^XԂB
	 * @param cls CX^X擾NXB
	 * @return 擾CX^XB
	 */
	public <T> T getSingleInstance(Class<T> cls) {
		return servlet.getSingleInstance(cls);
	}
	
	/**
	 * y[WX^bNZbgB
	 * @param pageStack y[WX^bNB
	 */
	void setPageStack(PageStack pageStack) {
		this.pageStack = pageStack;
		this.page = pageStack.getPage();
	}
	
	/**
	 * w肵ID̃NGXgs\񂷂B
	 * @param requestId Ɏs郊NGXgIDB
	 */
	public void forward(String requestId) {
		setNextRequestId(requestId);
	}
	
	/**
	 * w肵ID̃NGXgs\񂷂B
	 * {@link #returnToCaller()} \bhŁCݎs̃NGXgĂяoƂłB
	 * @param requestId Ɏs郊NGXgIDB
	 */
	public void call(String requestId, String callBackRequestId) {
		setNextRequestId(requestId);
		if(page!=null) {
			page.setCallBackRequestId(callBackRequestId);
			pageStackOperation = SAVE_PAGE;
		}
	}
	
	/**
	 * {@link #call(String, String) } \bhĂяoNGXg̎s\񂷂B
	 */
	public void returnToCaller() {
		Page previousPage = pageStack.getPreviousPage();
		if(previousPage!=null) {
			String nextRequestId = previousPage.getCallBackRequestId();
			setNextRequestId(nextRequestId);			
			pageStackOperation = REMOVE_PAGE;
		}
	}
	
	/**
	 * y[WX^bN̏ԂXVB
	 */
	void updatePageStack() {
		if(pageStackOperation==REMOVE_PAGE) {
			pageStack.removePage();
		}
		else if(pageStackOperation==SAVE_PAGE){
			pageStack.savePage();
		}
		pageStackOperation = 0;
	}
	
	/**
	 * G[Ă邩ǂ𒲂ׂB
	 * @return G[Ăꍇ trueB
	 */
	public boolean hasError() {
		return getErrorInfo().hasError();
	}
	
	/**
	 * ʑJڏԂɂ邩ǂ𒲂ׂB
	 * @return ʑJڏԂɂꍇ trueB
	 */
	public boolean isForwarding() {
		String oldRequestId = getRequestId();
		String nextRequestId = getNextRequestId();
		if(!hasError() && nextRequestId!=null && !nextRequestId.equals(oldRequestId)) {
			return true;
		}
		else {
			return false;
		}
	}
	
	/**
	 * O擾B
	 * @return OB
	 */
	public Log getLog() {
		return log;
	}
}
