/*
 *ModuleInfo.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.config;

import java.util.HashMap;
import java.util.Map;

import nga.util.Resource;


/**
 * W[B
 * ̃fBNgɊi[Ă郊NGXgt@C̓eC
 * ЂƂ̃W[ƂȂB
 */
public class ModuleInfo {
	
	/**
	 * ̃W[IDB
	 */
	private String id;
	
	/**
	 * y[W}bvB
	 */
	private Map<String, PageInfo> pageInfoMap = new HashMap<String, PageInfo>();
	
	/**
	 * NGXg}bvB
	 */
	private Map<String, RequestInfo> requestInfoMap = new HashMap<String, RequestInfo>();
	
	/**
	 * \[X}bvB
	 */
	private Map<String, ResourceInfo> resourceInfoMap = new HashMap<String, ResourceInfo>();
	
	/**
	 * F؂KvǂB
	 */
	private String auth;

	/**
	 * \[X`^OB
	 */
	final char resourceTag;

	/**
	 * ModuleInfo 쐬B
	 * @param id ̃W[IDB
	 */
	public ModuleInfo(String id, char resourceTag) {
		this.id = id;
		this.resourceTag = resourceTag;
	}
	
	/**
	 * W[ID 擾B
	 * {@link javax.servlet.http.HttpServletRequest#getServletPath() HttpServletRequest.getServletPath()}
	 * Ŏ擾pX̒ŃfBNg܂łW[IDƂȂB
	 * @return W[IDB
	 */
	public String getId() {
		return id;
	}


	/**
	 * y[WZbgB
	 * @param pageId y[WIDB
	 * @param pageInfo y[WB
	 * @return  pageId łłɓo^ς݂ꍇCo^ς݂y[WԂB
	 */
	public PageInfo setPageInfo(String pageId, PageInfo pageInfo) {
		return pageInfoMap.put(pageId, pageInfo);
	}


	/**
	 * y[W擾B
	 * @param pageId y[WIDB
	 * @return y[WB
	 */
	public PageInfo getPageInfo(String pageId) {
		return pageInfoMap.get(pageId);
	}


	/**
	 * NGXgZbgB
	 * @param requestId NGXgIDB
	 * @param requestInfo NGXgB
	 * @return  requestId łłɓo^ς݂ꍇCo^ς݂NGXgԂB
	 */
	public RequestInfo setRequestInfo(String requestId, RequestInfo requestInfo) {
		requestInfo.setModuleInfo(this);
		return requestInfoMap.put(requestId, requestInfo);
	}


	/**
	 * NGXg擾B
	 * @param requestId
	 * @return NGXgB
	 */
	public RequestInfo getRequestInfo(String requestId) {
		return requestInfoMap.get(requestId);
	}


	/**
	 * \[XZbgB
	 * @param resourceId \[XIDB
	 * @param resourceInfo \[XB
	 * @return  resourceId łłɓo^ς݂ꍇCo^ς݂\[XԂB
	 */
	public ResourceInfo setResourceInfo(String resourceId, ResourceInfo resourceInfo) {
		return resourceInfoMap.put(resourceId, resourceInfo);
	}

	/**
	 * \[X擾B
	 * @param resourceId \[XIDB
	 * @return \[XB
	 */
	public ResourceInfo getResourceInfo(String resourceId) {
		return resourceInfoMap.get(resourceId);
	}

	/**
	 * auth擾B
	 * @return authB
	 */
	public String getAuth() {
		return auth;
	}

	/**
	 * authZbgB
	 * @param auth authB
	 */
	public void setAuth(String auth) {
		this.auth = auth;
	}

	/**
	 * w肳ꂽL[Ń\[Xݒ肳Ă镶l擾B<br>
	 * L[́Cdspf.dtfmt ̂悤ɁC
	 * [\[XID].[L[]ƂȂĂKvB
	 * @param key L[B
	 * @return B
	 */
	public String getText(String key) {
		int index = getSeparatorIndex(key);
		if(index <= 0 ) {
			return key;
		}
		
		Resource resource = getResource(key.substring(0, index));
		if(resource==null) {
			return key;
		}
		return resource.get(key.substring(index+1));
	}
	
	/**
	 * w肳ꂽL[Ń\[Xݒ肳Ă郁bZ[W擾B<br>
	 * L[́Cdspm.parse_error ̂悤ɁC
	 * [\[XID].[L[]ƂȂĂKvB
	 * @param key L[B
	 * @param args bZ[WB
	 * @return bZ[WB
	 */
	public String getMessage(String key, Object... args) {
		int index = getSeparatorIndex(key);
		if(index <= 0 ) {
			return key;
		}
		
		Resource resource = getResource(key.substring(0, index));
		if(resource==null) {
			return key;
		}
		
		for(int i=0; i<args.length; i++) {
			if(args[i] instanceof String) {
				args[i] = getText((String)args[i]);
			}
		}

		return resource.message(key.substring(index+1), args);
	}

	private Resource getResource(String resourceId) {
		ResourceInfo resourceInfo = getResourceInfo(resourceId);
		if(resourceInfo==null) {
			return null;
		}		
		return resourceInfo.getResource(this);
	}
	
	private int getSeparatorIndex(String key) {
		if(key==null || key.length()==0) {
			return -1;
		}
		
		int index =key.indexOf('.');
		if(index==key.length()-1) {
			return -1;
		}
		return index;
	}

}
