/*
 *RequestInfo.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.config;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

import nga.util.ConfigurationException;
import nga.util.Resource;



/**
 * request ^OB
 */
public class RequestInfo implements Comparable {

	/**
	 * IDB
	 */
	private String id;
	
	/**
	 * y[WB
	 */
	private String page;
	
	/**
	 * y[WNXB
	 */
	private Class pageClass;

	/**
	 * Rg[NXB
	 */
	private Class controllerClass;
	
	/**
	 * Rg[\bhB
	 */
	private Method controllerMethod;
	
	/**
	 * Rg[\bhB
	 */
	private String controllerMethodName;

	/**
	 * vp[^B
	 */
	private ParameterInfo parameterInfo;
	
	/**
	 * ʕ\B
	 */
	private ResultInfo resultInfo;
	
	/**
	 * G[̏ʕ\B
	 */
	private ResultInfo onErrorInfo;
	
	/**
	 * ʑJځiOj̏ʕ\B
	 */
	private ResultInfo onForwardingInfo;

	/**
	 * W[B
	 */
	private ModuleInfo moduleInfo;
	
	/**
	 * authB
	 */
	private String auth;

	/**
	 * RequestInfo 쐬B
	 * @param id IDB
	 */
	public RequestInfo(String id) {
		this.id = id;
	}

	/**
	 * NGXgID擾B
	 * @return NGXgIDB
	 */
	public String getId() {
		return id;
	}

	/**
	 * y[Wl擾B
	 * @return y[WlB
	 */
	public String getPage() {
		return page;
	}

	/**
	 * y[WlZbgB
	 * @param page y[WlB
	 */
	public void setPage(String page) {
		this.page = page;
	}

	/**
	 * y[WNX擾B
	 * @return y[WNXB
	 */
	public Class getPageClass() throws ClassNotFoundException{
		if(pageClass==null) {
			if(page==null) {
				return null;
			}

			try {
				pageClass = getModuleInfo().getPageInfo(page).getPageClass();
			}
			catch(NullPointerException e) {
				pageClass = Class.forName(page);
			}
		}
		return pageClass;
	}
	
	/**
	 * y[WID擾B
	 * @return y[WIDB
	 */
	public String getPageId() {
		PageInfo pi = getModuleInfo().getPageInfo(page);
		if(pi==null) {
			return null;
		}
		else {
			return page;
		}
	}

	/**
	 * Rg[NX擾B
	 * @return Rg[NXB
	 */
	public Class getControllerClass() {
		return controllerClass;
	}
	
	/**
	 * Rg[NXyу\bhZbgB
	 * @param controllerClass Rg[NXB
	 * @param methodName Rg[\bhB
	 */
	public void setController(Class controllerClass, String methodName) {
		if(controllerClass==null) {
			this.controllerMethodName = methodName;
			return;
		}

		setControllerClass(controllerClass);
		setControllerMethod(controllerClass, methodName);
	}
	
	/**
	 * Rg[\bhݒ肷B
	 * @param controllerClass Rg[NXB
	 * @param methodName Rg[\bhB
	 */
	private void setControllerMethod(Class controllerClass, String methodName) {
		Method[] method = controllerClass.getMethods();
		for(int i=0; i < method.length; i++ ) {
			if(method[i].getName().equals(methodName) && 
					Modifier.isPublic(method[i].getModifiers())) {
				setControllerMethod(method[i]);
				break;
			}
		}

		if(getControllerMethod()==null) {
			throw new ConfigurationException(
				new Resource("nga.servlet.Message").
					message(
						"m_invalid_controller_method", 
						controllerClass.getName(), methodName
					)
			);
		}		
	}

	/**
	 * Rg[NXZbgB
	 * @param controllerClass Rg[NXB
	 */
	public void setControllerClass(Class controllerClass) {
		this.controllerClass = controllerClass;
	}

	/**
	 * Rg[\bh擾B
	 * @return Rg[\bhB
	 */
	public Method getControllerMethod() {
		return controllerMethod;
	}
	
	/**
	 * Rg[\bhw肳ꂽNX璊oB
	 * ̃CX^XɃRg[NXw肳ĂȂꍇ
	 * iValueObject Rg[ƂĎgpꍇjɎgpB
	 * @param controllerClass Rg[NXB
	 * @return Rg[\bhB
	 */
	public Method getControllerMethod(Class controllerClass) {
		if(controllerMethod==null) {
			setControllerMethod(controllerClass, this.controllerMethodName);
		}

		return getControllerMethod();
	}

	/**
	 * Rg[\bhZbgB
	 * @param controllerMethod Rg[\bhB
	 */
	public void setControllerMethod(Method controllerMethod) {
		this.controllerMethod = controllerMethod;
	}

	/**
	 * parameter ^O擾B
	 * @return parameter ^OB
	 */
	public ParameterInfo getParameterInfo() {
		if(parameterInfo==null) {
			parameterInfo = new ParameterInfo(moduleInfo);
		}
		return parameterInfo;
	}

	/**
	 * result ^O擾B
	 * @return result ^OB
	 */
	public ResultInfo getResultInfo() {
		if(resultInfo==null) {
			resultInfo = new ResultInfo(moduleInfo);
		}
		return resultInfo;
	}

	/**
	 * on-error ^O擾B
	 * @return on-error ^OB
	 */
	public ResultInfo getOnErrorInfo() {
		if(onErrorInfo==null) {
			onErrorInfo = new ResultInfo(moduleInfo);
		}
		return onErrorInfo;
	}
	
	/**
	 * on-error ^O`Ă邩ǂ𒲂ׂB
	 * @return on-error ^O`Ă trueB
	 */
	public boolean hasOnErrorInfo() {
		return onErrorInfo!=null;
	}

	/**
	 * on-forwarding ^O擾B
	 * @return on-forwarding ^OB
	 */
	public ResultInfo getOnForwardingInfo() {
		if(onForwardingInfo==null) {
			onForwardingInfo = new ResultInfo(moduleInfo);
		}
		return onForwardingInfo;
	}


	/**
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Object o) {
		if(o==null) {
			return 1;
		}
		else {
			return getId().compareTo(((RequestInfo)o).getId());
		}
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object o) {
		if(o==null) {
			return false;
		}
		else {
			return getId().equals(((RequestInfo)o).getId());
		}
	}
	
	public int hashCode() {
		return getId().hashCode();
	}

	/**
	 * W[擾B
	 * @return W[B
	 */
	public ModuleInfo getModuleInfo() {
		return moduleInfo;
	}

	/**
	 * W[ZbgB
	 * @param moduleInfo W[B
	 */
	public void setModuleInfo(ModuleInfo moduleInfo) {
		this.moduleInfo = moduleInfo;
	}

	/**
	 * ̃NGXgɃRg[w肪Ă邩ǂ𒲂ׂB
	 * @return Rg[w肪Ăꍇ trueB
	 */
	public boolean hasController() {
		return controllerClass!=null || controllerMethodName!=null;
	}

	/**
	 * auth擾B
	 * @return authB
	 */
	public String getAuth() {
		return auth;
	}

	/**
	 * authZbgB
	 * @param auth authB
	 */
	public void setAuth(String auth) {
		this.auth = auth;
	}
	
	/**
	 * ̃NGXgɔF؂Kvǂ𒲂ׂB
	 * @return F؂Kvȏꍇ trueB
	 */
	public boolean needAuth() {
		String auth = getAuth();
		if(auth!=null) {
			return auth.equalsIgnoreCase("true");
		}
		auth = moduleInfo.getAuth();
		if(auth!=null) {
			return auth.equalsIgnoreCase("true");
		}
		return false;
	}

}
