/*
 *TargetInfo.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.config;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;

import nga.util.ConfigurationException;
import nga.util.MethodOperator;

/**
 * target ^OB
 */
public class TargetInfo extends ConfigurationInfo {

	private static final long serialVersionUID = 1L;

	/**
	 * ̃^[Qbg̒ɒ`ꂽ TargetInfoListB
	 */
	private TargetInfoList children;

	/**
	 * TargetInfo 쐬B
	 * @param moduleInfo W[B
	 */
	public TargetInfo(ModuleInfo moduleInfo) {
		super(moduleInfo, 20);
	}

	/**
	 * \^Cv擾B
	 * @return \^CvB
	 */
	public String getType() {
		return get("type");
	}

	/**
	 * \^CvZbgB
	 * @param type \^CvB
	 */
	public void setType(String type) {
		put("type", type);
	}

	/**
	 * lIuWFNg̃vpeB擾B
	 * @return lIuWFNg̃vpeBB
	 */
	public String getName() {
		return get("name");
	}

	/**
	 * lIuWFNg̃vpeBZbgB
	 * @param value lIuWFNg̃vpeBB
	 */
	public void setName(String value) {
		put("name", value);
	}

	/**
	 * CN[h jsp / html 擾B
	 * @return CN[h jsp / htmlB
	 */
	public String getInclude() {
		return get("include");
	}

	/**
	 * CN[h jsp / html ZbgB
	 * @param include CN[h jsp / htmlB
	 */
	public void setInclude(String include) {
		put("include", include);
	}

	/**
	 * ݂ target ^O̓ɒ`ꂽ target ^ÕXg擾B
	 * @return target ^O񃊃XgB
	 */
	public TargetInfoList getChildren() {
		return children;
	}

	/**
	 * ݂ target ^O̓ɒ`ꂽ target ^ÕXgݒ肷B
	 * @param children ^[Qbg񃊃XgB
	 */
	public void setChildren(TargetInfoList children) {
		this.children = children;
	}
	
	/**
	 * id ̒l擾B
	 * @return id ̒lB
	 */
	public String getId() {
		return get("id", getName());
	}
	
	public void putAll(Map<? extends String, ? extends String> map) {
		super.putAll(map);
		if(map instanceof TargetInfo) {
			TargetInfo targetInfo = (TargetInfo)map;
			if(targetInfo.children!=null) {
				this.children = new TargetInfoList();
				for(TargetInfo child : targetInfo.children) {
					TargetInfo ti = new TargetInfo(getModuleInfo());
					ti.putAll(child);
					this.children.add(ti);
				}
			}
		}
	}

	/**
	 * w肳ꂽȎl擾B
	 * 擾l̂Pڂ\[X^OŁChbg܂܂ȂꍇiF @codejC
	 * resultObject Ŏw肳ꂽIuWFNg̃vpeB擾iFresultObject.getCode()jB
	 * @param name B
	 * @param resultObject sʃIuWFNgB
	 * @return lB
	 */
	public Object getAttribute(String name, Object resultObject) {
		String s = super.get((Object)name);
		if(s!=null && s.length() > 0 && s.charAt(0)==getModuleInfo().resourceTag 
				&& s.indexOf('.') <= 0 && resultObject!=null) {
			try {
				return MethodOperator.get(s.substring(1), resultObject);
			}
			catch (IllegalAccessException e) {
				throw new ConfigurationException(e);
			}
			catch (InvocationTargetException e) {
				throw new ConfigurationException(e.getCause());
			}
		}
		else {
			return super.get(name);
		}
	}
	
	/**
	 * w肳ꂽȎl𕶎ƂĎ擾B
	 * 擾l̂Pڂ\[X^OŁChbg܂܂ȂꍇiF @disabledjC
	 * resultObject Ŏw肳ꂽIuWFNg̃vpeB擾iFresultObject.isDisabled()jB
	 * @param name B
	 * @param resultObject sʃIuWFNgB
	 * @return lB
	 */
	public String getAttribute(String name, Object resultObject, String defaultAttribute) {
		Object o = getAttribute(name, resultObject);
		if(o==null) {
			return defaultAttribute;
		}
		
		return (String)o;
	}
	
	/**
	 * w肳ꂽȎl boolean ƂĎ擾B
	 * 擾l̂Pڂ\[X^OŁChbg܂܂ȂꍇiF @disabledjC
	 * resultObject Ŏw肳ꂽIuWFNg̃vpeB擾iFresultObject.isDisabled()jB
	 * @param name B
	 * @param resultObject sʃIuWFNgB
	 * @return lB
	 */
	public boolean getAttribute(String name, Object resultObject, boolean defaultAttribute) {
		Object o = getAttribute(name, resultObject);
		if(o==null) {
			return defaultAttribute;
		}

		if(o instanceof Boolean) {
			return ((Boolean)o).booleanValue();
		}
		
		return Boolean.parseBoolean(o.toString());
	}

	/**
	 * w肳ꂽȎl int ƂĎ擾B
	 * 擾l̂Pڂ\[X^OŁChbg܂܂ȂꍇiF @numberjC
	 * resultObject Ŏw肳ꂽIuWFNg̃vpeB擾iFresultObject.getNumber()jB
	 * @param name B
	 * @param resultObject sʃIuWFNgB
	 * @return lB
	 */
	public int getAttribute(String name, Object resultObject, int defaultAttribute) {
		Object o = getAttribute(name, resultObject);
		if(o==null) {
			return defaultAttribute;
		}

		if(o instanceof Number) {
			return ((Number)o).intValue();
		}
		
		try {
			return Integer.parseInt(o.toString());
		}
		catch(NumberFormatException e) {
			return defaultAttribute;
		}
	}

	/**
	 * w肳ꂽȎl long ƂĎ擾B
	 * 擾l̂Pڂ\[X^OŁChbg܂܂ȂꍇiF @numberjC
	 * resultObject Ŏw肳ꂽIuWFNg̃vpeB擾iFresultObject.getNumber()jB
	 * @param name B
	 * @param resultObject sʃIuWFNgB
	 * @return lB
	 */
	public long getAttribute(String name, Object resultObject, long defaultAttribute) {
		Object o = getAttribute(name, resultObject);
		if(o==null) {
			return defaultAttribute;
		}

		if(o instanceof Number) {
			return ((Number)o).longValue();
		}
		
		try {
			return Long.parseLong(o.toString());
		}
		catch(NumberFormatException e) {
			return defaultAttribute;
		}
	}
}
