/*
 *ServerRDBImpl.java
 *
 * Copyright (C) 2006 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.dsp;

import java.sql.Connection;
import javax.naming.InitialContext;
import javax.sql.DataSource;

import nga.servlet.ServiceInfo;
import nga.servlet.spi.CongaServletRDB;
import nga.util.SystemException;

/**
 * RDB T[oB
 */
public class DefaultCongaServletRDB extends CongaServletRDB {
	
	/**
	 * web.xml p^wFf[^\[X`B{@value}<br>
	 */
	public static final String DATASOURCE_NAME = "nga.servlet.dsp.ds";

	/**
	 * f[^\[XB
	 */
	private String dataSourceName;

	/**
	 * RlNVB
	 */
	private Connection connection;

	/**
	 * ServerRDBImpl 쐬B
	 */
	public DefaultCongaServletRDB() {
		super();
	}
	
	/**
	 * CX^X̏sȂB
	 * @param serviceInfo T[rXB
	 */
	public void init(ServiceInfo serviceInfo) {
		dataSourceName = 
			serviceInfo.getServlet().getServletConfig().getInitParameter(DATASOURCE_NAME);
		if(dataSourceName==null) {
			dataSourceName = "conga";
		}
	}

	/* (non-Javadoc)
	 * @see nga.sql.RDB#getConnection()
	 */
	@Override
	public Connection handleGetConnection() {
		if(connection==null) {
			try {
				InitialContext ctx = new InitialContext();
				DataSource ds = (DataSource)ctx.lookup("java:comp/env/jdbc/" + dataSourceName);
				connection = ds.getConnection();
			}
			catch(Exception e) {
				throw new SystemException(e);
			}
		}
		return connection;
	}

	/* (non-Javadoc)
	 * @see nga.sql.RDB#close()
	 */
	@Override
	public void handleClose() {
		if(connection!=null) {
			try {
				connection.close();
			}
			catch (Exception e) {
			}
			connection = null;
		}
		rollback();
	}

	/* (non-Javadoc)
	 * @see nga.sql.RDB#destroy()
	 */
	@Override
	public void handleDestroy() {
		handleClose();
	}

	/* (non-Javadoc)
	 * @see nga.sql.RDB#handleBegin()
	 */
	@Override
	public void handleBegin() {
		rollback();
	}

	/* (non-Javadoc)
	 * @see nga.sql.RDB#handleRollback()
	 */
	@Override
	public void handleRollback() {
		try {
			connection.rollback();
		}
		catch(Exception e) {
		}
	}

	/* (non-Javadoc)
	 * @see nga.sql.RDB#handleCommit()
	 */
	@Override
	public void handleCommit() {
		try {
			connection.commit();
		}
		catch(Exception e) {
			throw new SystemException(e);
		}
	}

}
