/*
 *DefaultLogWriter.java
 *
 * Copyright (C) 2006 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.dsp;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSession;

import nga.servlet.CongaServlet;
import nga.servlet.ServiceInfo;
import nga.servlet.spi.LogWriter;

/**
 * LogWriter ̃ftHgB
 */
public class DefaultLogWriter extends LogWriter {

	private static final int FATAL = 50000;
	private static final int ERROR = 40000;
	private static final int WARN = 30000;
	private static final int INFO = 20000;
	private static final int DEBUG = 10000;

	/**
	 * web.xml p^wFOxB{@value}<br>
	 * web.xml ̏p^w {@value} gp邱ƂɂC
	 * OxwłBftHg INFOB
	 */
	public static final String LOG_LEVEL = "nga.servlet.dsp.log-level";
	
	private int logLevel = INFO;

	/**
	 * DefaultLogWriter 쐬B
	 */
	public DefaultLogWriter() {
		super();
	}
	
	/**
	 * CX^X̏sȂB
	 * @param servlet CongaServletB
	 */
	protected void init(CongaServlet servlet) {
		logLevel = getLogLevel(servlet);
	}
	
	private int getLogLevel(CongaServlet servlet) {
		String level = servlet.getInitParameter(LOG_LEVEL);
		if(level==null || level.length()==0) {
			return INFO;
		}

		try {
			return Integer.parseInt(level);
		}
		catch(Exception e) {
		}

		if("WARN".equalsIgnoreCase(level)) {
			return WARN;
		}
		else if("ERROR".equalsIgnoreCase(level)) {
			return ERROR;
		}
		else if("FATAL".equalsIgnoreCase(level)) {
			return FATAL;
		}
		else if("DEBUG".equalsIgnoreCase(level)) {
			return DEBUG;
		}
		else {
			return INFO;
		}
		
	}

	private void log(ServiceInfo serviceInfo, String level, Object message, Throwable t) {
		log(serviceInfo.getServlet(), level, serviceInfo.getSession(), serviceInfo.getRequestId(), message, t);
	}

	/**
	 * Servlet.log \bhgăOo͂sȂB
	 */
	public static void log(HttpServlet servlet, String level, HttpSession session, String requestId, Object message, Throwable t) {
		String s = level + ":" + ((session!=null)?session.getId():"") + ":" +
		 			((requestId!=null)?requestId:"") + ":" + message;
		if(t!=null) {
			servlet.log(s, t);
		}
		else {
			servlet.log(s);
		}
	}

	/* (non-Javadoc)
	 * @see nga.servlet.spi.LogWriter#debug(nga.servlet.ServiceInfo, java.lang.Object)
	 */
	@Override
	public void debug(ServiceInfo serviceInfo, Object message) {
		log(serviceInfo, "DEBUG", message, null);
	}

	/* (non-Javadoc)
	 * @see nga.servlet.spi.LogWriter#debug(nga.servlet.ServiceInfo, java.lang.Object, java.lang.Throwable)
	 */
	@Override
	public void debug(ServiceInfo serviceInfo, Object message, Throwable t) {
		log(serviceInfo, "DEBUG", message, t);
	}

	/* (non-Javadoc)
	 * @see nga.servlet.spi.LogWriter#isDebugEnabled()
	 */
	@Override
	public boolean isDebugEnabled() {
		return logLevel >= DEBUG;
	}

	/* (non-Javadoc)
	 * @see nga.servlet.spi.LogWriter#info(nga.servlet.ServiceInfo, java.lang.Object)
	 */
	@Override
	public void info(ServiceInfo serviceInfo, Object message) {
		log(serviceInfo, "INFO ", message, null);
	}

	/* (non-Javadoc)
	 * @see nga.servlet.spi.LogWriter#info(nga.servlet.ServiceInfo, java.lang.Object, java.lang.Throwable)
	 */
	@Override
	public void info(ServiceInfo serviceInfo, Object message, Throwable t) {
		log(serviceInfo, "INFO ", message, t);
	}

	/* (non-Javadoc)
	 * @see nga.servlet.spi.LogWriter#isInfoEnabled()
	 */
	@Override
	public boolean isInfoEnabled() {
		return logLevel >= INFO;
	}

	/* (non-Javadoc)
	 * @see nga.servlet.spi.LogWriter#warn(nga.servlet.ServiceInfo, java.lang.Object)
	 */
	@Override
	public void warn(ServiceInfo serviceInfo, Object message) {
		log(serviceInfo, "WARN ", message, null);
	}

	/* (non-Javadoc)
	 * @see nga.servlet.spi.LogWriter#warn(nga.servlet.ServiceInfo, java.lang.Object, java.lang.Throwable)
	 */
	@Override
	public void warn(ServiceInfo serviceInfo, Object message, Throwable t) {
		log(serviceInfo, "WARN ", message, t);
	}

	/* (non-Javadoc)
	 * @see nga.servlet.spi.LogWriter#isWarnEnabled()
	 */
	@Override
	public boolean isWarnEnabled() {
		return logLevel >= WARN;
	}

	/* (non-Javadoc)
	 * @see nga.servlet.spi.LogWriter#error(nga.servlet.ServiceInfo, java.lang.Object)
	 */
	@Override
	public void error(ServiceInfo serviceInfo, Object message) {
		log(serviceInfo, "ERROR", message, null);
	}

	/* (non-Javadoc)
	 * @see nga.servlet.spi.LogWriter#error(nga.servlet.ServiceInfo, java.lang.Object, java.lang.Throwable)
	 */
	@Override
	public void error(ServiceInfo serviceInfo, Object message, Throwable t) {
		log(serviceInfo, "ERROR", message, t);
	}

	/* (non-Javadoc)
	 * @see nga.servlet.spi.LogWriter#isErrorEnabled()
	 */
	@Override
	public boolean isErrorEnabled() {
		return logLevel >= ERROR;
	}

	/* (non-Javadoc)
	 * @see nga.servlet.spi.LogWriter#fatal(nga.servlet.ServiceInfo, java.lang.Object)
	 */
	@Override
	public void fatal(ServiceInfo serviceInfo, Object message) {
		log(serviceInfo, "FATAL", message, null);
	}

	/* (non-Javadoc)
	 * @see nga.servlet.spi.LogWriter#fatal(nga.servlet.ServiceInfo, java.lang.Object, java.lang.Throwable)
	 */
	@Override
	public void fatal(ServiceInfo serviceInfo, Object message, Throwable t) {
		log(serviceInfo, "FATAL", message, t);
	}

	/* (non-Javadoc)
	 * @see nga.servlet.spi.LogWriter#isFatalEnabled()
	 */
	@Override
	public boolean isFatalEnabled() {
		return logLevel >= FATAL;
	}

}
