/*
 *DefaultUserAuth.java
 *
 * Copyright (C) 2006 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.dsp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

import nga.model.User;
import nga.servlet.CongaServlet;
import nga.servlet.ServiceInfo;
import nga.servlet.spi.UserAuth;
import nga.servlet.spi.UserStorage;

/**
 * UserAuth ̃ftHgB
 */
public class DefaultUserAuth extends UserAuth {
	
	private static final String ENCODING = "UTF-8";

	/**
	 * User ZVɊi[E擾L[B{@value}
	 */
	private static final String USER_KEY = "nga.servlet.dsp.user";

	/**
	 * DefaultUserAuth 쐬B
	 */
	public DefaultUserAuth() {
		super();
	}

	/* (non-Javadoc)
	 * @see nga.servlet.spi.UserAuth#handleLogin(nga.servlet.ServiceInfo, nga.model.User)
	 */
	@Override
	protected void handleLogin(ServiceInfo serviceInfo, User user) throws ServletException {
		user.setAuthorized(false);

		String userId = user.getUserId();
		if(userId==null || userId.length()==0) {
			return;
		}

		// pX[h擾B
		String password = user.getPassword();
		if(password==null) {
			password = "";
		}
		user.setPassword(null);

		// pX[hF؏B
		if(auth(serviceInfo.getServlet(), user.getUserId(), password)) {
			user.setAuthorized(true);

			// [UZVɕۑB
			UserWrapper userData = new UserWrapper(serviceInfo, user);
			serviceInfo.getSession().setAttribute(USER_KEY, userData);
		}
	}
	
	private boolean auth(CongaServlet servlet, String userId, String password) throws ServletException {
		File file = getPasswordFile(servlet, userId);
		if(!file.exists()) {
			return false;
		}


		BufferedInputStream is = null;
		try {
			byte[] d = digest(password);
			byte[] b = new byte[d.length];
			is = new BufferedInputStream(new FileInputStream(file), b.length);
			is.read(b);
			if(!equal(b, d)) {
				return false;
			}
		}
		catch (Exception e) {
			throw new ServletException(e);
		}
		finally {
			if(is!=null) {
				try {is.close();}catch (IOException e) {}
			}
		}
		return true;
	}

	private byte[] digest(String password) throws NoSuchAlgorithmException, UnsupportedEncodingException {
		MessageDigest md = getMessageDigest();
		md.update(password.getBytes(ENCODING));
		return md.digest();
	}

	private File getPasswordFile(CongaServlet servlet, String userId) {
		return DefaultUserStorage.getFile(servlet, userId+".password");
	}
	
	private MessageDigest getMessageDigest() throws NoSuchAlgorithmException {
		return MessageDigest.getInstance("SHA-512");
	}
	
	private boolean equal(byte[] a, byte[] b) {
		for(int i=0; i<a.length; i++) {
			if(a[i]!=b[i]) {
				return false;
			}
		}
		return true;
	}

	/* (non-Javadoc)
	 * @see nga.servlet.spi.UserAuth#handleLogout(nga.servlet.ServiceInfo)
	 */
	@Override
	protected void handleLogout(ServiceInfo serviceInfo) {
		User user = handleGetUser(serviceInfo);
		if(user!=null) {
			serviceInfo.getSession().invalidate();
		}
	}

	/* (non-Javadoc)
	 * @see nga.servlet.spi.UserAuth#handleGetUser(nga.servlet.ServiceInfo)
	 */
	@Override
	protected User handleGetUser(ServiceInfo serviceInfo) {
		HttpSession session = serviceInfo.getSession();
		UserWrapper userData = (UserWrapper)session.getAttribute(USER_KEY);
		if(userData==null) {
			return null;
		}
		return userData.getUser();
	}

	/* (non-Javadoc)
	 * @see nga.servlet.spi.UserAuth#handleSetPassword(nga.servlet.ServiceInfo, nga.model.User)
	 */
	@Override
	protected void handleSetPassword(ServiceInfo serviceInfo, User user) throws ServletException {
		File file = getPasswordFile(serviceInfo.getServlet(), user.getUserId());

		BufferedOutputStream os = null;
		try {
			byte[] d = digest(user.getPassword());
			os = new BufferedOutputStream(new FileOutputStream(file), d.length);
			os.write(d);
			os.flush();
		}
		catch (Exception e) {
			throw new ServletException(e);
		}
		finally {
			if(os!=null) {
				try {os.close();}catch (IOException e) {}
			}
		}
	}

	/**
	 * p҃f[^B
	 */
	private class UserWrapper implements HttpSessionBindingListener{

		private User user;
		private ServiceInfo serviceInfo;

		/**
		 * UserData 쐬B
		 * @throws ServletException 
		 */
		public UserWrapper(ServiceInfo serviceInfo, User user) throws ServletException {
			this.serviceInfo = serviceInfo;
			this.user = user;

			// [U[h
			UserStorage.load(serviceInfo, user);
		}

		/**
		 * pҏ擾B
		 * @return pҏB
		 */
		public User getUser() {
			return user;
		}

		/* (non-Javadoc)
		 * @see javax.servlet.http.HttpSessionBindingListener#valueBound(javax.servlet.http.HttpSessionBindingEvent)
		 */
		public void valueBound(HttpSessionBindingEvent arg0) {
		}

		/* (non-Javadoc)
		 * @see javax.servlet.http.HttpSessionBindingListener#valueUnbound(javax.servlet.http.HttpSessionBindingEvent)
		 */
		public void valueUnbound(HttpSessionBindingEvent event) {
			try {
				// [Uۑ
				UserStorage.save(serviceInfo, user);
				user.setAuthorized(false);
			}
			catch(ServletException e) {
				//
			}
		}

	}
}
