/*
 *DefaultUserStorage.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.dsp;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import nga.model.UpdatableByText;
import nga.model.User;
import nga.model.UserAttribute;
import nga.servlet.CongaServlet;
import nga.servlet.ServiceInfo;
import nga.servlet.WriterUtil;
import nga.servlet.spi.UserStorage;
import nga.util.FormatUtil;

/**
 * UserDataManager ̃ftHgB
 */
public class DefaultUserStorage extends UserStorage {

	/**
	 * web.xml p^wFp҃f[^t@Ci[pfBNgB{@value}<br>
	 * web.xml ̏p^w {@value} gp邱ƂɂC
	 * p҃f[^ۑt@Ci[fBNgwłB
	 * w肪Ȃꍇ́C"user" ƂȂB
	 */
	public static final String USER_DATA_DIR = "nga.servlet.dsp.user-data-dir";

	private DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
	
	private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

	/**
	 * UserDataManager 쐬B
	 */
	public DefaultUserStorage() {
		super();
	}
	
	/**
	 * pҏB
	 * @param serviceInfo ݎsĂ service ɊւB
	 * @param user pҏB
	 */
	protected void handleLoad(ServiceInfo serviceInfo, User user) throws ServletException {
		try {
			File file = getFile(serviceInfo.getServlet(), user.getUserId());
			if(!file.exists()) {
				return;
			}
			Document doc = builderFactory.newDocumentBuilder().parse(file);
			Node node = doc.getElementsByTagName("c").item(0);
			NodeList nlist = node.getChildNodes();
			UserAttribute userAttr = user.getAttribute();
			for(int i=0; i<nlist.getLength(); i++) {
				Node child = nlist.item(i);
				String name = child.getNodeName();
				if("e".equals(name)) {
					addEntry(userAttr, child);
				}
			}
		}
		catch(Exception e) {
			throw new ServletException(e);
		}
	}

	/**
	 * @param userData
	 * @param node
	 */
	private void addEntry(UserAttribute userAttr, Node node) {
		NamedNodeMap attr = node.getAttributes();
		String id = attr.getNamedItem("id").getNodeValue();
		String className = attr.getNamedItem("class").getNodeValue();
		String value = node.getFirstChild().getNodeValue();

		try {
			if(className.equals("java.lang.String")) {
				userAttr.put(id, value);
			}
			else if(className.equals("java.lang.Integer")) {
				userAttr.put(id, Integer.parseInt(value));
			}
			else if(className.equals("java.lang.Long")) {
				userAttr.put(id, Long.parseLong(value));
			}
			else if(className.equals("java.lang.Double")) {
				userAttr.put(id, Double.parseDouble(value));
			}
			else if(className.equals("java.lang.Float")) {
				userAttr.put(id, Float.parseFloat(value));
			}
			else if(className.equals("java.lang.Short")) {
				userAttr.put(id, Short.parseShort(value));
			}
			else if(className.equals("java.lang.Byte")) {
				userAttr.put(id, Byte.parseByte(value));
			}
			else if(className.equals("java.math.BigDecimal")) {
				userAttr.put(id, new BigDecimal(value));
			}
			else if(className.equals("java.lang.Character")) {
				userAttr.put(id, value.charAt(0));
			}
			else if(className.equals("java.util.Date")) {
				userAttr.put(id, dateFormat.parse(value));
			}
			else if(className.equals("java.sql.Date")) {
				userAttr.put(id, FormatUtil.toDate(dateFormat.parse(value)));
			}
			else if(className.equals("java.sql.Time")) {
				userAttr.put(id, FormatUtil.toTime(dateFormat.parse(value)));
			}
			else if(className.equals("java.sql.Timestamp")) {
				userAttr.put(id, FormatUtil.toTimestamp(dateFormat.parse(value)));
			}
			else {
				Class c = Class.forName(className);
				if(UpdatableByText.class.isAssignableFrom(c)) {
					@SuppressWarnings("unchecked") 
					UpdatableByText obj = (UpdatableByText)c.newInstance();
					obj.update(value);
					userAttr.put(id, obj);
				}
			}
		}
		catch(Exception e) {
			// 
		}
	}
	
	/**
	 * w肳ꂽpҏXg[WɕۑB
	 * @param serviceInfo ݎsĂ service ɊւB
	 * @param user pҏB
	 */
	protected void handleSave(ServiceInfo serviceInfo, User user) throws ServletException {
		try {
			save(serviceInfo.getServlet(), user);
		}
		catch (IOException e) {
			throw new ServletException(e);
		}
	}

	/**
	 * p҃f[^̕ۑsȂB
	 */
	private void save(CongaServlet servlet, User user) throws IOException {
		String userId = user.getUserId();
		UserAttribute userAttr = user.getAttribute();
		if(userId==null) {
			return;
		}

		File file = getFile(servlet, userId);
		BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file), "UTF-8"));
		try {
			writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
			writer.newLine();
			writer.write("<c>");
			writer.newLine();

			for(Map.Entry<String, Object> entry : userAttr.entrySet()) {
				String id = entry.getKey();
				Object value = entry.getValue();
				if(value==null) {
					continue;
				}
				Class c = value.getClass();
				String className = c.getName();
				writer.write("<e");
				WriterUtil.attr(writer, "id", id);
				WriterUtil.attr(writer, "class", className);
				writer.write(">");
				if(Date.class.isAssignableFrom(c)) {
					writer.write(dateFormat.format((Date)value));
				}
				else if(value instanceof String || value instanceof Number || 
						value instanceof UpdatableByText ||
						value instanceof Character || value instanceof Byte) {
					writer.write(WriterUtil.format(value));
				}
				writer.write("</e>");
				writer.newLine();
			}

			writer.write("</c>");
			writer.newLine();
		}
		finally {
			writer.close();
		}
	}

	
	/**
	 * p҃f[^i[pt@C̎擾sȂB
	 * @param servlet T[ubgB
	 * @param fileId t@CIDB
	 * @return p҃f[^i[pt@C
	 */
	public static File getFile(CongaServlet servlet, String fileId) {
		ServletConfig config = servlet.getServletConfig();
		String userDataDir = config.getInitParameter(USER_DATA_DIR);
		if(userDataDir==null || userDataDir.length()==0) {
			userDataDir = System.getProperty("user.home") + "/.conga/dsp/user-storage";
		}
		
		if(userDataDir.charAt(0)=='/' || userDataDir.charAt(0)=='\\') {
			userDataDir = userDataDir.substring(1);
		}

		File dir = new File(userDataDir);
		if(!dir.exists()) {
			dir.mkdirs();
		}
		return new File(userDataDir, fileId);
	}
}
