/*
 *UserController.java
 *
 * Copyright (C) 2006 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.dsp.controller;

import javax.servlet.ServletException;

import nga.model.User;
import nga.servlet.ServiceInfo;
import nga.servlet.spi.UserAuth;
import nga.servlet.spi.UserStorage;
import nga.util.UserLocale;

/**
 * OCsȂB
 */
public class UserController {
	
	private int errorCount = 3;
	private int error = errorCount;

	/**
	 * UserController 쐬B
	 */
	public UserController() {
		super();
	}
	
	/**
	 * F؏sȂB
	 * @param user [UB
	 * @param info T[rXB
	 * @throws ServletException 
	 */
	public void login(User user, ServiceInfo info) throws ServletException {
		// OCF؏sȂB
		UserAuth.login(info, user);
		if(!user.isAuthorized()) {
			user.setPassword(null);
			info.getErrorInfo().setMessage("dspm.auth_error");
			if(error-- <= 0) {
				info.getServlet().log("auth faild:" + user.getUserId());
				error = getErrorCount();
			}
		}
		else {
			// pҏ擾B
			UserStorage.load(info, user);
	
			// p҃P[ZbgB
			UserLocale.setLocale(user.getAttribute().getLocale());
		}
	}

	/**
	 * G[񐔂ZbgB
	 * @param errorCount G[񐔁B
	 */
	public void setErrorCount(int errorCount) {
		this.errorCount = errorCount;
		error = errorCount;
	}

	/**
	 * G[񐔂擾B
	 * @return G[񐔁B
	 */
	public int getErrorCount() {
		return errorCount;
	}
	
	/**
	 * OAEgsȂB
	 * @param info T[rXB
	 * @throws ServletException
	 */
	public void logout(ServiceInfo info) throws ServletException {
		UserAuth.logout(info);
	}
	
	/**
	 * [U̒ǉsȂB
	 */
	public void addUser(ServiceInfo serviceInfo, User user) throws ServletException {
		UserAuth.setPassword(serviceInfo, user);
		user.setPassword(null);
	}
	
	/**
	 * pX[hݒsȂB
	 */
	public void setPassword(ServiceInfo serviceInfo, User user) throws ServletException {
		if(user.isAuthorized()) {
			UserAuth.setPassword(serviceInfo, user);
			user.setPassword(null);
		}
		else {
			serviceInfo.getErrorInfo().setMessage("dspm.not_login");
		}
	}

}
