/*
 *DefaultParameterParser.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.dsp.parser;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

import nga.model.History;
import nga.model.UpdatableByText;
import nga.model.User;
import nga.model.UserAttribute;
import nga.servlet.NameUtil;
import nga.servlet.ServiceInfo;
import nga.servlet.config.ModuleInfo;
import nga.servlet.config.PropertyInfo;
import nga.servlet.config.PropertyInfoMap;
import nga.servlet.spi.ParameterParser;
import nga.servlet.spi.UserAuth;
import nga.util.ConfigurationException;
import nga.util.MethodOperator;

/**
 * {@link nga.servlet.spi.ParameterParser ParameterParser} ̃ftHgB
 */
public class DefaultParameterParser implements ParameterParser {

	private Map<Class, PropertyValueParser> valueParserMap = new HashMap<Class, PropertyValueParser>();

	private Map<String, Object> containers = new HashMap<String, Object>(400);
	private Object topContainer;
	private PropertyInfoMap propertyInfoMap;
	private Map<String, String> unusedPropertyInfo = new HashMap<String, String>();
	private ServiceInfo serviceInfo;	
	private PropertyInfo emptyPropertyInfo = new PropertyInfo(null);
	
	private ObjectOperator objectOperator = new ObjectOperator();
	
	private PropertyValue propertyValue;
	private ModuleInfo moduleInfo;
	
	private MultipartParameterParser multilpartParameterParser = new MultipartParameterParser();
	
	private boolean checkUndefinedProperty;

	/**
	 * DefaultParameterParser 쐬B
	 */
	public DefaultParameterParser() {
	}

	/**
	 * w肵NX̃vpeB邽߂ PropertyValueParser o^B
	 * @param type ΏۃNXB
	 * @param parser PropertyValueParserB
	 */
	public void registerValueParser(Class type, PropertyValueParser parser) {
		valueParserMap.put(type, parser);
		valueParserMap.put(parser.getClass(), parser);
	}

	/**
	 * @see nga.servlet.spi.ParameterParser#parse(ServiceInfo)
	 */
	@SuppressWarnings({"unchecked"})
	public boolean parse(ServiceInfo serviceInfo) throws IOException, ServletException {
		HttpServletRequest request = serviceInfo.getRequest();
		String contentType = request.getHeader("Content-Type");
		Map<String, String[]> parameterMap;
		if(contentType!=null && contentType.indexOf("multipart/form-data") > -1) {
			parameterMap = multilpartParameterParser.parseMultipart(serviceInfo);
		}
		else {
			parameterMap = serviceInfo.getRequest().getParameterMap();
		}
		return parse(serviceInfo, parameterMap);
	}
	
	/**
	 * w肳ꂽp^}bv̓eƂɃvpeB̐ݒsȂB
	 * @param serviceInfo ݎsĂ service ɊւB
	 * @param parameterMap NGXgp^̃}bvB
	 * @return ́E؂Ɋ true ԂB́E؎ɉ炩̖肪ꍇ false ԂB
	 */
	protected boolean parse(ServiceInfo serviceInfo, Map<String, String[]> parameterMap) throws ServletException {
		containers.clear();
		topContainer = serviceInfo.getPageObject();
		this.serviceInfo = serviceInfo;
		this.propertyInfoMap = serviceInfo.getPropertyInfoMap();
		this.propertyValue = new PropertyValue(serviceInfo);
		this.moduleInfo = propertyValue.getModuleInfo();
		this.checkUndefinedProperty = serviceInfo.getParameterInfo().get("check-undefined", false);
		initUnusedPropertyInfo();

		try {
			boolean success  = updateProperty(parameterMap);
			checkUnusedPropertyInfo();
			return success;
		}
		catch (IllegalAccessException e) {
			throw new ServletException(e);
		}
		catch (InvocationTargetException e) {
			throw new ServletException(e.getCause());
		}
	}
	
	/**
	 * NGXgp^ɏ] Value IuWFNg̃vpeBXVB
	 * @param parameterMap NGXgp^̃}bvB
	 * @return ́E؂Ɋ true ԂB́E؎ɉ炩̖肪ꍇ false ԂB
	 */
	protected boolean updateProperty(Map<String, String[]> parameterMap) throws IllegalAccessException, InvocationTargetException{
		boolean success = true;
		for(Iterator iter = parameterMap.keySet().iterator(); iter.hasNext(); ) {
			@SuppressWarnings("unchecked") 
			String key = (String)iter.next();
			if(key.charAt(0)=='_') { // '_' Ŏn܂镶͖B
				continue;
			}
			if(!set(key, parameterMap.get(key)[0])) {
				success = false;
			}
		}
		return success;
	}

	/**
	 * gp PropertyInfo i[̈B
	 */
	private void initUnusedPropertyInfo() {
		unusedPropertyInfo.clear();
		for(String propertyName : propertyInfoMap.keySet()) {
			unusedPropertyInfo.put(propertyName, propertyName);
		}
	}
	
	/**
	 * gp PropertyInfo (NGXgȂvpeBjȂǂ`FbNB
	 */
	private void checkUnusedPropertyInfo() {
		if(!unusedPropertyInfo.isEmpty()) {
			StringBuilder sb = new StringBuilder();
			for(String name : unusedPropertyInfo.keySet()) {
				sb.append(name).append(", ");
			}
			throw new ConfigurationException(message("dspm.no_parameter", sb.substring(0, sb.length()-2)));
		}
	}

	/**
	 * PropertyInfo 擾B
	 * @param fieldName tB[hB
	 * @return PropertyInfoB
	 */
	private PropertyInfo getPropertyInfo(String fieldName) {
		PropertyInfo pi = propertyInfoMap.get(fieldName);
		if(pi!=null) {
			unusedPropertyInfo.remove(fieldName);
		}
		return pi;
	}

	/**
	 * w肳ꂽÕtB[hɒlZbgB
	 * @param fullName lZbgtB[h̖OB
	 * @param value ZbglB
	 */
	@SuppressWarnings({"unchecked"})
	private boolean set(String fullName, String value) throws IllegalAccessException, InvocationTargetException {
		Object container = getContainer(NameUtil.getContainerName(fullName));
		if(container==null) {
			// ݒΏۃReiȂ
			throw new ConfigurationException(message("dspm.no_container", NameUtil.getContainerName(fullName)));
		}
		
		String fieldName = NameUtil.getFieldName(fullName);

		PropertyInfo pi = getPropertyInfo(fieldName);
		if(checkUndefinedProperty && pi==null) {
			throw new ConfigurationException(message("dspm.undefined_property", fieldName));
		}

		if(!objectOperator.init(container, fieldName, NameUtil.getIndex(fullName), pi!=null)) {
			return true;
		}

		if(pi==null) {
			emptyPropertyInfo.setName(fullName);
			emptyPropertyInfo.setModuleInfo(propertyValue.getModuleInfo());
			pi = emptyPropertyInfo;
		}
		Object forUpdate = objectOperator.getUpdatableObject();
		propertyValue.setup(fullName, value, pi, forUpdate);

		PropertyValueParser parser = getParameterValueParser(pi, objectOperator.type);
		if(parser.parse(propertyValue)) {
			objectOperator.set(propertyValue.getObject());
			updateHistory(propertyValue);
			return true;
		}
		else {
			return false;
		}
	}
	
	/**
	 * XVB
	 */
	private void updateHistory(PropertyValue propertyValue) {
		String historyId = propertyValue.getPropertyInfo().get("history-id");
		if(historyId!=null) {
			User user = UserAuth.getUser(serviceInfo);
			if(user==null) {
				return;
			}
			UserAttribute userAttr = user.getAttribute();
			History history = (History)userAttr.get(historyId);
			if(history==null) {
				history = new History();
				userAttr.put(historyId, history);
			}
			Object obj = propertyValue.getObject();
			try {
				if(obj!=null) {
					history.add((String)obj);
				}
			}
			catch(ClassCastException e) {
				history.add(obj.toString());
			}
		}
	}

	/**
	 * w肳ꂽ property ^OɓK PropertyValueParser 擾B
	 * @param pi property ^OB
	 * @return ΏۃvpeB̃NXB
	 */
	private PropertyValueParser getParameterValueParser(PropertyInfo pi, Class type) {
		if(pi!=null) {
			String parserName = PropertyValueParser.getParser(pi);
			if(parserName!=null) {
				return getPropertyParser(parserName);
			}
		}
		
		PropertyValueParser parser = valueParserMap.get(type);
		if(parser==null) {
			if(UpdatableByText.class.isAssignableFrom(type)) {
				parser = PropertyValueParserCollection.FOR_TEXTCONVERTIBLE;
			}
			else {
				throw new ConfigurationException(message("dspm.no_parser", type.getSimpleName()));
			}
		}
		return parser;
	}
	
	/**
	 * w肳ꂽO PropertyValueParser 擾B
	 * @param parserName PropertyParser B
	 * @return PropertyValueParserB
	 */
	@SuppressWarnings("unchecked")
	private PropertyValueParser getPropertyParser(String parserName)  {
		PropertyValueParser parser = valueParserMap.get(parserName);
		if(parser==null) {
			Class c;
			try {
				c = Class.forName(parserName);
				parser = (PropertyValueParser)c.newInstance();
				valueParserMap.put(c, parser);
			}
			catch (Exception e) {
				throw new ConfigurationException(message("invalid_class", parserName), e);
			}
		}
		return parser;
	}

	
	/**
	 * w肳ꂽÕvpeB̃Rei擾 
	 * @parma name vpeBB
	 */
	@SuppressWarnings("unchecked")
	private Object getContainer(String name) throws IllegalAccessException, InvocationTargetException {
		if(name==null) {
			return topContainer;
		}

		Object o = containers.get(name);
		if(o==null) {
			Object con = getContainer(NameUtil.getContainerName(name));

			if(con==null) {
				return null; // Ȃ
			}

			Method m = MethodOperator.getGetterMethod(con.getClass(), NameUtil.getFieldName(name));
			Class rt = m.getReturnType();
			o = MethodOperator.get(m, con);
			if(o==null) {
				return null; // Ȃ
			}

			if(rt.isArray()) {
				o = Array.get(o, NameUtil.getIndex(name));
			}
			else if(List.class.isAssignableFrom(rt)) {
				o = ((List)o).get(NameUtil.getIndex(name));
			}

			containers.put(name, o);
		}

		return o;
	}

	/**
	 * bZ[WԂB
	 * @param key bZ[WB
	 * @param args bZ[WB
	 * @return bZ[WB
	 */
	private String message(String key, Object... args) {
		return moduleInfo.getMessage(key, args);
	}


	/**
	 * IuWFNgҁB
	 */
	private class ObjectOperator{
		Class type;
		Object container;
		Method setterMethod;
		UpdatableByText object;
		Class arrayType;
		Object array;
		String fieldName;
		int index;
		
		/**
		 * ΏۃIuWFNg UpdatableByText ̏ꍇCԂB
		 * @return UpdatableByText ȃIuWFNgB
		 */
		public UpdatableByText getUpdatableObject() {
			return object;
		}
		
		/**
		 * w肳ꂽlZbgB
		 * @param value ZbglB
		 */
		@SuppressWarnings("unchecked")
		public void set(Object value) throws IllegalAccessException, InvocationTargetException {
			if(array!=null) {
				if(arrayType.isArray()) {
					Array.set(array, index, value);
				}
				else if(List.class.isAssignableFrom(arrayType)) {
					((List)array).set(index, value);
				}
				else {
					throw new ConfigurationException(message("dspm.invalid_list_type", fieldName, arrayType));
				}
			}
			else if(setterMethod!=null) {
				MethodOperator.set(setterMethod, container, value);				
			}
		}
		
		/**
		 * z/Xg^̏ꍇ̏ݒsȂB
		 * @param container ReiIuWFNgB
		 * @param propertyName vpeBB
		 */
		@SuppressWarnings("unchecked")
		private void initArrayType(Object container, String propertyName) throws IllegalAccessException, InvocationTargetException {
			Method getterMethod = MethodOperator.getGetterMethod(container.getClass(), propertyName);
			if(getterMethod==null) {
				throw new ConfigurationException(message("dspm.no_getter_method", container.getClass().getName(), propertyName));
			}
			arrayType = getterMethod.getReturnType();
			array = MethodOperator.get(getterMethod, container);
			
			if(array==null) {
				// null zɂ͐ݒłȂ
				throw new ConfigurationException(message("dspm.null_array", propertyName));
			}

			// z̏ꍇ
			if(arrayType.isArray()) {
				type = arrayType.getComponentType();
				if(UpdatableByText.class.isAssignableFrom(type)) {
					object = (UpdatableByText)Array.get(array, index);
				}				
			}
			// List ̏ꍇ
			else if(List.class.isAssignableFrom(arrayType)) {
				type = getClass((List)array);
				if(UpdatableByText.class.isAssignableFrom(type)) {
					object = (UpdatableByText)((List)array).get(index);
				}				
			}
			// ̑
			else {
				throw new ConfigurationException(message("dspm.invalid_list_type", propertyName, arrayType));
			}
		}

		/**
		 * ݒsȂB
		 * @param container ReiIuWFNgB
		 * @param propertyName vpeBB
		 * @param index CfbNXiz/Xg̏ꍇjB
		 * @param required ݒK{ǂB
		 * @return ݒsꍇ trueB
		 */
		public boolean init(Object container, String propertyName, int index, boolean required) 
				throws IllegalAccessException, InvocationTargetException {
			this.type = null;
			this.object = null;
			this.array = null;
			this.arrayType = null;
			this.setterMethod = null;
			this.container = container;
			this.fieldName = propertyName;
			this.index = index;
			
			// index  -1 łȂꍇ́Carray ƂĐݒ肷B
			if(index>-1) {
				initArrayType(container, propertyName);
				return true;
			}

			setterMethod = MethodOperator.getSetterMethod(container.getClass(), propertyName);

			if(setterMethod==null) {
				Method getterMethod = MethodOperator.getGetterMethod(container.getClass(), propertyName);
				if(getterMethod==null) {
					if(required) {
						throw new ConfigurationException(message("dspm.no_setter_method", container.getClass().getName(), propertyName));
					}
					else {
						return false;
					}
				}
				type = getterMethod.getReturnType();
				if(UpdatableByText.class.isAssignableFrom(type)) {
					object = (UpdatableByText)MethodOperator.get(getterMethod, container);
				}
				else {
					if(required) {
						throw new ConfigurationException(message("dspm.no_setter_method", container.getClass().getName(), propertyName));
					}
					else {
						return false;
					}
				}
			}
			else {
				Class[] pt = setterMethod.getParameterTypes();
				if(pt==null || pt.length==0) {
					if(required) {
						throw new ConfigurationException(message("dspm.invalid_setter_method", container.getClass().getName(), propertyName));
					}
					else {
						return false;
					}
				}
				type = pt[0];
				if(UpdatableByText.class.isAssignableFrom(type)) {
					Method getterMethod = MethodOperator.getGetterMethod(container.getClass(), propertyName);
					if(getterMethod!=null) {
						type = getterMethod.getReturnType();
						object = (UpdatableByText)MethodOperator.get(getterMethod, container);
					}
				}				
			}
			return true;
		}

		/**
		 * Xg̗vfNX擾B
		 * @param list 擾郊XgB
		 * @return Xg̗vfNXB
		 */
		@SuppressWarnings("unchecked")
		private Class getClass(List list) {
			for(int i=0; i<list.size(); i++) {
				Object o = list.get(i);
				if(o!=null) {
					return o.getClass();
				}
			}
			return null;
		}


	}


}
