/*
 *MultipartParameterParser.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.dsp.parser;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import nga.servlet.ServiceInfo;

/**
 * multipart/form-data p ParameterParserB
 */
class MultipartParameterParser {
	
	/**
	 * ǂݍ݃obt@TCYB
	 */
	private static final int BUFSIZE = 4096;
	
	private static final byte CR = (byte)'\r';
	private static final byte LF = (byte)'\n';
	private static final byte[] CRLF = {CR, LF};

	/**
	 * web.xml p^wFAbv[ht@Ci[fBNgB{@value}<br>
	 * web.xml ̏p^w {@value} gp邱ƂɂC
	 * Abv[ht@Ci[fBNg̎w肪łB
	 */
	public static final String UPLOAD_DIR = "nga.servlet.dsp.upload-dir";

	private static final String BOUNDARY_KEY = "boundary=";
	private static final String CONTENT_DISPOSITION_KEY = "Content-Disposition";
    private static final String FILE_DATA_KEY = "; filename=";
    private static final String NAME_KEY = "; name=";
    private boolean eof;
    private byte[] boundary;
    private byte[] buff;
    private int buffPosition;
    private int buffLength;

    /**
	 * MultipartParameterParser 쐬B
	 */
	public MultipartParameterParser() {
		super();
	}

	/**
	 * Multipart ǂݍށB
	 * @param serviceInfo
	 */
	protected Map<String, String[]> parseMultipart(ServiceInfo serviceInfo) throws IOException {
		HttpServletRequest request = serviceInfo.getRequest();
		String contentType = request.getHeader("Content-Type");
		String encoding = request.getCharacterEncoding();
		Map<String, String[]> parameterMap = new HashMap<String, String[]>();

		// ؂蕶擾B
		int pos = contentType.indexOf(BOUNDARY_KEY) + BOUNDARY_KEY.length();
		boundary = ("--"+contentType.substring(pos)).getBytes("8859_1");
		InputStream is = request.getInputStream();

		buff = new byte[BUFSIZE];
		buffPosition = BUFSIZE;
		buffLength = BUFSIZE;
		eof = false;
		readLine(is); // ŏ̍s̓oE_Ȃ̂œǂݎ̂ĂB
		do {
			readPart(serviceInfo, is, encoding, parameterMap);
		} while(!eof);
		
		return parameterMap;
	}

	/**
	 * 
	 * @param serviceInfo
	 * @param is
	 * @param encoding
	 * @param parameterMap
	 * @throws IOException
	 */
	private void readPart(ServiceInfo serviceInfo, InputStream is, String encoding, Map<String, String[]> parameterMap) throws IOException {
		String line = readLine(is, encoding);
		if(line.startsWith(CONTENT_DISPOSITION_KEY)) {
			int nameIndex = line.indexOf(NAME_KEY);
			if(nameIndex < 0) {
				return;
			}
			String name = getName(line, nameIndex);
			if(line.indexOf(FILE_DATA_KEY) > 0) { // t@C̏ꍇ
				File file = getFile(serviceInfo);
				parameterMap.put(name, new String[]{file.getAbsolutePath()});
				writeFile(is, file);
			}
			else { // p^̏ꍇ
				readLine(is); // sǂݎ̂Ă
				StringBuilder sb = new StringBuilder();
				do {
					line = readLine(is, encoding);
					if(line!=null) {
						sb.append(line).append("\r\n");
					}
					else {
						break;
					}
				} while(!eof);

				if(sb.length()>2) {
					line = sb.substring(0, sb.length()-2);
				}
				parameterMap.put(name, new String[]{line});
			}
		}
	}
	
	private String getName(String line, int nameIndex) {
		int startIndex = line.indexOf('\"', nameIndex) + 1;
		if(startIndex <= 0) {
			return null;
		}
		int endIndex = line.indexOf('\"', startIndex);
		return line.substring(startIndex, endIndex);
	}

	/**
	 * @param is
	 */
	private void writeFile(InputStream is, File file) throws IOException {
		readLine(is); // Content-Type sǂݎ̂Ă
		readLine(is); // sǂݎ̂Ă
		OutputStream os = new BufferedOutputStream(new FileOutputStream(file));
		try {
			writeFile(is, os);
		}
		finally {
			os.close();
		}
	}

	/**
	 * 
	 * @param is
	 * @param os
	 * @throws IOException
	 */
	private void writeFile(InputStream is, OutputStream os) throws IOException {

		boolean writeCRLF = false;

		do {
			byte[] line = readLine(is);
			if(isBoundary(line)) {
				break;
			}
			else {
				if(writeCRLF) {
					os.write(CRLF);					
				}
				os.write(line);
				writeCRLF = true;
			}
		} while(!eof);
	}

	/**
	 * @param is
	 * @param encoding
	 * @return
	 */
	private String readLine(InputStream is, String encoding) throws IOException {
		byte[] bytes = readLine(is);
		if(isBoundary(bytes)) {
			return null;
		}
		else {
			return new String(bytes, encoding);
		}
	}

	/**
	 * @param line
	 * @param boundary
	 * @return
	 */
	private boolean isBoundary(byte[] line) {
		if(line.length < boundary.length) {
			return false;
		}
		for(int i=0; i<boundary.length; i++) {
			if(line[i]!=boundary[i]) {
				return false;
			}
		}
		return true;
	}

	private byte[] readLine(InputStream is) throws IOException {
	    byte[] temp = new byte[0];
	    boolean checkLF = false;
		do {
			if(buffPosition==buffLength) {
				buffLength = is.read(buff);
				buffPosition = 0;
				if(buffLength==0) {
					Thread.yield();
					continue;
				}
				else if(buffLength < 0) { // EOF
					eof = true;
					return temp;
				}

				if(checkLF && buff[0]==LF) {
					byte[] newBytes = new byte[temp.length-1];
					System.arraycopy(temp, 0, newBytes, 0, newBytes.length);
					buffPosition = 1;
					return newBytes;
				}
			}

			checkLF = false;
			for(int i=buffPosition; i<buffLength; i++) {
				if(buff[i]==CR) {
					if(i+1==buffLength) {
						checkLF = true;
						break;
					}
					else if(buff[i+1]==LF) {
						byte[] newBytes = concat(temp, buff, i-buffPosition);
						buffPosition = i+2;
						return newBytes;
					}
				}
			}

			temp = concat(temp, buff, buffLength-buffPosition);
			buffPosition = buffLength;
		} while(true);
	}
	
	private byte[] concat(byte[] oldBytes, byte[] newBytes, int length) {
		int oldBytesLength = 0;
		if(oldBytes!=null) {
			oldBytesLength = oldBytes.length;
		}

		byte[] b = new byte[oldBytesLength + length];
		if(oldBytesLength > 0) {
			System.arraycopy(oldBytes, 0, b, 0, oldBytesLength);
		}
		if(length > 0) {
			System.arraycopy(newBytes, buffPosition, b, oldBytesLength, length);
		}
		return b;
	}

	/**
	 * o͐t@C擾B
	 * @param serviceInfo
	 * @return o͐t@CB
	 */
	protected File getFile(ServiceInfo serviceInfo) throws IOException {
		File dir = getDirectory(serviceInfo);
		return File.createTempFile(getTempFilePrefix(), null, dir);
	}
	
	/**
	 * o͐ꎞt@C쐬 prefix 擾B
	 * @return
	 */
	protected String getTempFilePrefix() {
		return "nga-servlet-dsp-upload";
	}

	/**
	 * Abv[ht@C쐬fBNg擾B
	 * web.xml  #UPLOAD_DIR w肪΂̃fBNgԂBȂ nullB
	 * @param serviceInfo ServiceInfoB
	 * @return fBNgB
	 */
	protected File getDirectory(ServiceInfo serviceInfo) {
		String dir = serviceInfo.getServlet().getInitParameter(UPLOAD_DIR);
		if(dir!=null) {
			File f = new File(dir);
			if(!f.exists()) {
				f.mkdirs();
			}
			return f;
		}
		else {
			return null;
		}
	}

}
