/*
 *AbstractResultWriter.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.dsp.writer;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import nga.servlet.ServiceInfo;
import nga.servlet.config.ResultInfo;
import nga.servlet.spi.ResultWriter;

/**
 * ResultWriter ̂߂̔ėpNXB
 */
public abstract class AbstractResultWriter implements ResultWriter {

	/**
	 * y[WB
	 */
	private String page;

	/**
	 * G[y[WB
	 */
	private String errorPage;

	/**
	 * AbstractResultWriter 쐬B
	 */
	public AbstractResultWriter() {
		super();
	}

	/**
	 * @see ResultWriter#write(ServiceInfo)
	 */
	public void write(ServiceInfo serviceInfo) throws IOException, ServletException {
		HttpServletRequest request = serviceInfo.getRequest();
		HttpServletResponse response = serviceInfo.getResponse();
		ResultInfo resultInfo = serviceInfo.getResultInfo();

		// G[ꍇ̓G[y[W forward B
		if(serviceInfo.getErrorInfo().hasError()) {
			String errorPage = getErrorPage(resultInfo);
			if(errorPage!=null) {
				request.getRequestDispatcher(errorPage).forward(request, response);
				return;
			}
		}
		
		String page = getPage(resultInfo);
		if(page!=null) {
			request.getRequestDispatcher(page).forward(request, response);
			return;
		}
		
		handleWrite(serviceInfo);
	}

	/**
	 * {@link ServiceInfo#getResultObject()} Ŏ擾ʃIuWFNg̏o͂sȂB
	 * @param serviceInfo ݎsĂ service ɊւB
	 */
	protected abstract void handleWrite(ServiceInfo serviceInfo) 
			throws IOException, ServletException;

	/**
	 * Jڐy[W擾B
	 * @return Jڐy[WB
	 */
	protected String getPage(ResultInfo resultInfo) {
		return resultInfo.get("page", this.page);
	}

	/**
	 * Jڐy[WZbgB
	 * @param page Jڐy[WB
	 */
	protected void setPage(String page) {
		this.page = page;
	}

	/**
	 * G[̑Jڐy[W擾B
	 * @return G[̑Jڐy[WB
	 */
	protected String getErrorPage(ResultInfo resultInfo) {
		return resultInfo.get("error-page", this.errorPage);
	}

	/**
	 * G[̑Jڐy[WZbgB
	 * @param errorPage G[̑Jڐy[WB
	 */
	protected void setErrorPage(String errorPage) {
		this.errorPage = errorPage;
	}
}
