/*
 *IAssistantWriter.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.dsp.writer;

import java.io.IOException;
import java.util.Iterator;

import javax.servlet.ServletException;

import nga.model.User;
import nga.model.UserAttribute;
import nga.servlet.WriterUtil;
import nga.servlet.config.TargetInfo;
import nga.servlet.config.TargetInfoList;
import nga.servlet.spi.UserAuth;

/**
 * ͕⏕pIXgpC^B
 */
public class IAssistantWriter extends TargetValueWriter {

	/**
	 * IAssistantWriter 쐬B
	 */
	public IAssistantWriter() {
		super();
	}

	/* (non-Javadoc)
	 * @see nga.servlet.dsp.writer.TargetValueWriter#write()
	 */
	@Override
	public void write() throws IOException, ServletException {
		TargetInfo ti = targetValue.getTargetInfo();
		Object resultObject = targetValue.getResultObject();
		write(ti, resultObject);
	}
	
	/**
	 * o͂B
	 * @param ti target ^OB
	 * @param resultObject o͑ΏۃIuWFNgB
	 */
	protected void write(TargetInfo ti, Object resultObject) throws ServletException {
		String className = ti.getAttribute("class", resultObject, "iassistant");
		Iterable list;
		String historyId = ti.get("history-id");
		if(historyId!=null) {
			User user = UserAuth.getUser(targetValue.getServiceInfo());
			if(user!=null) {
				UserAttribute userAttr = user.getAttribute();
				list = (Iterable)userAttr.get(historyId);
			}
			else {
				list = null;
			}
		}
		else {
			list= (Iterable)targetValue.getValue();
		}

		print("<table").attr("id", ti.getId()).attr("class", className);
		if(ti.getAttribute("visible", resultObject, true) && list!=null) {
			attr("style", "display:block");
		}
		else {
			attr("style", "display:none");
		}
		print(">");

		if(list!=null) {
			writeRows(list, ti.getChildren(), ti.get("input-id", ""));
		}

		print("</table>");
	}

	/**
	 * sf[^̏o͂sȂB
	 * @param list sf[^B
	 * @param colInfoList `̃XgB
	 * @param inputId ͍ڂ idB
	 */
	@SuppressWarnings("unchecked")
	private void writeRows(Iterable list, TargetInfoList colInfoList, String inputId) throws ServletException {
		for(Iterator iter = list.iterator(); iter.hasNext();) {
			print("<tr");
			attr("onmouseover", "IAssistant.focus(this)");
			attr("onmouseout", "IAssistant.blur(this)");
			attr("onmousedown", "IAssistant.selected(this,\'"+inputId+"\')");
			print(">");

			@SuppressWarnings({"unchecked"})
			Object rowData = iter.next();
			if(colInfoList!=null) {
				for(TargetInfo colInfo : colInfoList) {
					String propertyName = colInfo.getName();

					print("<td").attr("class", colInfo, rowData).print(">");

					if(propertyName!=null) {
						String propertyValue = WriterUtil.property(propertyName, rowData, getFormat(colInfo));
						print(propertyValue);
					}

					print("</td>");
				}				
			}
			else {
				print("<td>").print(rowData).print("</td>");
			}
			print("</tr>");
		}
	}
	
}
