package nga.servlet.dsp.writer;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;

import nga.servlet.WriterUtil;
import nga.servlet.config.TargetInfo;
import nga.servlet.ErrorInfo;

/**
 * lIuWFNgɊi[ĂvpeBlo͂B
 */
public abstract class TargetValueWriter {
	
	/**
	 * o͑ΏۏB
	 */
	protected TargetValue targetValue;
	
	/**
	 * o͐B
	 */
	protected PrintWriter writer;
	
	/**
	 * ̃C^̏o͑ΏۂRei^OǂԂB
	 */
	public boolean isContainer() {
		return false;
	}

	/**
	 * ݏΏۂƂȂĂvpeBlCDATAZNVƂ
	 * o͂Kv邩ǂԂB
	 * @return CDATAZNVƂďo͂ꍇ trueB̎͏ true ԂB
	 */
	public boolean isCdataSection() {
		return true;
	}
	
	/**
	 * o͑Ώۂ TargetValue ZbgB
	 * @param targetValue
	 */
	public void setTargetValue(TargetValue targetValue) {
		this.targetValue = targetValue;
		this.writer = targetValue.getWriter();
	}

	/**
	 * ݏΏۂƂȂĂvpeBlɊւ鑮o͂sȂB
	 * ̎ł͉sȂȂBKvɉāCTuNXɂĎB
	 */
	@SuppressWarnings({"unusedThrown"})
	public void writeAttribute() throws IOException, ServletException {
	}
	
	/**
	 * lIuWFNgɊi[ĂvpeBlo͂B
	 */
	public abstract void write() throws IOException, ServletException;

	/**
	 * ΏۍڂG[ƂȂĂꍇCG[l擾B
	 * @return G[ƂȂlB
	 */
	protected Object getErrorValue() {
		ErrorInfo.Item errorItem = getErrorItem();
		if(errorItem!=null) {
			return errorItem.getValue();
		}
		else {
			return null;
		}
	}
	
	/**
	 * ݑΏۂG[ƂȂĂ邩ǂ𒲂ׂB
	 * @return G[ƂȂĂꍇ trueB
	 */
	protected ErrorInfo.Item getErrorItem() {
		return targetValue.getErrorInfo().get(targetValue.getTargetInfo().getName());
	}
	
	/**
	 * errorInfo ̒ɑΏۍڂ܂܂ĂꍇCG[ƂȂlo͂B
	 * @return G[o͂sȂꍇ true ԂB
	 */
	protected boolean printErrorValue() {
		Object o = getErrorValue();
		if(o!=null) {
			writer.print(WriterUtil.format(o));
			return true;
		}
		else {
			return false;
		}
	}

	/**
	 * ȈՃ\bhFwriter.println() ̃V[gJbgB
	 * @return ̃CX^XB
	 */
	protected TargetValueWriter println() {
		writer.println();
		return this;
	}

	/**
	 * ȈՃ\bhFwriter.println(s) ̃V[gJbgB
	 * @param s o͑ΏەB
	 * @return ̃CX^XB
	 */
	protected TargetValueWriter println(String s) {
		writer.println(s);
		return this;
	}

	/**
	 * ȈՃ\bhFwriter.print(s) ̃V[gJbgB
	 * @param s o͑ΏەB
	 * @return ̃CX^XB
	 */
	protected TargetValueWriter print(String s) {
		writer.print(s);
		return this;
	}
	
	/**
	 * ȈՃ\bhFwriter.println(o) ̃V[gJbgB
	 * @param o o͑ΏۃIuWFNgB
	 * @return ̃CX^XB
	 */
	protected TargetValueWriter println(Object o) {
		writer.println(o);
		return this;
	}

	/**
	 * ȈՃ\bhFwriter.print(o) ̃V[gJbgB
	 * @param o o͑ΏۃIuWFNgB
	 * @return ̃CX^XB
	 */
	protected TargetValueWriter print(Object o) {
		writer.print(o);
		return this;
	}
	
	/**
	 * ȈՃ\bhFwriter.print(WriterUtil.format(o)) ̃V[gJbgB
	 * @param o o͑ΏۃIuWFNgB
	 * @return ̃CX^XB
	 */
	protected TargetValueWriter format(Object o) {
		writer.print(WriterUtil.format(o));
		return this;
	}
	
	/**
	 * ȈՃ\bhFwriter.print(WriterUtil.format(o, fmt)) ̃V[gJbgB
	 * @param o o͑ΏۃIuWFNgB
	 * @param fmt o͏B
	 * @return ̃CX^XB
	 */
	protected TargetValueWriter format(Object o, String fmt) {
		writer.print(WriterUtil.format(o, fmt));
		return this;
	}
	
	/**
	 * ȈՃ\bhFWriterUtil.attr(writer, name, value) ̃V[gJbgB
	 * @param name B
	 * @param value lB
	 * @return ̃CX^XB
	 */
	protected TargetValueWriter attr(String name, Object value) {
		WriterUtil.attr(writer, name, value);
		return this;
	}

	/**
	 * ȈՃ\bhFWriterUtil.attr(writer, name, value, fmt) ̃V[gJbgB
	 * @param name B
	 * @param value lB
	 * @param fmt B
	 * @return ̃CX^XB
	 */
	protected TargetValueWriter attr(String name, Object value, String fmt) {
		WriterUtil.attr(writer, name, value, fmt);
		return this;
	}

	/**
	 * ȈՃ\bhFWriterUtil.attr(writer, name, targetInfo, valueObject) ̃V[gJbgB
	 * @param name B
	 * @param targetInfo target ^OB
	 * @param valueObject lIuWFNgB
	 * @return ̃CX^XB
	 */
	protected TargetValueWriter attr(String name, TargetInfo targetInfo, Object valueObject) {
		WriterUtil.attr(writer, name, targetInfo, valueObject);
		return this;
	}

	/**
	 * ȈՃ\bhFWriterUtil.attr(writer, name, targetInfo, valueObject, fmt) ̃V[gJbgB
	 * @param name B
	 * @param targetInfo target ^OB
	 * @param valueObject lIuWFNgB
	 * @param fmt B
	 * @return ̃CX^XB
	 */
	protected TargetValueWriter attr(String name, TargetInfo targetInfo, Object valueObject, String fmt) {
		WriterUtil.attr(writer, name, targetInfo, valueObject, fmt);
		return this;
	}
	
	/**
	 * NGXgp̑o͂sȂB
	 * @param requestConfigAttr request-config.xml t@CɋLqB
	 * @param htmlAttr html ^OƂďo͂ۂ̑B
	 * @param targetInfo target ^OB 
	 * @param resultObject ʃIuWFNgB
	 * @return ̃CX^XB
	 */
	protected TargetValueWriter printRequest(String requestConfigAttr, String htmlAttr, 
				TargetInfo targetInfo, Object resultObject) {
		Object request = targetInfo.getAttribute(requestConfigAttr, resultObject);
		if(request!=null) {
			attr(htmlAttr, "new CongaRequest().send(\'" + request + "\');");
		}
		return this;
	}

	
	/**
	 * w肳ꂽ target ^O "label" (x) Ŏw肳ꂽl擾B
	 * @param targetInfo target ^OB
	 * @return "label" Ŏw肳ꂽlB
	 */
	public static String getLabel(TargetInfo targetInfo) {
		return targetInfo.get("label");
	}

	/**
	 * w肳ꂽ target ^O "label" (x) Ŏw肳ꂽl擾B
	 * l {@link TargetInfo#getAttribute(String, Object) targetInfo.getAttribute("label" ,valueObject)}
	 * ̌ʂgpB
	 * @param targetInfo target ^OB
	 * @return "label" Ŏw肳ꂽlB
	 */
	public static String getLabel(TargetInfo targetInfo, Object valueObject) {
		return (String)targetInfo.getAttribute("label", valueObject);
	}

	/**
	 * w肳ꂽ target ^O "format" () Ŏw肳ꂽl擾B
	 * @param targetInfo target ^OB
	 * @param defaultFormat ftHgtH[}bgB
	 * @return "format" Ŏw肳ꂽlBw肳ĂȂꍇ defaultFormatB
	 */
	public static String getFormat(TargetInfo targetInfo, String defaultFormat) {
		return targetInfo.get("format", defaultFormat);
	}
	
	/**
	 * w肳ꂽ target ^O "format" () Ŏw肳ꂽl擾B
	 * @param targetInfo target ^OB
	 * @return "format" Ŏw肳ꂽlBw肳ĂȂꍇ nullB
	 */
	public static String getFormat(TargetInfo targetInfo) {
		return getFormat(targetInfo, null);
	}
	
	/**
	 * w肳ꂽ target ^O "scale" () Ŏw肳ꂽl擾B
	 * @param targetInfo target ^OB
	 * @return "scale" Ŏw肳ꂽlB
	 */
	public static int getScale(TargetInfo targetInfo) {
		return targetInfo.get("scale", -1);
	}
	
	/**
	 * w肳ꂽ target ^O "class" Ŏw肳ꂽl擾B
	 * @param targetInfo target ^OB
	 * @return "class" Ŏw肳ꂽlB
	 */
	public static String getClass(TargetInfo targetInfo) {
		return targetInfo.get("class", null);
	}
}