/*
 *TextInputWriter.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.dsp.writer;

import java.io.IOException;

import javax.servlet.ServletException;

import nga.servlet.ErrorInfo;
import nga.servlet.config.TargetInfo;

/**
 * input type="text" ^OpC^B
 */
public class TextInputWriter extends TargetValueWriter {

	/**
	 * TextInputWriter 쐬B
	 */
	public TextInputWriter() {
		super();
	}

	/* (non-Javadoc)
	 * @see nga.servlet.dsp.writer.TargetValueWriter#write()
	 */
	@Override
	public void write() throws IOException, ServletException {
		TargetInfo ti = targetValue.getTargetInfo();
		Object resultObject = targetValue.getResultObject();
		StringBuilder style = new StringBuilder();
		StringBuilder onfocus = new StringBuilder();
		StringBuilder onblur = new StringBuilder();
		StringBuilder onkeyup = new StringBuilder();

		String inputType = ti.get("input-type", "text");
		String type;
		if(inputType.equalsIgnoreCase("password")) {
			type = "password";
			inputType = "text";
		}
		else {
			type = "text";
		}
		
		print("<input").attr("type", type).attr("id", ti.getId());
		attr("class", ti, resultObject);
		

		if("number".equals(inputType)) {
			onfocus.append("ITextInput.delComma(this);");

			int length = ti.get("length", Integer.MAX_VALUE-2);
			boolean positiveOnly = ti.get("positive-only", false);
			int scale = ti.get("scale", 0);
			attr("onkeypress", (scale > 0)? "ITextInput.chkDec(event)" : "ITextInput.chkInt(event)");
			int ilen = length;
			if(scale > 0) {
				ilen = length - scale;
				length++; // dot
			}
			if(!positiveOnly) {
				length++; // -
			}
			attr("maxlength", length);
			attr("onchange", "ITextInput.chkNum(event,this,"+ilen+","+scale+","+positiveOnly+")");
		}
		else {
			onfocus.append("this.select();");
			int length = ti.get("length", 0);
			if(length > 0) {
				attr("maxlength", length);
			}
			if("alnum".equals(inputType)) {
				attr("onchange", "ITextInput.chkAlnum(event,this)");
			}
		}
		
		attr("name", ti.getName());
		
		String requestOnEnter = ti.get("request-onenter", null);
		if(requestOnEnter!=null) {
			onkeyup.append("ITextInput.requestOnEnter(event, '").append(requestOnEnter).append("');");
		}

		// G[ or wv\
		String helpMessage = null;

		ErrorInfo.Item errorItem = getErrorItem();
		if(errorItem!=null) {
			style.append("background-color:pink;");
			helpMessage = errorItem.getMessage();
			attr("value", errorItem.getValue());
		}
		else {
			helpMessage = ti.get("help-message", null);
			attr("value", targetValue.getValue(),getFormat(ti));
		}

		if(helpMessage!=null) {
			onfocus.append("IHelpMessage.show(this, '").append(helpMessage).append("');");
			onblur.append("IHelpMessage.hide();");
			attr("onmouseover", "IHelpMessage.show(this, '" + helpMessage + "');");
			attr("onmouseout", "IHelpMessage.hide();");
		}

		if(!ti.getAttribute("visible", resultObject, true)) {
			style.append("display:none;");
		}
		if(ti.getAttribute("disabled", resultObject, false)) {
			attr("disabled", "disabled");
		}
		if(ti.getAttribute("read-only", resultObject, false)) {
			attr("readonly", "readonly");
		}
		
		// assistant n
		String assistantId = ti.get("assistant-id");
		String requestOnassist = ti.get("request-onassist");
		if(assistantId!=null) {
			onblur.append("IAssistant.hide(this);");
			onkeyup.append("IAssistant.show('").append(assistantId).append("',this");
			if(requestOnassist!=null) {
				onkeyup.append(", '").append(requestOnassist).append("'");
			}
			onkeyup.append(");");

			if(ti.get("show-assistant-onfocus", false)) {
				if(requestOnassist!=null) {
					onfocus.append("IAssistant.show('").append(assistantId).append("',this, '").append(requestOnassist).append( "\');");
				}
				else {
					onfocus.append("IAssistant.show('").append(assistantId).append("',this);");
				}
			}
		}

		// J_
		if(ti.get("show-calendar-onfocus", false)) {
			onfocus.append("ICalendar.show(event);");
		}

		attr("onfocus", new String(onfocus));
		if(onblur.length() > 0) {
			attr("onblur", new String(onblur));			
		}
		if(onkeyup.length() > 0) {
			attr("onkeyup", new String(onkeyup));
		}
		attr("style", new String(style));
		print("/>");
	}

}
