/*
 *LogWriter.java
 *
 * Copyright (C) 2006 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */
package nga.servlet.spi;

import nga.servlet.CongaServlet;
import nga.servlet.ServiceInfo;

/**
 * OC^B
 */
public abstract class LogWriter {
	
	private boolean initalized;

	/**
	 * LogWriter 쐬B
	 */
	protected LogWriter() {
	}
	
	/**
	 * LogWriter ̎CX^X擾B
	 * @param serviceInfo ݎsĂ service ɊւB
	 * @return LogWriter ̎CX^XB
	 */
	public static LogWriter getInstance(ServiceInfo serviceInfo) {
		LogWriter logWriter = serviceInfo.getSingleInstance(LogWriter.class);
		if(!logWriter.initalized) {
			logWriter.init(serviceInfo.getServlet());
			logWriter.initalized = true;
		}
		return logWriter;
	}

	/**
	 * CX^X̏sȂB
	 * @param servlet CongaServletB
	 */
	protected abstract void init(CongaServlet servlet);
	
	/**
	 * fobOx̃Oo͂sȂB
	 * @param serviceInfo ݎsĂ service ɊւB
	 * @param message o̓bZ[WB
	 */
	public abstract void debug(ServiceInfo serviceInfo, Object message);

	/**
	 * fobOx̃Oo͂sȂB
	 * @param serviceInfo ݎsĂ service ɊւB
	 * @param message o̓bZ[WB
	 * @param t OB
	 */
	public abstract void debug(ServiceInfo serviceInfo, Object message, Throwable t);

	/**
	 * fobOxOo͂sȂǂ𒲂ׂB
	 * @return fobOxOo͂sȂꍇ trueB
	 */
	public abstract boolean isDebugEnabled();

	/**
	 * 񃌃x̃Oo͂sȂB
	 * @param serviceInfo ݎsĂ service ɊւB
	 * @param message o̓bZ[WB
	 */
	public abstract void info(ServiceInfo serviceInfo, Object message);

	/**
	 * 񃌃x̃Oo͂sȂB
	 * @param serviceInfo ݎsĂ service ɊւB
	 * @param message o̓bZ[WB
	 * @param t OB
	 */
	public abstract void info(ServiceInfo serviceInfo, Object message, Throwable t);

	/**
	 * 񃌃xOo͂sȂǂ𒲂ׂB
	 * @return 񃌃xOo͂sȂꍇ trueB
	 */
	public abstract boolean isInfoEnabled();

	/**
	 * xx̃Oo͂sȂB
	 * @param serviceInfo ݎsĂ service ɊւB
	 * @param message o̓bZ[WB
	 */
	public abstract void warn(ServiceInfo serviceInfo, Object message);

	/**
	 * xx̃Oo͂sȂB
	 * @param serviceInfo ݎsĂ service ɊւB
	 * @param message o̓bZ[WB
	 * @param t OB
	 */
	public abstract void warn(ServiceInfo serviceInfo, Object message, Throwable t);

	/**
	 * xxOo͂sȂǂ𒲂ׂB
	 * @return xxOo͂sȂꍇ trueB
	 */
	public abstract boolean isWarnEnabled();

	/**
	 * G[x̃Oo͂sȂB
	 * @param serviceInfo ݎsĂ service ɊւB
	 * @param message o̓bZ[WB
	 */
	public abstract void error(ServiceInfo serviceInfo, Object message);

	/**
	 * G[x̃Oo͂sȂB
	 * @param serviceInfo ݎsĂ service ɊւB
	 * @param message o̓bZ[WB
	 * @param t OB
	 */
	public abstract void error(ServiceInfo serviceInfo, Object message, Throwable t);

	/**
	 * G[xOo͂sȂǂ𒲂ׂB
	 * @return G[xOo͂sȂꍇ trueB
	 */
	public abstract boolean isErrorEnabled();

	/**
	 * vIG[x̃Oo͂sȂB
	 * @param serviceInfo ݎsĂ service ɊւB
	 * @param message o̓bZ[WB
	 */
	public abstract void fatal(ServiceInfo serviceInfo, Object message);

	/**
	 * vIG[x̃Oo͂sȂB
	 * @param serviceInfo ݎsĂ service ɊւB
	 * @param message o̓bZ[WB
	 * @param t OB
	 */
	public abstract void fatal(ServiceInfo serviceInfo, Object message, Throwable t);

	/**
	 * vIG[xOo͂sȂǂ𒲂ׂB
	 * @return vIG[xOo͂sȂꍇ trueB
	 */
	public abstract boolean isFatalEnabled();
}
