/*
 *UserAuth.java
 *
 * Copyright (C) 2006 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.spi;

import javax.servlet.ServletException;

import nga.model.User;
import nga.servlet.ServiceInfo;

/**
 * pҔF؂̎dg݁B<br>
 * 
 * ̃NX̎NX́CCX^XϐCNXϐɂԂێĂ͂ȂȂB
 */
public abstract class UserAuth {

	/**
	 * UserAuth 쐬B
	 */
	protected UserAuth() {
	}
	
	/**
	 * UserAuth ̎CX^X擾B
	 * @return UserAuth ̎CX^XB
	 */
	private static UserAuth getInstance(ServiceInfo serviceInfo) {
		return serviceInfo.getSingleInstance(UserAuth.class);
	}

	/**
	 * OCsȂBȉ̏sB
	 *  (1) user ̏ɂĔF؂sȂB
	 *  (2) F؂nj̏ꍇ́C{@link UserStorage#load(ServiceInfo, User)} ĂяoC
	 *  @@ۑꂽpҏoB
	 * @param serviceInfo ݎsĂ service ɊւB
	 * @param user OC郆[UB
	 */
	public static void login(ServiceInfo serviceInfo, User user) throws ServletException {
		getInstance(serviceInfo).handleLogin(serviceInfo, user);
	}
	
	/**
	 * OCsȂB
	 * @param serviceInfo ݎsĂ service ɊւB
	 * @param user OC郆[UB
	 */
	protected abstract void handleLogin(ServiceInfo serviceInfo, User user) throws ServletException;

	/**
	 * OAEgsȂB
	 *  (1) ݂̃ZV𖳌ɂB
	 *  (2) {@link UserStorage#save(ServiceInfo, User)} ĂяoCpҏۑB
	 * @param serviceInfo ݎsĂ service ɊւB
	 */
	public static void logout(ServiceInfo serviceInfo) throws ServletException{
		getInstance(serviceInfo).handleLogout(serviceInfo);
	}
	
	/**
	 * OAEgsȂB
	 * @param serviceInfo ݎsĂ service ɊւB
	 */
	protected abstract void handleLogout(ServiceInfo serviceInfo) throws ServletException;


	/**
	 * OCς݂ user 擾B
	 * @param serviceInfo ݎsĂ service ɊւB
	 */
	public static User getUser(ServiceInfo serviceInfo) {
		return getInstance(serviceInfo).handleGetUser(serviceInfo);
	}
	
	/**
	 * OCς݂ user 擾B
	 * @param serviceInfo ݎsĂ service ɊւB
	 */
	protected abstract User handleGetUser(ServiceInfo serviceInfo);
	
	/**
	 * pX[hݒ菈sȂB
	 * @param serviceInfo ݎsĂ service ɊւB
	 * @param user pX[hݒ菈sȂ[UB
	 */
	public static void setPassword(ServiceInfo serviceInfo, User user) throws ServletException {
		getInstance(serviceInfo).handleSetPassword(serviceInfo, user);
	}

	/**
	 * pX[hݒ菈sȂB
	 * @param serviceInfo ݎsĂ service ɊւB
	 * @param user pX[hݒ菈sȂ[UB
	 */
	protected abstract void handleSetPassword(ServiceInfo serviceInfo, User user) throws ServletException;
}
