/*
 *UserStorage.java
 *
 * Copyright (C) 2006 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.spi;

import javax.servlet.ServletException;

import nga.model.User;
import nga.servlet.ServiceInfo;

/**
 * pҏ̕ۊǏꏊB
 * 
 * ̃NX̎NX́CCX^XϐCNXϐɂԂێĂ͂ȂȂB
 */
public abstract class UserStorage {

	/**
	 * UserStorage 쐬B
	 */
	protected UserStorage() {
	}

	/**
	 * UserStorage ̎CX^X擾B
	 * @return UserStorage ̎CX^XB
	 */
	private static UserStorage getInstance(ServiceInfo serviceInfo) {
		return serviceInfo.getSingleInstance(UserStorage.class);
	}

	/**
	 * w肳ꂽpҏɑ΂ăXg[WɕۑĂ[hB
	 * @param serviceInfo ݎsĂ service ɊւB
	 * @param user pҏB
	 */
	public static void load(ServiceInfo serviceInfo, User user) throws ServletException {
		if(user.isAuthorized()) {
			getInstance(serviceInfo).handleLoad(serviceInfo, user);
		}
	}

	/**
	 * w肳ꂽpҏXg[WɕۑB
	 * @param serviceInfo ݎsĂ service ɊւB
	 * @param user pҏB
	 */
	public static void save(ServiceInfo serviceInfo, User user) throws ServletException {
		if(user.isAuthorized()) {
			getInstance(serviceInfo).handleSave(serviceInfo, user);
		}
	}

	/**
	 * w肳ꂽpҏɑ΂ăXg[WɕۑĂ[hB
	 * @param serviceInfo ݎsĂ service ɊւB
	 * @param user pҏB
	 */
	protected abstract void handleLoad(ServiceInfo serviceInfo, User user) throws ServletException;

	/**
	 * w肳ꂽpҏXg[WɕۑB
	 * @param serviceInfo ݎsĂ service ɊւB
	 * @param user pҏB
	 */
	protected abstract void handleSave(ServiceInfo serviceInfo, User user) throws ServletException;
}
