/*
 *RDB.java
 *
 * Copyright (C) 2006 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.sql;

import java.sql.Connection;

import nga.util.ClassDictionary;

/**
 * RDBB
 */
public abstract class RDB {

	private static ThreadLocal<RDB> rdb = new ThreadLocal<RDB>();
	
	private boolean enabledTransactionControl = true;

	/**
	 * RDB 쐬B
	 */
	protected RDB() {
	}

	/**
	 * RDB ̃CX^X擾B
	 * @return RDBCX^XB
	 */
	public static RDB getInstance() {
		RDB instance = rdb.get();
		if(instance==null) {
			instance = ClassDictionary.getDefaultInstance().newInstance(RDB.class);
			setInstance(instance);
		}
		return instance;
	}

	/**
	 * RDB ̃CX^Xݒ肷B
	 * @param instance RDBCX^XB
	 */
	public static void setInstance(RDB instance) {
		rdb.set(instance);
	}
	
	/**
	 * f[^x[XRlNV擾B
	 * @return f[^x[XRlNVB
	 */
	public static Connection getConnection() {
		return getInstance().handleGetConnection();
	}

	/**
	 * f[^x[XRlNV擾B
	 * @return f[^x[XRlNVB
	 */
	protected abstract Connection handleGetConnection();
	
	/**
	 * f[^x[XRlNVN[YB
	 */
	public static void close() {
		getInstance().handleClose();
	}
	
	/**
	 * f[^x[XRlNVN[YB
	 */
	protected abstract void handleClose();
	
	/**
	 * ̃CX^X̔jsȂB
	 */
	public static void destroy() {
		getInstance().handleDestroy();
	}

	/**
	 * ̃CX^X̔jsȂB
	 */
	protected abstract void handleDestroy();

	/**
	 * gUNVJnB
	 */	
	public static void begin() {
		if(isEnabledTransactionControl()) {
			getInstance().handleBegin();
		}
	}

	/**
	 * gUNVJnB
	 */	
	protected abstract void handleBegin();

	/**
	 * gUNV[obNB
	 */	
	public static void rollback() {
		if(isEnabledTransactionControl()) {
			getInstance().handleRollback();
		}
	}

	/**
	 * gUNV[obNB
	 */	
	protected abstract void handleRollback();

	/**
	 * gUNVR~bgB
	 */	
	public static void commit() {
		if(isEnabledTransactionControl()) {
			getInstance().handleCommit();
		}
	}
	
	/**
	 * gUNVR~bgB
	 */	
	protected abstract void handleCommit();

	/**
	 * begin, commit, rollback ɂgUNV䂪Lǂ𒲂ׂB
	 * @return gUNV䂪Lȏꍇ trueB
	 */
	public static boolean isEnabledTransactionControl() {
		return getInstance().enabledTransactionControl;
	}

	/**
	 * begin, commit, rollback ɂgUNVLɂ邩ǂZbgB
	 * @param enabledTransactionControl gUNVLɂꍇ trueB
	 */
	public static void setEnabledTransactionControl(boolean enabledTransactionControl) {
		getInstance().enabledTransactionControl = enabledTransactionControl;
	}

	
	protected void finalize() throws Throwable {
		super.finalize();
		handleDestroy();
	}
}
