/*
 * SQL.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */
package nga.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

import nga.sql.impl.CallerImpl;
import nga.sql.impl.SelecterImpl;
import nga.sql.impl.UpdaterImpl;

/**
 * SQL IuWFNg쐬pt@NgNXB
 * {@link Selecter Selecter} IuWFNgyсC{@link Updater Updater} IuWFNg쐬B
 */
public abstract class SQL {
	
	private static int queryTimeout = -1;
	private static int maxRows = Integer.MAX_VALUE;
	private static int batchSize = 100;

	/**
	 * SQL 쐬B
	 */
	private SQL() {
	}

	/**
	 * Select p SQL IuWFNg쐬B
	 * @param connection f[^x[XRlNVB
	 * @param resultClass ʊi[IuWFNg̃NXB
	 * @param sql SQLB
	 * @return Select p SQL IuWFNgB
	 */
	public static <R> Selecter<R> createSelecter(Connection connection, Class<? extends R> resultClass, String sql) {
		return new SelecterImpl<R>(connection, resultClass, sql);
	}

	/**
	 * Select p SQL IuWFNg쐬B
	 * @param connection f[^x[XRlNVB
	 * @param resultClass ʊi[IuWFNg̃NXB
	 * @param sql SQLB
	 * @param parameterObject Where ɖߍޒli[Ăp^IuWFNgB
	 * @return Select p SQL IuWFNgB
	 */
	public static <R> Selecter<R> createSelecter(Connection connection, Class<? extends R> resultClass, String sql, Object... parameterObject) {
		Selecter<R> selecter = new SelecterImpl<R>(connection, resultClass, sql, parameterObject);
		selecter.setMaxRows(getDefaultMaxRows());
		selecter.setQueryTimeout(getDefaultQueryTimeout());
		return selecter;
	}

	/**
	 * Update / Insert / Delete p SQL IuWFNg쐬B
	 * @param connection f[^x[XRlNVB
	 * @param sql SQLB
	 * @return Update / Insert / Delete p SQL IuWFNgB
	 */
	public static  Updater createUpdater(Connection connection, String sql) {
		Updater updater = new UpdaterImpl(connection, sql);
		updater.setBatchSize(getDefaultBatchSize());
		return updater;
	}

	/**
	 * XgAhvV[W / XgAht@NVp SQL IuWFNg쐬B
	 * @param connection f[^x[XRlNVB
	 * @param sql SQLB
	 * @return XgAhvV[W / XgAht@NVp  SQL IuWFNgB
	 */
	public static Caller createCaller(Connection connection, String sql) {
		return new CallerImpl(connection, sql);
	}

	/**
	 * Select p SQL IuWFNg쐬B
	 * @param resultClass ʊi[IuWFNg̃NXB
	 * @param sql SQLB
	 * @return Select p SQL IuWFNgB
	 */
	public static <R> Selecter<R> createSelecter(Class<? extends R> resultClass, String sql) {
		return createSelecter(RDB.getConnection(), resultClass, sql);
	}

	/**
	 * Select p SQL IuWFNg쐬B
	 * @param resultClass ʊi[IuWFNg̃NXB
	 * @param sql SQLB
	 * @param parameterObject Where ɖߍޒli[Ăp^IuWFNgB
	 * @return Select p SQL IuWFNgB
	 */
	public static <R> Selecter<R> createSelecter(Class<? extends R> resultClass, String sql, Object... parameterObject) {
		return createSelecter(RDB.getConnection(), resultClass, sql, parameterObject);
	}

	/**
	 * Update / Insert / Delete p SQL IuWFNg쐬B
	 * @param sql SQLB
	 * @return Update / Insert / Delete p SQL IuWFNgB
	 */
	public static  Updater createUpdater(String sql) {
		return createUpdater(RDB.getConnection(), sql);
	}

	/**
	 * XgAhvV[W / XgAht@NVp SQL IuWFNg쐬B
	 * @param sql SQLB
	 * @return XgAhvV[W / XgAht@NVp  SQL IuWFNgB
	 */
	public static Caller createCaller(String sql) {
		return createCaller(RDB.getConnection(), sql);
	}

	/**
	 * SELECT sCw肳ꂽNX̃CX^XXgɊi[ĕԂB
	 * @return SQLsʂi[XgBʂ 0 ̏ꍇ́Cvf 0 ̃XgƂȂB
	 */
	public static <R> List<R> find(Class<? extends R> resultClass, String sql) throws SQLException {
		return SQL.<R>createSelecter(resultClass, sql).find();
	}

	/**
	 * SELECT sCw肳ꂽNX̃CX^XXgɊi[ĕԂB
	 * @return SQLsʂi[XgBʂ 0 ̏ꍇ́Cvf 0 ̃XgƂȂB
	 */
	public static <R> List<R> find(Class<? extends R> resultClass, String sql, Object parameterObject) throws SQLException{
		return SQL.<R>createSelecter(resultClass, sql, parameterObject).find();
	}

	/**
	 * SELECT sCw肳ꂽXgɊi[ĕԂB
	 * @param list ʂ̊i[惊XgB
	 * @return  list Ɠ̃CX^XB
	 */
	public static <R> List<R> find(Class<? extends R> resultClass, String sql, List<R> list) throws SQLException {
		return SQL.<R>createSelecter(resultClass, sql).find(list);
	}

	/**
	 * SELECT sCw肳ꂽXgɊi[ĕԂB
	 * @param list ʂ̊i[惊XgB
	 * @return  list Ɠ̃CX^XB
	 */
	public static <R> List<R> find(Class<? extends R> resultClass, String sql, Object parameterObject, List<R> list) throws SQLException {
		return SQL.<R>createSelecter(resultClass, sql, parameterObject).find(list);
	}

	/**
	 * SELECT sCw肳ꂽIuWFNgɊi[ĕԂB
	 * ʂ 2 ȏ゠ꍇ́C1 ڂ̂ݎw肳ꂽIuWFNgɊi[B
	 * @return  object Ɠ̃CX^XBACʂ 0 ̏ꍇ́CnullB
	 */
	public static <R> R find(Class<? extends R> resultClass, String sql, Object parameterObject, R object) throws SQLException {
		return SQL.<R>createSelecter(resultClass, sql, parameterObject).find(object);
	}

	/**
	 * w肵 SQL sB
	 * @return SQLsʌB
	 * @exception DuplicatedException dG[ꍇB
	 */
	public static int execute(String sql) throws DuplicatedException, SQLException {
		return createUpdater(sql).execute();
	}

	/**
	 * w肵 SQL sB
	 * @param parameterObject SQLɖߍޒli[Ăp^IuWFNgB
	 * @return SQLsʌB
	 * @exception DuplicatedException dG[ꍇB
	 */
	public static int execute(String sql, Object parameterObject) throws DuplicatedException, SQLException {
		return createUpdater(sql).execute(parameterObject);
	}

	/**
	 * w肵 SQL ꊇsB<br>
	 * w肳ꂽp^IuWFNǧ PreparedStatement.executeUpdate() sB
	 * @param parameterObjectList SQLɖߍޒli[Ăp^IuWFNg̃XgB
	 * @return SQLsʌB
	 * @exception DuplicatedException dG[ꍇB
	 */
	public static int[] execute(String sql, List parameterObjectList) throws DuplicatedException, SQLException {
		return createUpdater(sql).execute(parameterObjectList);
	}


	/**
	 * w肵 SQL sB
	 * @return SQLsʌB
	 * @exception DuplicatedException dG[ꍇB
	 */
	public static int call(String sql) throws DuplicatedException, SQLException {
		return createCaller(sql).call();
	}

	/**
	 * w肵 SQL sB
	 * @param parameterObject SQLɖߍޒli[Ăp^IuWFNgB
	 * @return SQLsʌB
	 * @exception DuplicatedException dG[ꍇB
	 */
	public static int call(String sql, Object parameterObject) throws DuplicatedException, SQLException {
		return createCaller(sql).call(parameterObject);
	}



	/**
	 * NG[̃^CAEgԁibj擾B
	 * @return NG[̃^CAEgԁibjB
	 */
	public static int getDefaultQueryTimeout() {
		return queryTimeout;
	}

	/**
	 * NG[̃^CAEgԁibjZbgB
	 * @param queryTimeout NG[̃^CAEgԁibjB
	 */
	public static void setDefaultQueryTimeout(int queryTimeout) {
		SQL.queryTimeout = queryTimeout;
	}

	/**
	 * ʂ̍ős擾B
	 * @return ʂ̍ősB
	 */
	public static int getDefaultMaxRows() {
		return maxRows;
	}

	/**
	 * ʂ̍ősZbgB
	 * @param maxRows ʂ̍ősB
	 */
	public static void setDefaultMaxRows(int maxRows) {
		SQL.maxRows = maxRows;
	}
	
	/**
	 * ftHgꊇs擾B
	 * @return ꊇsB
	 */
	public static int getDefaultBatchSize() {
		return batchSize;
	}

	/**
	 * ftHgꊇsZbgB
	 * @param size ꊇsB
	 */
	public static void setDefaultBatchSize(int size) {
		SQL.batchSize = size;
	}

}
