/*
 *XSQL.java
 *
 * Copyright (C) 2006 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.sql;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import nga.util.ConfigurationException;
import nga.util.Resource;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;


/**
 * XML ɂ`t@Cg SQL IuWFNg쐬pt@NgNXB
 */
public class XSQL {

	private static XSQL instance = new XSQL();
	private DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
	private Map<String, SQLDefinition> sqlMap = new HashMap<String, SQLDefinition>();
	private int queryTimeout = -1;
	private int maxRows = Integer.MAX_VALUE;
	private int batchSize = 100;

	/**
	 * XSQL 쐬B
	 */
	private XSQL() {
	}

	/**
	 * XSQL ̃CX^X擾B
	 * @return XSQL ̃CX^XB
	 */
	private static XSQL getInstance() {
		return instance;
	}
	
	/**
	 * Select p SQL IuWFNg쐬B
	 * @param connection f[^x[XRlNVB
	 * @param sqlId SQL`IDB
	 * @return Select p SQL IuWFNgB
	 */
	public static <R> Selecter<R> createSelecter(Connection connection, String sqlId) {
		return createSelecter(connection, sqlId, null);
	}

	/**
	 * Select p SQL IuWFNg쐬B
	 * @param connection f[^x[XRlNVB
	 * @param sqlId SQL`IDB
	 * @param parameterObject p^IuWFNgB
	 * @return Select p SQL IuWFNgB
	 */
	public static <R> Selecter<R> createSelecter(Connection connection, String sqlId, Object parameterObject) {
		try {
			SQLDefinition def = getInstance().getSQLDefinition(sqlId, null);
			@SuppressWarnings("unchecked")
			Selecter<R> selecter = SQL.createSelecter(connection, def.getResultClass(), def.getSQL(), parameterObject);
			selecter.setMaxRows(getDefaultMaxRows());
			selecter.setQueryTimeout(getDefaultQueryTimeout());
			def.updateSelecter(selecter);
			return selecter;
		}
		catch (ConfigurationException e) {
			throw e;
		}
		catch (Exception e) {
			throw new ConfigurationException(e);
		}
	}

	/**
	 * Update / Insert / Delete p SQL IuWFNg쐬B
	 * @param connection f[^x[XRlNVB
	 * @param sqlId SQL`IDB
	 * @return Update / Insert / Delete p SQL IuWFNgB
	 */
	public static  Updater createUpdater(Connection connection, String sqlId) {
		try {
			SQLDefinition def = getInstance().getSQLDefinition(sqlId, null);
			Updater updater = SQL.createUpdater(connection, def.getSQL());
			updater.setBatchSize(getDefaultBatchSize());
			return updater;
		}
		catch (ConfigurationException e) {
			throw e;
		}
		catch (Exception e) {
			throw new ConfigurationException(e);
		}
	}

	/**
	 * XgAhvV[W / XgAht@NVp SQL IuWFNg쐬B
	 * @param connection f[^x[XRlNVB
	 * @param sqlId SQL`IDB
	 * @return XgAhvV[W / XgAht@NVp  SQL IuWFNgB
	 */
	public static Caller createCaller(Connection connection, String sqlId) {
		try {
			SQLDefinition def = getInstance().getSQLDefinition(sqlId, null);
			Caller caller = SQL.createCaller(connection, def.getSQL());
			return caller;
		}
		catch (ConfigurationException e) {
			throw e;
		}
		catch (Exception e) {
			throw new ConfigurationException(e);
		}
	}

	/**
	 * Select p SQL IuWFNg쐬B
	 * @param sqlId SQL`IDB
	 * @return Select p SQL IuWFNgB
	 */
	public static <R> Selecter<R> createSelecter(String sqlId) {
		return createSelecter(RDB.getConnection(), sqlId);
	}

	/**
	 * Select p SQL IuWFNg쐬B
	 * @param sqlId SQL`IDB
	 * @param parameterObject p^IuWFNgB
	 * @return Select p SQL IuWFNgB
	 */
	public static <R> Selecter<R> createSelecter(String sqlId, Object parameterObject) {
		return createSelecter(RDB.getConnection(), sqlId, parameterObject);
	}

	/**
	 * Update / Insert / Delete p SQL IuWFNg쐬B
	 * @param sqlId SQL`IDB
	 * @return Update / Insert / Delete p SQL IuWFNgB
	 */
	public static  Updater createUpdater(String sqlId) {
		return createUpdater(RDB.getConnection(), sqlId);
	}

	/**
	 * XgAhvV[W / XgAht@NVp SQL IuWFNg쐬B
	 * @param sqlId SQL`IDB
	 * @return XgAhvV[W / XgAht@NVp  SQL IuWFNgB
	 */
	public static Caller createCaller(String sqlId) {
		return createCaller(RDB.getConnection(), sqlId);
	}

	/**
	 * SELECT sCw肳ꂽNX̃CX^XXgɊi[ĕԂB
	 * @return SQLsʂi[XgBʂ 0 ̏ꍇ́Cvf 0 ̃XgƂȂB
	 */
	public static <R> List<R> find(String sqlId) throws SQLException {
		return XSQL.<R>createSelecter(sqlId).find();
	}

	/**
	 * SELECT sCw肳ꂽNX̃CX^XXgɊi[ĕԂB
	 * @return SQLsʂi[XgBʂ 0 ̏ꍇ́Cvf 0 ̃XgƂȂB
	 */
	public static <R> List<R> find(String sqlId, Object parameterObject) throws SQLException{
		return XSQL.<R>createSelecter(sqlId, parameterObject).find();
	}

	/**
	 * SELECT sCw肳ꂽXgɊi[ĕԂB
	 * @param list ʂ̊i[惊XgB
	 * @return  list Ɠ̃CX^XB
	 */
	public static <R> List<R> find(String sqlId, List<R> list) throws SQLException {
		return XSQL.<R>createSelecter(sqlId).find(list);
	}

	/**
	 * SELECT sCw肳ꂽXgɊi[ĕԂB
	 * @param list ʂ̊i[惊XgB
	 * @return  list Ɠ̃CX^XB
	 */
	public static <R> List<R> find(String sqlId, Object parameterObject, List<R> list) throws SQLException {
		return XSQL.<R>createSelecter(sqlId, parameterObject).find(list);
	}

	/**
	 * SELECT sCw肳ꂽIuWFNgɊi[ĕԂB
	 * ʂ 2 ȏ゠ꍇ́C1 ڂ̂ݎw肳ꂽIuWFNgɊi[B
	 * @return  object Ɠ̃CX^XBACʂ 0 ̏ꍇ́CnullB
	 */
	public static <R> R find(String sqlId, Object parameterObject, R object) throws SQLException {
		return XSQL.<R>createSelecter(sqlId, parameterObject).find(object);
	}

	/**
	 * w肵 SQL sB
	 * @return SQLsʌB
	 * @exception DuplicatedException dG[ꍇB
	 */
	public static int execute(String sqlId) throws DuplicatedException, SQLException {
		return createUpdater(sqlId).execute();
	}

	/**
	 * w肵 SQL sB
	 * @param parameterObject SQLɖߍޒli[Ăp^IuWFNgB
	 * @return SQLsʌB
	 * @exception DuplicatedException dG[ꍇB
	 */
	public static int execute(String sqlId, Object parameterObject) throws DuplicatedException, SQLException {
		return createUpdater(sqlId).execute(parameterObject);
	}

	/**
	 * w肵 SQL ꊇsB<br>
	 * w肳ꂽp^IuWFNǧ PreparedStatement.executeUpdate() sB
	 * @param parameterObjectList SQLɖߍޒli[Ăp^IuWFNg̃XgB
	 * @return SQLsʌB
	 * @exception DuplicatedException dG[ꍇB
	 */
	public static int[] execute(String sqlId, List parameterObjectList) throws DuplicatedException, SQLException {
		return createUpdater(sqlId).execute(parameterObjectList);
	}

	/**
	 * w肵 SQL sB
	 * @return SQLsʌB
	 * @exception DuplicatedException dG[ꍇB
	 */
	public static int call(String sqlId) throws DuplicatedException, SQLException {
		return createCaller(sqlId).call();
	}

	/**
	 * w肵 SQL sB
	 * @param parameterObject SQLɖߍޒli[Ăp^IuWFNgB
	 * @return SQLsʌB
	 * @exception DuplicatedException dG[ꍇB
	 */
	public static int call(String sqlId, Object parameterObject) throws DuplicatedException, SQLException {
		return createCaller(sqlId).call(parameterObject);
	}

	/**
	 * NG[̃^CAEgԁibj擾B
	 * @return NG[̃^CAEgԁibjB
	 */
	public static int getDefaultQueryTimeout() {
		return getInstance().queryTimeout;
	}

	/**
	 * NG[̃^CAEgԁibjZbgB
	 * @param queryTimeout NG[̃^CAEgԁibjB
	 */
	public static void setDefaultQueryTimeout(int queryTimeout) {
		getInstance().queryTimeout = queryTimeout;
	}

	/**
	 * ʂ̍ős擾B
	 * @return ʂ̍ősB
	 */
	public static int getDefaultMaxRows() {
		return getInstance().maxRows;
	}

	/**
	 * ʂ̍ősZbgB
	 * @param maxRows ʂ̍ősB
	 */
	public static void setDefaultMaxRows(int maxRows) {
		getInstance().maxRows = maxRows;
	}
	
	/**
	 * ftHgꊇs擾B
	 * @return ꊇsB
	 */
	public static int getDefaultBatchSize() {
		return getInstance().batchSize;
	}

	/**
	 * ftHgꊇsZbgB
	 * @param size ꊇsB
	 */
	public static void setDefaultBatchSize(int size) {
		getInstance().batchSize = size;
	}

	/**
	 * SQL `擾B
	 * @param id SQL `IDB
	 * @param path pXB
	 * @return SQL `B
	 */
	private SQLDefinition getSQLDefinition(String id, String path) throws SAXException, IOException, ParserConfigurationException {
		SQLDefinition sql = sqlMap.get(id);
		if(sql==null) {
			int index = id.indexOf('#');
			if(index <= 0) {
				if(path==null) {
					throw new ConfigurationException(message("invalid_id"));
				}
				sql = sqlMap.get(path + "#" + id);
				if(sql!=null) {
					return sql;
				}
			}
			else {
				path = id.substring(0, index);
			}

			load(path);
			sql = sqlMap.get(id);
			if(sql==null) {
				throw new ConfigurationException(message("no_such_sqldef", id));
			}
		}
		return sql;
	}

	
	/**
	 * w肳ꂽpX̃\[X[hB
	 * @param path
	 */
	private void load(String path) throws SAXException, IOException, ParserConfigurationException {
		Document doc = 
			builderFactory.newDocumentBuilder().parse(new BufferedInputStream(getClassLoader().getResourceAsStream(path)));
		NodeList list = doc.getElementsByTagName("sql");
		for(int i=0; i<list.getLength(); i++) {
			Node node = list.item(i);
			NamedNodeMap attr = node.getAttributes();

			Node idNode = attr.getNamedItem("id");
			if(idNode==null) {
				throw new ConfigurationException(message("invalid_sql_tag"));
			}
			sqlMap.put(path + "#" + idNode.getNodeValue(), new SQLDefinition(node, attr, path));
		}
	}
	
	private ClassLoader getClassLoader() {
		return XSQL.class.getClassLoader();
	}
	
	private class SQLDefinition {
		private String className;
		private Class cls;
		private List<SQLFragment> fragments = new ArrayList<SQLFragment>();
		private String sql;
		private int index;
		private String path;
		
		SQLDefinition(Node node, NamedNodeMap attr, String path) {
			this.path = path;
			Node classNode = attr.getNamedItem("class");
			if(classNode!=null) {
				className = classNode.getNodeValue();
			}
			
			NodeList nodeList = node.getChildNodes();
			for(int i=0; i<nodeList.getLength(); i++) {
				SQLFragment sqlFragment = new SQLFragment(nodeList.item(i));
				if(i==0 && (sqlFragment.type!=TEXT && sqlFragment.type!=INCLUDE)) {
					throw new ConfigurationException(message("invalid_sqldef", nodeList.item(i).getNodeName()));
				}
				fragments.add(sqlFragment);
			}
		}
		
		Class getResultClass() throws ClassNotFoundException {
			if(className==null) {
				return null;
			}
			if(cls==null) {
				cls = Class.forName(className);
			}
			return cls;
		}
		
		String getSQL() throws SAXException, IOException, ParserConfigurationException {
			if(sql==null) {
				StringBuilder sb = new StringBuilder();
				int i=0;
				for(; i<fragments.size(); i++) {
					SQLFragment fragment = fragments.get(i);
					if(fragment.type==TEXT) {
						sb.append(fragment.text).append(' ');
					}
					else if(fragment.type==INCLUDE) {
						SQLDefinition def = getSQLDefinition(fragment.includeId, path);
						sb.append(def.getSQL()).append(' ');
					}
					else {
						break;
					}
				}
				index = i;
				sql = new String(sb);
			}
			return sql;
		}
		
		@SuppressWarnings("unchecked") 
		void updateSelecter(Selecter selecter) throws SAXException, IOException, ParserConfigurationException {
			for(int i=index; i<fragments.size(); i++) {
				SQLFragment fragment = fragments.get(i);
				if(fragment.type==TEXT) {
					selecter.add(fragment.text);
				}
				else if(fragment.type==INCLUDE) {
					SQLDefinition def = getSQLDefinition(fragment.includeId, path);
					selecter.add(def.getSQL());
				}
				else if(fragment.type==ADD){
					selecter.add(fragment.text, fragment.connector, fragment.ifEmpty);
				}
				else if(fragment.type==AND) {
					selecter.and(fragment.text, fragment.ifEmpty);
				}
				else if(fragment.type==OR) {
					selecter.or(fragment.text, fragment.ifEmpty);
				}
			}
		}
	}
	
	private class SQLFragment {
		private int type;
		private String text;
		private String ifEmpty;
		private String connector;
		private String includeId;

		SQLFragment(Node node) {
			if(node.getNodeType()==Node.TEXT_NODE) {
				text = node.getNodeValue();
				type = TEXT;
			}
			else {
				NamedNodeMap attr = node.getAttributes();
				String name = node.getNodeName();
				if("add".equalsIgnoreCase(name)) {
					type = ADD;
				}
				else if("and".equalsIgnoreCase(name)) {
					type = AND;
				}
				else if("or".equalsIgnoreCase(name)) {
					type = OR;
				}
				else if("include".equalsIgnoreCase(name)) {
					type = INCLUDE;
					includeId = getAttr(attr, "id");
					if(includeId==null) {
						throw new ConfigurationException(message("invalid_include_tag"));
					}
					return;
				}
				
				ifEmpty = getAttr(attr, "if-empty");
				connector = getAttr(attr, "connector");
				NodeList child = node.getChildNodes();
				if(child!=null && child.getLength()>0) {
					text = child.item(0).getNodeValue();
				}
				if(text==null) {
					throw new ConfigurationException(message("invalid_sql_tag_child", node.getNodeName()));
				}
			}
					}
		public String toString() {
			return type +":"+text+";"+ifEmpty+":"+connector+":"+includeId;
		}

		private String getAttr(NamedNodeMap attr, String name) {
			Node node = attr.getNamedItem(name);
			if(node!=null) {
				return node.getNodeValue();
			}
			else {
				return null;
			}
		}
	}
	
	private static final int TEXT = 0;
	private static final int ADD = 1;
	private static final int AND = 2;
	private static final int OR = 3;
	private static final int INCLUDE = 4;
	
	/**
	 * bZ[W擾sȂB
	 * @param key bZ[WL[B
	 * @param args bZ[WB
	 */
	private String message(String key, Object... args) {
		return Resource.getMessage(getClass().getPackage().getName() + ".Message", key, args);
	}

}
