/*
 * UpdaterImpl.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */
package nga.sql.impl;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import nga.sql.DuplicatedException;
import nga.sql.Updater;
import nga.util.ConfigurationException;

/**
 * Updater ̎NXB
 */
public class UpdaterImpl extends SQLImplBase implements Updater {
	
	private int batchSize;
	private int counter;
	private List<int[]> rcList;

	/**
	 * UpdaterImpl 쐬B
	 * @param con f[^x[XRlNVB
	 * @param sql SQLB
	 */
	public UpdaterImpl(Connection con, String sql) {
		super(con, sql);
	}

	/**
	 * {@link #execute(List)} s̈ꊇsw肷B
	 * @param size ꊇsB
	 */
	public void setBatchSize(int size) {
		this.batchSize = size;
	}
	
	/**
	 * {@link #execute(List)} s̈ꊇs擾B
	 * @return ꊇsB
	 */
	public int getBatchSize() {
		return batchSize;
	}

	/**
	 * w肵 SQL ꊇsB
	 * w肳ꂽp^IuWFNǧ PreparedStatement.executeUpdate() sB
	 * @param params SQLɖߍރp^IuWFNg̃XgB
	 * @return SQLsʌB
	 */
	public int[] execute(List params) throws DuplicatedException, SQLException  {
		// ob`XV\H
		if(connection.getMetaData().supportsBatchUpdates() && batchSize > 1) {
			// addBatch() ... executeBatch() s
			return executeBatch1(params);
		}
		else {
			// executeUpdate() [vs
			return executeBatch2(params);
		}
	}


	/**
	 * addBatch() ... executeBatch() ŕSQLssB
	 * @param params SQLɖߍރp^IuWFNg̃XgB
	 * @param batchSize ꊇsB
	 */
	@SuppressWarnings("unchecked")
	private int[] executeBatch1(List params) throws DuplicatedException, SQLException {
		long startTime = start();
		
		PreparedStatement ps = getPreparedStatement();

		try {
			for(int i=0; i<params.size(); i++) {
				addBatch0(ps, params.get(i));
			}
			return executeBatch0();
		}
		finally {
			end(startTime);
		}
	}

	/**
	 * executeUpdate() ̃[vsŕSQLssB
	 * @param params SQLɖߍރp^IuWFNg̃XgB
	 */
	@SuppressWarnings("unchecked")
	private int[] executeBatch2(List params) throws DuplicatedException, SQLException {
		PreparedStatement ps = getPreparedStatement();

		long startTime = start();

		Class c = null;
		if(params.size()>0) {
			c = params.get(0).getClass();
		}
		initParameterList(c);
		try {
			int[] rc = new int[params.size()];
			for(int i=0; i<rc.length; i++) {
				rc[i] = execute0(params.get(i), ps);
			}
			return rc;
		}
		finally {
			close();
			end(startTime);
		}
	}

	/**
	 * w肵 SQL ꊇsB
	 * @param statement PreparedStatementB
	 * @param parameterObject SQLɖߍޒli[Ăp^IuWFNgB
	 * @exception DuplicatedException dG[ꍇB
	 */
	public void addBatch(Object parameterObject) throws DuplicatedException, SQLException {
		long startTime = start();
		try {
			addBatch0(getPreparedStatement(), parameterObject);
		}
		finally {
			end(startTime);
		}
	}

	/**
	 * w肵 SQL ꊇsB
	 * @exception DuplicatedException dG[ꍇB
	 */
	public int[] executeBatch() throws DuplicatedException, SQLException {
		long startTime = start();
		try {
			return executeBatch0();
		}
		finally {
			end(startTime);
		}
	}

	/**
	 * w肵 SQL ꊇsB
	 * @exception DuplicatedException dG[ꍇB
	 */
	private int[] executeBatch0() throws DuplicatedException, SQLException {
		try {
			int rest = (counter - 1) % batchSize;
			if(rest > 0) {
				if(rcList==null) {
					rcList = new ArrayList<int[]>();
				}
				rcList.add(getPreparedStatement().executeBatch());
			}
			int length = 0;
			for(int i=0; i<rcList.size(); i++) {
				length += rcList.get(i).length;
			}
			int[] rc = new int[length];
			int pos = 0;
			for(int i=0; i<rcList.size(); i++) {
				int[] tmp = rcList.get(i);
				System.arraycopy(tmp, 0, rc, pos, tmp.length);
				pos += tmp.length;
			}
			return rc;
		}
		catch(SQLException e) {
			if("23000".equals(e.getSQLState())) {
				throw new DuplicatedException(e);
			}
			else {
				throw e;
			}
		}
		catch(Exception e) {
			throw new ConfigurationException(e.getMessage(), e);
		}
		finally {
			close();
		}
	}
	
	/**
	 * w肵 SQL sB
	 * @param ps PreparedStatementB
	 * @param parameterObject SQLɖߍޒli[Ăp^IuWFNgB
	 * @exception DuplicatedException dG[ꍇB
	 */
	private void addBatch0(PreparedStatement ps, Object parameterObject) throws DuplicatedException, SQLException {
		if(parameterObject!=null && !isInitialiizedParameterList()) {
			initParameterList(parameterObject.getClass());
		}

		try {
			if(parameterObject!=null) {
				setParameter(ps, parameterObject);
			}

			printSQL(getParsedSQL(), parameterObject);

			ps.addBatch();
			if(counter!=0 && (counter % batchSize)== 0) {
				if(rcList==null) {
					rcList = new ArrayList<int[]>();
				}
				rcList.add(ps.executeBatch());
			}
			counter++;
		}
		catch(InvocationTargetException e) {
			throw new ConfigurationException(e.getCause().getMessage(), e.getCause());
		}
		catch(SQLException e) {
			if("23000".equals(e.getSQLState())) {
				throw new DuplicatedException(e);
			}
			else {
				throw e;
			}
		}
		catch(Exception e) {
			throw new ConfigurationException(e.getMessage(), e);
		}
	}

	/**
	 * w肵 SQL sB
	 * @return SQLsʌB
	 */
	public int execute() throws DuplicatedException, SQLException  {
		return execute((Object)null);
	}

	/**
	 * w肵 SQL sB
	 * @param params SQLɖߍރp^IuWFNgB
	 * @return SQLsʌB
	 */
	public int execute(Object params) throws DuplicatedException, SQLException  {
		return execute(getPreparedStatement(), params);
	}

	/**
	 * w肵 SQL sB
	 * @param ps PreparedStatementB
	 * @param params SQLɖߍޒli[Ăp^IuWFNgB
	 * @return SQLsʌB
	 * @exception DuplicatedException dG[ꍇB
	 */
	private int execute(PreparedStatement ps, Object params) throws DuplicatedException, SQLException {
		long startTime = start();

		Class c = null;
		if(params!=null) {
			c = params.getClass();
		}
		initParameterList(c);
		try {
			return execute0(params, ps);
		}
		finally {
			end(startTime);
			close();
		}
	}

	/**
	 * w肵 SQL sB
	 * @param params SQLɖߍރp^IuWFNgB
	 * @param sql s SQL B
	 * @return sʌB
	 */
	private int execute0(Object params, PreparedStatement ps) throws DuplicatedException, SQLException {
		try {
			if(params!=null) {
				setParameter(ps, params);
			}

			printSQL(getParsedSQL(), params);

			return executeUpdate(ps, params);
		}
		catch(InvocationTargetException e) {
			throw new ConfigurationException(e.getCause().getMessage(), e.getCause());
		}
		catch(SQLException e) {
			if("23000".equals(e.getSQLState())) {
				throw new DuplicatedException(e);
			}
			else {
				throw e;
			}
		}
		catch(Exception e) {
			throw new ConfigurationException(e.getMessage(), e);
		}
	}
		
	/**
	 * SQL sB
	 * @param ps
	 * @return sʌB
	 * @throws SQLException
	 */
	@SuppressWarnings("all")
	protected int executeUpdate(PreparedStatement ps, Object params) throws SQLException, IllegalAccessException, InvocationTargetException {
		return ps.executeUpdate();		
	}
	
	/**
	 * N[YsȂB
	 */
	protected void close() {
		counter = 0;
		super.close();
	}


}
