/*
 *ClassDictionary.java
 *
 * Copyright (C) 2006 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Map.Entry;


/**
 * NXB
 */
public class ClassDictionary {
	
	private static ClassDictionary defaultInstance;
	
	private Map<Class, Class> dictionary = new HashMap<Class, Class>();
	private Map<Class, Object> singleInstance = new HashMap<Class, Object>();

	/**
	 * ClassDictionary 쐬B
	 */
	public ClassDictionary() {
	}
	
	/**
	 * ClassDictionary 쐬B
	 * @param props NX`B
	 */
	public ClassDictionary(Properties props) throws ClassNotFoundException {
		init();
		init(props);
	}
	
	/**
	 * ClassDictionary 쐬B
	 * @param path NX`t@C̃pXB
	 */
	public ClassDictionary(String path) throws ClassNotFoundException, IOException {
		init();
		init(new FileInputStream(path));
	}
	
	/**
	 * ftHgCX^XŏB
	 */
	private void init() {
		ClassDictionary di = getDefaultInstance();
		this.dictionary.putAll(di.dictionary);
		this.singleInstance.putAll(di.singleInstance);
	}

	/**
	 * ClassDictionary 쐬B
	 * @param is NX`t@CB
	 */
	private void init(InputStream is) throws ClassNotFoundException, IOException {
		Properties props = new Properties();
		props.load(is);
		init(props);
	}
	
	@SuppressWarnings("unchecked")
	private void init(Properties props) throws ClassNotFoundException {
		for(Entry<Object, Object> entry : props.entrySet()) {
			Class c1 = Class.forName((String)entry.getKey());
			Class c2 = Class.forName((String)entry.getValue());
			setClassImplements(c1, c2);
		}
	}
	
	/**
	 * ClassDictionary ̃ftHgCX^X擾B
	 */
	public static ClassDictionary getDefaultInstance() {
		if(defaultInstance==null) {
			ClassDictionary cd = new ClassDictionary();
			try {
				Properties props = new Properties();
				ResourceBundle bundle = ResourceBundle.getBundle("nga.util.resource.ClassDictionary");
				for(Enumeration<String> en = bundle.getKeys(); en.hasMoreElements(); ) {
					String key = en.nextElement();
					props.put(key, bundle.getString(key));
				}
				cd.init(props);
			}
			catch (Exception e) {
				throw new ConfigurationException(e);
			}
			defaultInstance = cd;
		}
		return defaultInstance;
	}
	
	/**
	 * w肵NX̃CX^X쐬B
	 * @param cls CX^X쐬NXB
	 * @return 쐬CX^XB
	 */
	@SuppressWarnings("unchecked")
	public <T> T newInstance(Class<T> cls) {
		if(cls==null) {
			throw new ConfigurationException("cls argument is null");
		}

		Class<T> c = (Class<T>) getClassImplements(cls);
		if(c==null) {
			c = cls;
		}

		try {
			return c.newInstance();
		}
		catch(Exception e) {
			throw new ConfigurationException(c.getName(), e);
		}
	}

	/**
	 * w肵NX̃CX^X擾B
	 * ̃\bhō쐬ꂽCX^Xɂꍇ́C
	 * 쐬ς݂̃CX^XԂB
	 * @param cls CX^X擾NXB
	 * @return 擾CX^XB
	 */
	@SuppressWarnings("unchecked")
	public <T> T getSingleInstance(Class<T> cls) {
		T instance = (T)singleInstance.get(cls);
		if(instance==null) {
			instance = newInstance(cls);
			singleInstance.put(cls, instance);
		}
		return instance;
	}
	
	/**
	 * w肵NXĂNXo^B
	 * @param a NXB
	 * @param b a NXB
	 */
	public <T> void setClassImplements(Class<T> a, Class<? extends T> b) {
		dictionary.put(a, b);
	}
	
	/**
	 * w肵ۃNXĂNX擾B<br>
	 * Ŏw肷NX́C炩 setClassImplements
	 * \bhŎw肵ĂKvB
	 * @param c NXB
	 * @return NXBNXȂꍇ nullB
	 */
	@SuppressWarnings("unchecked")
	public <T> Class<? extends T> getClassImplements(Class<T> c) {
		return dictionary.get(c);
	}
}
