/*
 *UserLocale.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */
package nga.util;

import java.util.*;


/**
 * pҕʃP[B
 * Xbh[JϐɃP[CX^XێC
 * ݂̗p҂gpĂ郍P[𑼂̃NX画fł悤ɂB
 */
public class UserLocale {

	private static ThreadLocal<Locale> userLocale = new ThreadLocal<Locale>();

	private static Map<Locale, String[]> suffixes = new HashMap<Locale, String[]>();


	/**
	 * ݂̃Xbhɐݒ肳Ă郍P[CX^X擾B
	 */
	public static Locale getLocale() {
		Locale locale = userLocale.get();
		if(locale==null) {
			locale = Locale.getDefault();
		}
		return locale;
	}

	/**
	 * ݂̃XbhŎgp郍P[CX^Xݒ肷B
	 */
	public static void setLocale(Locale locale) {
		userLocale.set(locale);
	}

	/**
	 * ݂̃[U[P[ɑΉt@Cڔ擾B
	 */
	public static String[] getFileSuffix() {
		Locale locale = getLocale();
		String[] s = suffixes.get(locale);
		if(s==null) {
			s = createFileSuffix(locale);
			suffixes.put(locale, s);
		}
		return s;
	}

	private static String[] createFileSuffix(Locale locale) {
		String[] s = new String[3];
		s[0] = "";
		s[1] = "_" + locale.getLanguage();
		s[2] = s[1] + "_" + locale.getCountry();
		return s;
	}
	
	/**
	 * P[P[ɕϊB
	 */
	public static Locale valueOf(String localeString) {
		String[] s = {"","",""};
		StringTokenizer st = new StringTokenizer(localeString, "_");
		for(int i=0; i<s.length && st.hasMoreTokens(); i++) {
			s[i] = st.nextToken();
		}
		return new Locale(s[0], s[1], s[2]);
	}

}
