/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.comm;

import java.util.Date;
import java.util.HashMap;
import jp.co.connectone.comm.CmdBase;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.pim.ITaskDTO;
import jp.co.connectone.store.pim.ITaskStore;
import jp.co.connectone.user.IAccountData;

public class TaskStoreCmd
extends CmdBase {
    public static final TaskStoreCmd createNewTask = new TaskStoreCmd();
    public static final TaskStoreCmd getTasksByDate = new TaskStoreCmd();
    public static final TaskStoreCmd updateTask = new TaskStoreCmd();
    public static final TaskStoreCmd getTaskByOID = new TaskStoreCmd();
    public static final TaskStoreCmd deleteTask = new TaskStoreCmd();
    public static final TaskStoreCmd getAllTasks = new TaskStoreCmd();

    protected TaskStoreCmd() {
    }

    public TaskStoreCmd(IAccountData accData, String remoteClassName, CmdBase cmd, HashMap params) {
        super(accData, remoteClassName, cmd, params);
    }

    public int getRetType() throws HandleException {
        try {
            return super.getRetType();
        }
        catch (HandleException handleException) {
            if (this.cmd == deleteTask || this.cmd == updateTask) {
                return 0;
            }
            if (this.cmd == getAllTasks || this.cmd == getTasksByDate) {
                return 2;
            }
            if (this.cmd == createNewTask || this.cmd == getTaskByOID) {
                return 1;
            }
            throw new HandleException("unknown cmd type.");
        }
    }

    public IRecordObject[] runMulti() throws HandleException {
        IRecordObject[] rc = null;
        ITaskStore remoteClass = (ITaskStore)this.getRemoteClass();
        if (this.cmd == getTasksByDate) {
            Date param1 = (Date)this.params.get("param1");
            rc = remoteClass.getTasksByDate(this.accData, param1);
        } else if (this.cmd == getAllTasks) {
            rc = remoteClass.getAllTasks(this.accData);
        } else {
            throw new HandleException("unknown cmd type.");
        }
        return rc;
    }

    public IRecordObject runSingle() throws HandleException {
        IRecordObject rc = null;
        ITaskStore remoteClass = (ITaskStore)this.getRemoteClass();
        if (this.cmd == createNewTask) {
            ITaskDTO param1 = (ITaskDTO)this.params.get("param1");
            rc = remoteClass.createNewTask(this.accData, param1);
        } else if (this.cmd == getTaskByOID) {
            IObjectIndex param1 = (IObjectIndex)this.params.get("param1");
            rc = remoteClass.getTaskByOID(this.accData, param1);
        } else {
            throw new HandleException("unknown cmd type.");
        }
        return rc;
    }

    public void runVoid() throws HandleException {
        ITaskStore remoteClass = (ITaskStore)this.getRemoteClass();
        if (this.cmd == deleteTask) {
            IObjectIndex param1 = (IObjectIndex)this.params.get("param1");
            remoteClass.deleteTask(this.accData, param1);
        } else if (this.cmd == updateTask) {
            ITaskDTO param1 = (ITaskDTO)this.params.get("param1");
            remoteClass.updateTask(this.accData, param1);
        } else {
            throw new HandleException("unknown cmd type.");
        }
    }
}

