/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.common;

import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import jp.co.connectone.exception.HandleException;

public class DNSTool {
    protected String dnsServerIP = null;

    public DNSTool(String dnsServerIP) {
        this.dnsServerIP = dnsServerIP;
    }

    public String getIPAddress(String name) throws HandleException {
        Properties props = new Properties();
        props.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        props.put("java.naming.provider.url", "dns://" + this.dnsServerIP);
        String retStr = null;
        try {
            InitialDirContext idctx = new InitialDirContext(props);
            Attributes attrs = idctx.getAttributes(name);
            NamingEnumeration<? extends Attribute> allAttr = attrs.getAll();
            while (allAttr.hasMore()) {
                Attribute attr = allAttr.next();
                NamingEnumeration<?> values = attr.getAll();
                if (!values.hasMore()) continue;
                retStr = (String)values.next();
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new HandleException(e);
        }
        return retStr;
    }
}

