/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.store.client;

import java.util.Date;
import java.util.HashMap;
import jp.co.connectone.comm.DBStoreCmd;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.client.IDBStoreClient;
import jp.co.connectone.store.client.StoreClient;
import jp.co.connectone.user.IAccountData;

public class DBStoreClient
extends StoreClient
implements IDBStoreClient {
    public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date startDate) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("param1", dest);
        params.put("param2", startDate);
        DBStoreCmd cmd = new DBStoreCmd(this.userAccount, this.remoteClassName, DBStoreCmd.searchByDate, params);
        this.protocol.functionCall(cmd);
        IRecordObject[] ret = this.protocol.getReturnMulti();
        return ret;
    }

    public IRecordObject[] search(IAccountData acc, ISearchFormula form) throws Exception {
        HashMap<String, ISearchFormula> params = new HashMap<String, ISearchFormula>();
        params.put("param1", form);
        DBStoreCmd cmd = new DBStoreCmd(this.userAccount, this.remoteClassName, DBStoreCmd.search, params);
        this.protocol.functionCall(cmd);
        IRecordObject[] ret = this.protocol.getReturnMulti();
        return ret;
    }

    public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("param1", dest);
        params.put("param2", oid);
        DBStoreCmd cmd = new DBStoreCmd(this.userAccount, this.remoteClassName, DBStoreCmd.read, params);
        this.protocol.functionCall(cmd);
        IRecordObject ret = this.protocol.getReturnSingle();
        return ret;
    }

    public void write(IAccountData acc, ISearchDestination dest, IRecordObject data) throws Exception {
        HashMap<String, IRecordObject> params = new HashMap<String, IRecordObject>();
        params.put("param1", dest);
        params.put("param2", data);
        DBStoreCmd cmd = new DBStoreCmd(this.userAccount, this.remoteClassName, DBStoreCmd.write, params);
        this.protocol.functionCall(cmd);
    }

    public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("param1", dest);
        params.put("param2", oid);
        DBStoreCmd cmd = new DBStoreCmd(this.userAccount, this.remoteClassName, DBStoreCmd.delete, params);
        this.protocol.functionCall(cmd);
    }

    public FolderMetadata[] getFolders(IAccountData acc, ISearchDestination dest) throws Exception {
        HashMap<String, ISearchDestination> params = new HashMap<String, ISearchDestination>();
        params.put("param1", dest);
        DBStoreCmd cmd = new DBStoreCmd(this.userAccount, this.remoteClassName, DBStoreCmd.getFolders, params);
        this.protocol.functionCall(cmd);
        FolderMetadata[] ret = (FolderMetadata[])this.protocol.getReturnMulti();
        return ret;
    }

    public IRecordObject[] getUniqueIndexes(IAccountData acc, ISearchFormula form) throws Exception {
        HashMap<String, ISearchFormula> params = new HashMap<String, ISearchFormula>();
        params.put("param1", form);
        DBStoreCmd cmd = new DBStoreCmd(this.userAccount, this.remoteClassName, DBStoreCmd.getUniqueIndexes, params);
        this.protocol.functionCall(cmd);
        IRecordObject[] ret = this.protocol.getReturnMulti();
        return ret;
    }

    public IRecordObject[] getDataSet(IAccountData acc, ISearchDestination dest, IRecordObject template) throws Exception {
        HashMap<String, IRecordObject> params = new HashMap<String, IRecordObject>();
        params.put("param1", dest);
        params.put("param2", template);
        DBStoreCmd cmd = new DBStoreCmd(this.userAccount, this.remoteClassName, DBStoreCmd.getDataSet, params);
        this.protocol.functionCall(cmd);
        IRecordObject[] ret = this.protocol.getReturnMulti();
        return ret;
    }
}

