/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.store.client;

import java.util.Date;
import java.util.HashMap;
import jp.co.connectone.comm.CmdBase;
import jp.co.connectone.comm.IAccessProtocol;
import jp.co.connectone.comm.StoreCmd;
import jp.co.connectone.store.EnumStoreType;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IFolderIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.IServiceInfo;
import jp.co.connectone.store.IStoreID;
import jp.co.connectone.store.client.IStoreClient;
import jp.co.connectone.user.IAccountData;

public abstract class StoreClient
implements IStoreClient {
    protected IAccountData userAccount;
    protected IAccessProtocol protocol;
    protected String remoteClassName = null;

    public String getRemoteClassName() {
        return this.remoteClassName;
    }

    public IAccessProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(IAccessProtocol protocol) {
        this.protocol = protocol;
    }

    public IAccountData getUserAccount() {
        return this.userAccount;
    }

    public void setUserAccount(IAccountData userAccount) {
        this.userAccount = userAccount;
    }

    public ISearchDestination getPresetDestination(int folderType) throws Exception {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("param1", new Integer(folderType));
        CmdBase cmd = new CmdBase(this.userAccount, this.remoteClassName, CmdBase.getPresetDestination, params);
        this.protocol.functionCall(cmd);
        ISearchDestination ret = (ISearchDestination)this.protocol.getReturnSingle();
        return ret;
    }

    public IFolderIndex getFolderIndexFromString(String path) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("param1", path);
        CmdBase cmd = new CmdBase(this.userAccount, this.remoteClassName, CmdBase.getgetFolderIndexFromString, params);
        this.protocol.functionCall(cmd);
        IRecordObject ret = this.protocol.getReturnSingle();
        return (IFolderIndex)ret.getOid();
    }

    public String getName() throws Exception {
        CmdBase cmd = new CmdBase(this.userAccount, this.remoteClassName, CmdBase.getName, null);
        this.protocol.functionCall(cmd);
        IRecordObject obj = this.protocol.getReturnSingle();
        return (String)obj.getFieldSet().get("name");
    }

    public IServiceInfo getServiceInfo() throws Exception {
        CmdBase cmd = new CmdBase(this.userAccount, this.remoteClassName, CmdBase.getServerInfo, null);
        this.protocol.functionCall(cmd);
        IServiceInfo obj = (IServiceInfo)this.protocol.getReturnSingle();
        return obj;
    }

    public IStoreID getStoreID() throws Exception {
        CmdBase cmd = new CmdBase(this.userAccount, this.remoteClassName, CmdBase.getStoreID, null);
        this.protocol.functionCall(cmd);
        IStoreID obj = (IStoreID)this.protocol.getReturnSingle();
        return obj;
    }

    public EnumStoreType getStoreType() throws Exception {
        CmdBase cmd = new CmdBase(this.userAccount, this.remoteClassName, CmdBase.getStoreType, null);
        this.protocol.functionCall(cmd);
        EnumStoreType obj = (EnumStoreType)this.protocol.getReturnSingle();
        return obj;
    }

    public void delete(ISearchDestination dest, IObjectIndex oid) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("param1", dest);
        params.put("param2", oid);
        StoreCmd cmd = new StoreCmd(this.userAccount, this.remoteClassName, StoreCmd.delete, params);
        this.protocol.functionCall(cmd);
    }

    public IRecordObject[] getAllDatas(ISearchDestination dest) throws Exception {
        HashMap<String, ISearchDestination> params = new HashMap<String, ISearchDestination>();
        params.put("param1", dest);
        StoreCmd cmd = new StoreCmd(this.userAccount, this.remoteClassName, StoreCmd.getAllDatas, params);
        this.protocol.functionCall(cmd);
        IRecordObject[] ret = this.protocol.getReturnMulti();
        return ret;
    }

    public FolderMetadata[] getFolderList(ISearchDestination dest) throws Exception {
        HashMap<String, ISearchDestination> params = new HashMap<String, ISearchDestination>();
        params.put("param1", dest);
        StoreCmd cmd = new StoreCmd(this.userAccount, this.remoteClassName, StoreCmd.getFolderList, params);
        this.protocol.functionCall(cmd);
        FolderMetadata[] ret = (FolderMetadata[])this.protocol.getReturnMulti();
        return ret;
    }

    public IRecordObject read(ISearchDestination dest, IObjectIndex oid) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("param1", dest);
        params.put("param2", oid);
        StoreCmd cmd = new StoreCmd(this.userAccount, this.remoteClassName, StoreCmd.read, params);
        this.protocol.functionCall(cmd);
        IRecordObject ret = this.protocol.getReturnSingle();
        return ret;
    }

    public IRecordObject[] search(ISearchFormula col) throws Exception {
        HashMap<String, ISearchFormula> params = new HashMap<String, ISearchFormula>();
        params.put("param1", col);
        StoreCmd cmd = new StoreCmd(this.userAccount, this.remoteClassName, StoreCmd.search, params);
        this.protocol.functionCall(cmd);
        IRecordObject[] ret = this.protocol.getReturnMulti();
        return ret;
    }

    public IRecordObject[] searchByDate(ISearchDestination dest, Date startDate) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("param1", dest);
        params.put("param2", startDate);
        StoreCmd cmd = new StoreCmd(this.userAccount, this.remoteClassName, StoreCmd.searchByDate, params);
        this.protocol.functionCall(cmd);
        IRecordObject[] ret = this.protocol.getReturnMulti();
        return ret;
    }

    public void write(ISearchDestination dest, IRecordObject data) throws Exception {
        HashMap<String, IRecordObject> params = new HashMap<String, IRecordObject>();
        params.put("param1", dest);
        params.put("param2", data);
        StoreCmd cmd = new StoreCmd(this.userAccount, this.remoteClassName, StoreCmd.write, params);
        this.protocol.functionCall(cmd);
    }
}

