<?php
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------+
// | PHP Version 5                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 2010 Takahiro Ooishi                                   |
// +----------------------------------------------------------------------+
// | This source file is subject to version 3.0 of the PHP license,       |
// | that is bundled with this package in the file LICENSE, and is        |
// | available through the world-wide-web at the following url:           |
// | http://www.php.net/license/3_0.txt.                                  |
// | If you did not receive a copy of the PHP license and are unable to   |
// | obtain it through the world-wide-web, please send a note to          |
// | license@php.net so we can mail you a copy immediately.               |
// +----------------------------------------------------------------------+
// | Author: Takahiro Ooishi <taka0125.biz@gmail.com>                     |
// +----------------------------------------------------------------------+
//
// $Id$

abstract class Converter_Template
{
    abstract function toText($string);
    abstract function toHtml($string);
    abstract protected function isInstalledUseCommand();

    function __construct()
    {
        // コンバートかける度にチェックするのでオーバーヘッドになる。
        // コマンドが実行できなくなる可能性は低いのでチェックを飛ばしても
        // 運用上問題ないかもしれない。
        if (!$this->isInstalledUseCommand()) throw new Exception('essential command is not installed.');
    }
}
